package com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.domain.asa.model.BaseModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.Map;

/**
 * @author hujun
 * @date 2023年1月19日
 */
@Document(collection = "customConfig")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class CustomConfigModel extends BaseModel {
    private String assistantCode;

    private String assistantName;

    private String sceneCode;

    private String sceneName;

    private String itemStepCode;

    private String itemStepName;

    private int itemStepsLength = -1;

    private String templateType;

    /**
     * manual、script 依据任务中是否有需编辑，若都不需编辑则是script
     */
    private String taskType;

    private int itemStepNum = -1;

    private JSONObject itemStepLang;

    private JSONObject sceneLang;

    private String abilityCode;

    private String abilityType;

    private String domain;

    private String method;

    private String url;

    private String contentType;

    private Map<String, Object> headers;

    private String requestScript;

    private String responseScript;

    private  JSONObject assistantSceneItemStep;
}
