package com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb;

import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.asa.model.BaseModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.FieldDescription;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.MatchCondition;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.TagDefinition;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
 * 数据描述
 */
@Document(collection = "dataDescription")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DataDescriptionModel extends BaseModel {
    private FieldDescription dataStruct;
    private List<String> uniKeys;
    private String application;
    private String code;
    private String name;
    private String groupCode;
    private Integer score = AsaConstant.Val.SCORE;
    private List<MatchCondition> matches;
    private List<TagDefinition> tags;
}
