package com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb;

import com.digiwin.athena.domain.core.LifecycleEvent;
import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.asa.model.BaseModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.Condition;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.FieldDescription;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.MatchCondition;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.TagDefinition;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
 *
 */
@Document(collection = "dataState")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DataStateModel extends BaseModel {
    private String dataCode;
    /** 该种数据状态额外的数据结构 */
    private List<FieldDescription> extendFields;
    private List<LifecycleEvent> events;
    private Integer priority = AsaConstant.Val.PRIORITY;
    private String application;
    private String code;
    private String name;
    private String groupCode;
    private String tenantId;
    private Integer score = AsaConstant.Val.SCORE;
    private List<MatchCondition> matches;
    private List<TagDefinition> tags;
    private List<String> dataFeatureSets;
    private Condition condition;
}
