package com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb;

import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.asa.model.BaseModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.FlowLink;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.FlowNode;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.MatchCondition;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.TagDefinition;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
 * 流程图模型
 */
@Document(collection = "flowGraph")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class FlowGraphModel extends BaseModel {
    private List<FlowNode> nodes;
    private List<FlowLink> links;
    private String application;
    private String code;
    private String name;
    private Integer score = AsaConstant.Val.SCORE;
    private List<MatchCondition> matches;
    private List<TagDefinition> tags;
}
