package com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb;

import com.digiwin.athena.km_deployer_service.domain.asa.model.BaseModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

/**
 */
@Document(collection = "pageView")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PageViewModel extends BaseModel {
    private String application;
    private String code;
    private String name;
    private Boolean milestone;
    private Map<String, Object> dataSources;
    /** 数据加工器 */
    private List<Map<String, Object>> dataProcessors;
    /** 数据查询器 */
    private List<Map<String, Object>> dataFilters;
    /** 页面 */
    private Map<String, Object> pages;

}
