package com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb;

import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.asa.model.BaseModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.AtmcData;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.DueDateTimeDistance;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.MatchCondition;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.Phase;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.ProjectTarget;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.TagDefinition;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.UserDefinition;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;

/**
 */
@Document(collection = "project")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class ProjectModel extends BaseModel {
    /** 项目起始状态 */
    private DataStateModel init;
    /** 目标状态 */
    private DataStateModel end;
    /** mainline user solve */
    private String executeType;
    /** BUSINESS FEEDBACK REPORT MECHANISM 需要兼容到 */
    private String type;
    /** 是否支持手动发起 */
    private Boolean manualAble;
    /** 是否支持项目合并 值为null时合并 */
    private Boolean merge;
    private Object sourceName;
    private Object dueDateName;
    /** 来源实体名称 */
    private String sourceEntityName;
    private Boolean assignAble;
    private String pageCode;
    private List<String> mainLineTasks;
    private String application;
    private Boolean daemon;
    private String datamap = AsaConstant.Val.DATAMAP;
    private String code;
    private String name;
    private String groupCode;
    private Integer score = AsaConstant.Val.SCORE;
    private List<MatchCondition> matches;
    private Map<String, Map<String, String>> lang;
    private List<TagDefinition> tags;
    private List<Phase> phases;
    private UserDefinition personInCharge;
    private List<AtmcData> atmcDatas;
    private DueDateTimeDistance dueDateTimeDistance;
    private ProjectTarget target;
    private String primaryProjectCode;
    private Object inputData;
    private Map<String, Object> config;

}
