package com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb;

import com.digiwin.athena.domain.core.LifecycleEvent;
import com.digiwin.athena.domain.definition.times.TimeDefinition;
import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.asa.model.BaseModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.AtmcData;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.DataTagging;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.MatchCondition;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.OverdueRule;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.StateMap;
import com.digiwin.athena.km_deployer_service.domain.asa.model.relevant.TagDefinition;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 */
@Document(collection = "task")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class TaskModel extends BaseModel {
    private Set<String> from;
    private Set<String> to;
    private List<StateMap> stateMaps;
    private List<LifecycleEvent> events;
    private Integer priority = AsaConstant.Val.PRIORITY;
    private TimeDefinition dueDate;
    /** 里程碑任务 */
    private Boolean milestone;
    /** 执行类型 参见ActivityExecuteTypeEnum: MANUAL AUTO */
    private String executeType;
    /** 任务类型 business业务型任务(默认) check检查型 approve签核型 solve异常排除 composite组合型 signal信号型 */
    private String type;
    private String flowCode;
    private String category;
    /** 参见ActivityPatternEnum:  NONE,BUSINESS,ADJUSTMENT,MECHANISM;*/
    private String pattern;
    private String application;
    private Boolean daemon;
    private String datamap = AsaConstant.Val.DATAMAP;
    private String code;
    private String name;
    private List<DataTagging> dataFeatures;
    private String groupCode;
    private String versionNumber;
    private Integer score = AsaConstant.Val.SCORE;
    private List<MatchCondition> matches;
    private Map<String, Map<String,String>> lang;
    private List<TagDefinition> tags;
    private List<AtmcData> atmcDatas;
    private Map<String, Object> config;
    private String pageCode;
    private Object inputData;
    private List<OverdueRule> overdueRules;
    private List<String> startApproveActivity;
    private String startApproveActivityName;
}
