package com.digiwin.athena.km_deployer_service.domain.asa.model.relevant;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;
import java.util.Map;

/**
 * @author zhangzhi@digiwin.com
 * @date 2022/5/23
 */
@Getter
@Setter
@NoArgsConstructor
public class FieldDescription {
    /** 表示当前数据定义应用某种类型数据结构,避免重复定义 */
    private String dataCode;
    private String compositeDataCode;
    /** 数据的业务类型. dataTracker跟踪数据描点 */
    private String businessType;
    private String name;
    private String key;
    private Object value;
    /** 数据类型 BOOLEAN,INTEGER,LONG,DOUBLE,STRING,DATE,ARRAY,OBJECT,VOID */
    private String dataType;
    /** 当type为array时表示内部类型,参见dataType */
    private String componentType;
    private String format;
    /** 表达式或者路径 */
    private String express;
    /** 当dataType=object时 */
    private List<FieldDescription> fields;
    private Boolean required;
    private String description;
    private Map<String, Map<String,String>> lang;
    private List<TagDefinition> tags;

    public FieldDescription(String dataType, List<FieldDescription> fields) {
        this.dataType = dataType;
        this.fields = fields;
    }

    public FieldDescription(String name, String key, String dataType) {
        this.name = name;
        this.key = key;
        this.dataType = dataType;
    }
}
