package com.digiwin.athena.km_deployer_service.domain.asa.model.relevant;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import org.springframework.data.annotation.Id;

import java.util.Map;

/**
 * @author zhangzhi@digiwin.com
 * @date 2022/5/23
 */
@Getter
@Setter
@NoArgsConstructor
public class FlowNode {
    @Id
    private String mongoId;
    private String id;
    private String name;
    /**start|end|gateway|activity|task|plan|event|delegate */
    private String type;
    /** exclusive选择一条|inclusive并行|sequence 顺序执行 |random随机选择|userChoose用户选择|userSort用户排序 */
    private String gateType;
    private String eventType;
    private String activityCode;
    private String endType;
    /** 任务线完成时指向的数据状态节点id */
    private String dataKey;
    private String entityId;
    private Map<String, Object> config;

    public FlowNode(String id, String type) {
        this.id = id;
        this.type = type;
    }

    public FlowNode(String id, String type, String dataKey) {
        this.id = id;
        this.type = type;
        this.dataKey = dataKey;
    }

    public FlowNode(String id, String name, String type, String activityCode) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.activityCode = activityCode;
    }
}
