package com.digiwin.athena.km_deployer_service.domain.asa.model.relevant;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.Map;

/**
 * performerType: user 用户  duty 职能 userSuperior 直接主管 deptDirector 部门主管 deptUser 部门人员 personInCharge 当责者
 * performerValue: eocUserId/dutyId/deptId/deptId/
 *
 * @author zhangzhi@digiwin.com
 */
@Getter
@Setter
@NoArgsConstructor
public class Identity {
    /** 人 职能  部门 operation等等*/
    private String performerType;
    /** 具体的值 如一个人id 或者职能列表等等*/
    private Object performerValue;
    private String performerName;
    /** 执行完活动返回的数据字段*/
    private String performerVariable;

    private Map<String, Object> config;

    public Identity(String performerType, Object performerValue) {
        this.performerType = performerType;
        this.performerValue = performerValue;
    }
}
