package com.digiwin.athena.km_deployer_service.domain.asa.model.relevant;

import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * key支持
 * dataCollectEvent 收集具有相同分组标签的数据再执行
 * 内定tag的key为_groupdata
 * check 检查型任务
 * flowCode指定任务code
 * <p>
 * type切入的位置
 * 支持 beforeEnter before after afterLeave
 *
 * @author zhangzhi@digiwin.com
 * @date 2022/5/23
 **/
@Getter
@Setter
@NoArgsConstructor
public class LifecycleEvent {
    private String key;
    /** beforeEnter before after afterLeave*/
    private String type;
    private Map<String, Object> config;
    private String targetCode;
    /** DataState Task Activity */
    private String targetType;
    /** 是否异步执行 */
    private Boolean async;
    private String flowCode;
    private Integer priority = AsaConstant.Val.PRIORITY;

    private String code;
    private String name;
    private String groupCode;
    private String tenantId;
    private String version = AsaConstant.Val.VERSION;
    private Integer score = AsaConstant.Val.SCORE;
    private List<MatchCondition> matches = new ArrayList<>();
    private Map<String, Map<String, String>> lang;
    private List<TagDefinition> tags = new ArrayList<>();

    public LifecycleEvent(String key, String type, String flowCode) {
        this.key = key;
        this.type = type;
        this.flowCode = flowCode;
    }
}
