package com.digiwin.athena.km_deployer_service.domain.asa.model.relevant;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

/**
 * 参见DAP平台提供的DEV-SDV-509排程服务开发.pdf
 * http://dap.digiwin.com/%E5%9F%B9%E8%AE%AD%E8%AF%BE%E7%A8%8B/3.0.1.1000/API%E5%B9%B3%E5%8F%B0_API/DEV-SDV-509%20%E6%8E%92%E7%A8%8B%E6%9C%8D%E5%8B%99%E9%96%8B%E7%99%BC.pdf
 *  schedule_type 定时类型
 * 0 延迟多久执行
 *  delay_seconds 指定秒
 * 1 指定时间执行
 *   assign_time yyyyMMdd HHmmss
 * 2 周期性执行
 *   month 2,4,6 2-6,
 * 3 复杂周期执行
 *
 * 4 重复规则
 *
 * @author zhangzhi@digiwin.com
 * @date 2022/5/23
 */
@Getter
@Setter
@NoArgsConstructor
public class ScheduleRule {
    /** 是否等待定时规则处理完成 */
    private Boolean waitThis;
    /** 是否立即执行一次 */
    private Boolean executeImmediately;
    /** 停止执行的条件 */
    private String stopCondition;
    private String schedule_name;
    private String exclude_date;
    private String exclude_time;
    private String schedule_type;
    private Object delay_seconds;
    private String assign_time;
    private String month;
    private String day_of_week;
    private String day_of_month;
    private String week_of_month;
    private String time;

    private String start_time;
    private String end_time;
    private Object repeat_type;
    private Object repeat_count;
    private Object frequency;

    private Object minutely;
    private Object hourly;
    private Object daily;
    private Object weekly;
    private Object monthly;
    private Object byday;
    private Object bymonthday;
    private Object byWeeklyday;
    private String r_rule;
}
