package com.digiwin.athena.km_deployer_service.domain.km;

import lombok.Data;

import java.util.List;

/**
 * 发布行为事件实体类
 * @Author QinQiang
 * @Description
 * @Date 2024/1/19
 **/
@Data
public class KmEventParam {
    /**
     * 一次发布行为的唯一标识符
     */
    private String eventId;

    /**
     * 应用code
     */
    private String appCode;

    /**
     * 租户ID列表
     */
    private List<String> tenantIds;

    /**
     * 版本信息
     */
    private String version;

    /**
     * 发布类型（例如：publish, switch）
     */
    private String type;

    /**
     * 发布时间范围，如 'begin' 或 'end'
     */
    private String timeOn;

    /**
     * 发布对象类型（例如：monitor），针对单个作业发布
     */
    private String objectType;

    /**
     * 发布对象代码
     */
    private String objectCode;
}
