package com.digiwin.athena.km_deployer_service.domain.system;

import lombok.Data;

import java.io.Serializable;

@Data
public class ResultBean<T> implements Serializable {


    private static final long serialVersionUID = 1L;


    private Integer code = 0;

    private String msg;

    private T data;

    private String token;

    public ResultBean() {
    }

    public ResultBean(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static <T> ResultBean<T> success(T t) {
        ResultBean<T> result = new ResultBean<>();
        result.setData(t);
        return result;
    }

    public static <T> ResultBean<T> success() {
        ResultBean<T> result = new ResultBean<>();
        result.setData(null);
        return result;
    }

    public static <T> ResultBean<T> fail(Integer code, String msg) {
        return new ResultBean<>(code, msg);
    }


}
