package com.digiwin.athena.km_deployer_service.helper;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.config.ModuleConfig;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;

import java.util.List;

@Component
@Slf4j
public class AniaHelper {

    private static final String DEPLOYER_CACHE = "/ania/athena/assistant/deployerCache";

    @Autowired
    private ModuleConfig moduleConfig;

    public void deployerCache(String token, boolean isCNaDeploy, boolean isDeploy, String assistantCode) {
        JSONObject param = new JSONObject();
        param.put("isCNaDeploy", isCNaDeploy);
        param.put("isDeploy", isDeploy);
        param.put("assistantCode", assistantCode);

        String body = JSON.toJSONString(param);
        String url = moduleConfig.getBNa().getDomain() + DEPLOYER_CACHE;

        try {
            HttpResponse response = HttpUtil.createPost(url).header("digi-middleware-auth-user", token).header("Content-Type", "application/json").body(body).execute();
            log.info("调用ania接口,更新助理缓存#post,url:{},response:{}", url, JSON.toJSONString(response));
        } catch (RestClientException e) {
            log.error("调用ania接口,更新助理缓存异常,url:{},body:{},errMsg:{}",
                    url, body, e.getMessage(), e);
        }
    }

}
