package com.digiwin.athena.km_deployer_service.helper;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.config.ModuleConfig;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import org.apache.http.HttpStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Component
public class IMApiHelper {

    @Autowired
    private ModuleConfig moduleConfig;

    /**
     * 新外勤助理账号，用于映射老的外勤助理
     */
    @Value ("${assistant.designerLegworkCode}")
    private String designerLegworkCode;

    @Value ("${assistant.customLegworkCode:asaca}")
    private String customLegworkCode;

    public JSONObject queryAccId(String assistantCode, String token) {
        String apiName = "/assistant/getAndCreate";
        JSONObject requestBody = new JSONObject();
        requestBody.put("assistantId", Objects.equals(assistantCode,designerLegworkCode)?customLegworkCode:assistantCode);
        String response = HttpRequest.post(moduleConfig.getIm().getDomain() + apiName)
                .addHeaders(getHeaders(token))
                .body(requestBody.toJSONString())
                .execute()
                .body();
        JSONObject jsonObject = parseResponse(response);
        return jsonObject.getJSONObject("response");
    }

    private Map<String, String> getHeaders(String token) {
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", token);
        return headers;
    }

    private JSONObject parseResponse(String response) {
        JSONObject jsonObject = JSON.parseObject(response);
        Integer code = jsonObject.getInteger("status");
        if (code == null || code != HttpStatus.SC_OK) {
            throw new BusinessException(JSON.toJSONString(jsonObject));
        }
        return jsonObject;
    }
}
