package com.digiwin.athena.km_deployer_service.listener;

import com.digiwin.athena.km_deployer_service.domain.asa.enent.DeployEvent;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;

/**
 * 部署监听
 */
@Slf4j
@Component
public class AsaDeployListener {
    private static Map<Long, SseEmitter> sseEmitters = new Hashtable<>();

    public void addSseEmitters(long id, SseEmitter sseEmitter) {
        sseEmitters.put(id, sseEmitter);
        sseEmitter.onTimeout(() -> sseEmitters.remove(id));
        sseEmitter.onCompletion(() -> sseEmitters.remove(id));
    }

    @EventListener
    public void deployEventHandler(DeployEvent deployEvent){
        long id = deployEvent.getId();
        SseEmitter sseEmitter = sseEmitters.get(id);
        try {
            sseEmitter.send(SseEmitter.event().data(deployEvent.getMsg()));

            if (deployEvent.isComplete()) {
                sseEmitter.complete();
            }
        } catch (IOException e) {
            sseEmitter.complete();

            log.error("Send emit message error.", e);
        }
    }
}
