package com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.repository;

import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.domain.MasterActivity;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.neo4j.repository.query.Query;

import java.util.Set;

public interface KmPublishRepo extends Neo4jRepository<MasterActivity, Long> {


    @Query("match(t:TenantEntity)-[:USE]->(app:AppEntity) where app.code=$appId and app.version = $version return t.tenantId")
    Set<String> findUseAppTenants(String appId, String version);

    @Query("match(t:TenantEntity)-[:USE]->(app:AppEntity) where app.code=$appId return t.tenantId")
    Set<String> findUseAppTenantsWithOutVersion(String appId);


    @Query("match(t:TenantEntity)-[:USE]->(app:AppEntity) where app.code=$appId and t.version=$version return t.tenantId")
    Set<String> findUseAppTenantsWithOutVersion(String appId,String version);
}
