package com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.repository;


import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.domain.TenantAppRelationDto;
import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.domain.TenantEntity;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @program: athena_backend
 * @description: 描述
 * @author: Tuo
 * @create: 2021-07-07 14:02
 **/
@Repository
public interface TenantEntityRepository extends Neo4jRepository<TenantEntity, String> {


    @Query("match(te:TenantEntity{tenantId:$0}) return te")
    TenantEntity tenantEntity(String tenantId);

    @Query("match (te:TenantEntity)-[:USE]->(app:AppEntity) return te.tenantId as tenantId,te.tenantName as tenantName,te.version as version,app.code as appCode")
    List<TenantAppRelationDto> tenantAppRelation();

}
