package com.digiwin.athena.km_deployer_service.service;


import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.digiwin.athena.deploy.DeployReq;
import com.digiwin.athena.km_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.domain.KmTable;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.digiwin.athena.km_deployer_service.support.DeployContext;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.text.StringEscapeUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.InternalNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

@Slf4j
@Service
public class AdapterService {



    @Autowired
    private Driver driver1;

    @Autowired(required = false)
    @Qualifier("domain2Driver")
    private Driver driver2;

    @Autowired
    HelpService helpService;

    @Autowired
    CleanableCaches cleanableCaches;
    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    Neo4jCrudService neo4jCrudService;

    @Async
    public void copy(DeployReq request){

        DeployContext deployContext = new DeployContext();
        deployContext.setAppId(request.getAppId());
        deployContext.setDeployId(request.getDeployId());
        deployContext.setEventId(request.getEventId());
        deployContext.setSourceId(request.getSourceId());
        deployContext.setProcess(0);
        HelpService.setDeployContext(deployContext);

        String application = request.getAppId();
        String oldVersion = request.getFromVersion();
        String tempVersion = "4.0";
        String finalVersion = request.getToVersion();
        if(null==oldVersion){
            oldVersion="1.0";
        }
        if(null==finalVersion){
            finalVersion ="2.0";
        }

        helpService.logDetail(null,"开始copy数据",0,1);
        copyNeo4jData(application,oldVersion,tempVersion,new Neo4jManager(driver1));
        if(null!=driver2){
            copyNeo4jData(application,oldVersion,tempVersion,new Neo4jManager(driver2));
        }
        helpService.logDetail(null,"copy neo4j数据完成",10,1);

        Bson filters = Filters.and(
                Filters.eq("version", oldVersion),
                Filters.or(Filters.eq("application", application), Filters.eq("athena_namespace", application)),
                Filters.or(Filters.eq("tenantId", null), Filters.eq("tenantId", "SYSTEM"),
                        Filters.and(Filters.ne("tenantId", null), Filters.ne("tenantId", "SYSTEM"), Filters.eq("athena_publishType", "individualCase")))
        );
        List<KmTable> tables = cleanableCaches.getKmTables();
        for(KmTable table :tables){
            if("neo4j".equalsIgnoreCase(table.getType())){
                continue;
            }
            List<Document> newDocuments = new ArrayList<>();
            FindIterable<Document> documents = mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).find(filters);
            documents.forEach((Consumer<? super Document>) document -> {
                Document newDocument = new Document(document);
                newDocument.remove("_id");
                newDocument.put("version", tempVersion);
                newDocument.put("publishTime", new Date());
                newDocuments.add(newDocument);
            });
            if (!newDocuments.isEmpty()){
                mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).insertMany(newDocuments);
            }
        }
        helpService.logDetail(null,"copy mongo 数据完成",0,1);

        helpService.logDetail(null,"开始删除目标版本数据",10,1);
        Map<String,Object> param = new HashMap<>();
        param.put("version", finalVersion);
        param.put("application", application);
        String cypher1 = "match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) detach delete node";
        neo4jCrudService.executeCypher(cypher1,param);
        helpService.logDetail(null,"删除目标版本neo4j数据完成",10,1);
        Bson filters2 = Filters.and(
                Filters.eq("version", finalVersion),
                Filters.or(Filters.eq("application", application), Filters.eq("athena_namespace", application)),
                Filters.or(Filters.eq("tenantId", null), Filters.eq("tenantId", "SYSTEM"),
                        Filters.and(Filters.ne("tenantId", null), Filters.ne("tenantId", "SYSTEM"), Filters.eq("athena_publishType", "individualCase")))
        );
        for(KmTable table :tables){
            if("neo4j".equalsIgnoreCase(table.getType())){
                continue;
            }
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).deleteMany(filters2);
        }
        helpService.logDetail(null,"删除目标版本mongo数据完成",0,1);

        helpService.logDetail(null,"开始更新目标版本数据",10,1);
        Map<String,Object> param2 = new HashMap<>();
        param2.put("version", tempVersion);
        param2.put("updateVersion", finalVersion);
        param2.put("application", application);
        String cypher2 = "match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) set node.version=$updateVersion";
        neo4jCrudService.executeCypher(cypher2,param2);
        helpService.logDetail(null,"更新目标版本neo4j数据完成",10,1);
        Bson filters3 = Filters.and(
                Filters.eq("version", tempVersion),
                Filters.or(Filters.eq("application", application), Filters.eq("athena_namespace", application)),
                Filters.or(Filters.eq("tenantId", null), Filters.eq("tenantId", "SYSTEM"),
                        Filters.and(Filters.ne("tenantId", null), Filters.ne("tenantId", "SYSTEM"), Filters.eq("athena_publishType", "individualCase")))
        );
        Bson setv = Updates.set(Constant.version,finalVersion);
        for(KmTable table :tables){
            if("neo4j".equalsIgnoreCase(table.getType())){
                continue;
            }
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).updateMany(filters3,setv);
        }
        helpService.logDetail(null,"更新目标版本mongo数据完成",0,2);
    }


    private void copyNeo4jData(String application, String oldVersion, String newVersion, Neo4jManager neo4jManager) {
        long t0 = System.currentTimeMillis();
        // 作为查询
        ConcurrentHashMap<Long, Long> nodeNeo4jIdMap = new ConcurrentHashMap<>();
        // 收集所有的node节点
        HashMap<String, Object> param = new HashMap<>();
        param.put("version", oldVersion);
        param.put("application", application);
        List<Map<String, Object>> nodeResultList = neo4jManager.ExecuteQuery("match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) and not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) return node", param);
        // 收集所有的relation以及前后nodeId(排除租户对外的relation)
        List<Map<String, Object>> relationList = neo4jManager.ExecuteQuery("match (startNode)-[relation]->(endNode) where startNode.version = $version and (startNode.athena_namespace = $application or startNode.nameSpace = $application) and endNode.version = $version and (endNode.athena_namespace = $application or endNode.nameSpace = $application) return id(startNode) as startNodeId,type(relation) as relationType,id(endNode) as endNodeId", param);
        // 遍历nodeResultList组装新的节点属性，添加oldNodeId属性
        List<Cql> cqlList = new ArrayList<>();
        for (Map<String, Object> nodeResult : nodeResultList) {
            StringBuffer nodeCypher = new StringBuffer("create (node");
            Collection<String> labels = ((InternalNode) nodeResult.get("node")).labels();
            long nodeId = ((InternalNode) nodeResult.get("node")).id();
            for (String label : labels) {
                nodeCypher.append(String.format(":%s", label));
            }
            nodeCypher.append("{");
            Map<String, Object> properties = ((InternalNode) nodeResult.get("node")).asMap();
            // 取到属性组装cql
            combineNodeProperties(properties, nodeCypher);
            nodeCypher.append("oldNodeId:" + nodeId + ",");
            nodeCypher.append(String.format("version:'%s', publishTime:'%s'}) return id(node) as nodeId", newVersion, DateUtil.now()));
            cqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava(nodeCypher.toString())));
        }
        // 执行所有复制操作
        neo4jManager.ExecuteTransactionNoQuery(cqlList);

        param.put("version", newVersion);
        param.put("application", application);
        List<Map<String, Object>> newNodeList = neo4jManager.ExecuteQuery("match (node) where node.version = $version and (node.athena_namespace = $application or node.nameSpace = $application) and not any(label in labels(node) WHERE label in ['TenantEntity','AppEntity']) return node", param);
        for (Map<String, Object> nodeResult : newNodeList) {
            long newNodeId = ((InternalNode) nodeResult.get("node")).id();
            Map<String, Object> properties = ((InternalNode) nodeResult.get("node")).asMap();
            Long oldNodeId = Convert.toLong(properties.get("oldNodeId"));
            nodeNeo4jIdMap.put(oldNodeId,newNodeId);
        }

        relationList.forEach(relation -> {
            relation.put("startNodeId", nodeNeo4jIdMap.get(Long.valueOf(relation.get("startNodeId").toString())));
            relation.put("endNodeId", nodeNeo4jIdMap.get(Long.valueOf(relation.get("endNodeId").toString())));
        });

        List<Cql> cqlList1 = new ArrayList<>();
        for (Map<String, Object> relation : relationList) {
            String relationCypher = String.format("match (startNode),(endNode) WHERE id(startNode)=%d and id(endNode)=%d merge (startNode)-[relation:%s]->(endNode)", (Long) relation.get("startNodeId"), (Long) relation.get("endNodeId"), relation.get("relationType"));
            cqlList1.add(new Cql().setParams(new HashMap<>()).setCql(relationCypher));
        }
        neo4jManager.ExecuteTransactionNoQuery(cqlList1);
        long t1 = System.currentTimeMillis();
        log.info(application + "应用复制neo4j数据耗时（ms）：" + (t1 - t0));
    }

    public void combineNodeProperties(Map<String, Object> properties, StringBuffer nodeCypher) {
        properties.forEach((k, v) -> {
            if (!"version".equals(k) && !"oldNodeId".equals(k)) {
                if (k.contains(".")) {
                    nodeCypher.append(String.format("`%s`:", k));
                } else {
                    nodeCypher.append(String.format("%s:", k));
                }
                if (v instanceof String) {
                    String propertyValue = (String) v;
                    propertyValue = propertyValue.replace("'", "\\\"");
                    nodeCypher.append(String.format("'%s',", propertyValue));
                } else if (v instanceof Collection) {
                    nodeCypher.append("[");
                    List propertyValueList = (List) v;
                    propertyValueList.forEach(propertyValue -> {
                        if (propertyValue instanceof String) {
                            nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                        } else {
                            nodeCypher.append(propertyValue).append(",");
                        }
                    });
                    if (!propertyValueList.isEmpty()) {
                        nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                    }
                    nodeCypher.append("],");
                } else {
                    nodeCypher.append(v).append(",");
                }
            }
        });
    }

}
