package com.digiwin.athena.km_deployer_service.service;

import com.digiwin.athena.deploy.ApplicationData;
import com.digiwin.athena.km_deployer_service.domain.KmTable;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import javax.script.ScriptEngine;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Service
public class CleanableCaches {

    @Autowired
    MongoTemplate mongoTemplate;

    Cache<String, List<KmTable>> kmTables= Caffeine.newBuilder()
            .expireAfterWrite(2, TimeUnit.HOURS)
            .initialCapacity(4)
            .maximumSize(8)
            .build();


//    Cache<String, ApplicationData> appDatas= Caffeine.newBuilder()
//            .expireAfterWrite(2, TimeUnit.HOURS)
//            .initialCapacity(4)
//            .maximumSize(8)
//            .build();

    public void cleanAll(){
        kmTables.invalidateAll();

    }

    public  List<KmTable> getKmTables(){
        String key = "kmTables";
        List<KmTable> tables = kmTables.getIfPresent(key);
        if(null==tables){
            tables = mongoTemplate.find(Query.query(Criteria.where("category").is("deploy")), KmTable.class);
            kmTables.put(key,tables);
        }
        return tables;
    }

}
