package com.digiwin.athena.km_deployer_service.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.deploy.*;
import com.digiwin.athena.km_deployer_service.config.AppConfig;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.domain.DeployDataRecord;
import com.digiwin.athena.km_deployer_service.domain.KmTable;
import com.digiwin.athena.deploy.ApplicationData;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.km_deployer_service.domain.MonitorHash;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Relation;
import com.digiwin.athena.km_deployer_service.povo.Application2CommonRelationParam;
import com.digiwin.athena.km_deployer_service.povo.CreateApplicationRelationParam;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.povo.EspActionEnumkeyModule;
import com.digiwin.athena.km_deployer_service.service.deploy.MonitorService;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.*;
import com.digiwin.athena.km_deployer_service.spi.AtmcService;
import com.digiwin.athena.km_deployer_service.spi.KgService;
import com.digiwin.athena.km_deployer_service.support.DeployContext;
import com.digiwin.athena.km_deployer_service.util.SecurityUtils;
import com.digiwin.athena.km_deployer_service.util.Utils;
import com.google.common.collect.Lists;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.concurrent.*;
import java.util.stream.Collectors;

import static com.digiwin.athena.km_deployer_service.service.km.MongoCrudService.buildBson;

@Slf4j
@Service
public class DeployService implements InitializingBean {


    private boolean stop=false;
    public static ExecutorService pool = Executors.newFixedThreadPool(15);

    private int batchInsert =100;
    private int batchRecord=100;


    private Thread takingThread;

    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoCrudService mongoCrudService;

    @Autowired
    RedisLockRegistry redisLockRegistry;

    @Autowired
    DmcService dmcService;

    @Autowired
    AppConfig appConfig;

    @Autowired
    HelpService helpService;

    @Autowired
    MonitorService monitorService;

    @Autowired
    CleanableCaches cleanableCaches;

    @Value("${compile.zipPath}")
    private String compileZipPath;

    @Value("${compile.dataPath}")
    private String compileDataPath;


    @Resource
    RedissonClient redissonClient;

    @Autowired
    ActionService actionService;


    @Autowired
    GridFsTemplate gridFsTemplate;

    @Autowired
    KgService kgService;

    @Autowired
    AtmcService atmcService;

    @Autowired
    CommonDataService commonDataService;

    @Autowired
    ApplicationService applicationService;

    @Value("${deployTask.expiredMinutes:10}")
    private long expiredMinutes;

    @Value("${deployTask.mongoDocSplitSize:100}")
    private int mongoDocSplitSize;


    public DeployResp publishApplication(DeployReq request) throws IOException {
        log.info("publishApplication...."+JSON.toJSONString(request));
        DeployResp response = new DeployResp();
        //安全校验
        boolean check = SecurityUtils.checkSign(request,appConfig.getPrivateKey());
        if(!check){
            return DeployResp.failed(1,"安全校验错误");
        }
        //参数校验
        if(null==request.getDeployId()){
            return DeployResp.failed(1,"deployId is null");
        }
        if( null==request.getSourceId()){
            return DeployResp.failed(1,"sourceId is null");
        }
        if( null==request.getAppId()){
            return DeployResp.failed(1,"appId is null");
        }
        if(null==request.getType()){
            return DeployResp.failed(1,"type is null");
        }
        if(DeployConstants.DeployType.app.equalsIgnoreCase(request.getType())
        || DeployConstants.DeployType.tenantApp.equalsIgnoreCase(request.getType())
        || DeployConstants.DeployType.tenantCustom.equalsIgnoreCase(request.getType())
        || DeployConstants.DeployType.eocCustom.equalsIgnoreCase(request.getType())
        || DeployConstants.DeployType.joblist.equalsIgnoreCase(request.getType())){

        }else{
            return DeployResp.failed(1,"type not support");
        }
        if(DeployConstants.DeployType.tenantApp.equalsIgnoreCase(request.getType()) && CollectionUtils.isEmpty(request.getTenantIds())){
           // return DeployResp.failed(1,"个案部署时必须指定租户");
            request.setTenantIds(new ArrayList<>());
        }
        if(DeployConstants.DeployType.tenantCustom.equalsIgnoreCase(request.getType()) && CollectionUtils.isEmpty(request.getTenantIds())){
            request.setTenantIds(new ArrayList<>());
            // return DeployResp.failed(1,"租户级部署时必须指定租户");
        }
        if(DeployConstants.DeployType.eocCustom.equalsIgnoreCase(request.getType()) && CollectionUtils.isEmpty(request.getTenantIds())){
            request.setTenantIds(new ArrayList<>());
            // return DeployResp.failed(1,"租户级部署时必须指定租户");
        }
        if(request.getFileId()==null && request.getAppData()==null ){
            return DeployResp.failed(1,"发版时必须设置fileId或者传入数据");
        }
        //状态校验
        DeployTask publishTask = mongoTemplate.findOne(Query.query(Criteria.where("deployId").is(request.getDeployId())),DeployTask.class);
        if(null!=publishTask){
            DeployResp resp= DeployResp.failed(2,"deployId已存在："+request.getDeployId());
            resp.setEventId(publishTask.getEventId());
            return resp;
        }
        boolean deploying = appDeploying(request);
        if(deploying){
            return DeployResp.failed(1,"该应用正在部署，请稍后重试");
        }

        request.setVersion(Constant.TEST_VERSION);

        //解析数据
        ApplicationData appData=request.getAppData();
        if(request.getFileId()!=null){
            appData=parseFile(request.getAppId(), request.getSourceId(), request.getFileId());
        }
        if(null==appData || (CollectionUtil.isEmpty(appData.getCyphers()) && CollectionUtil.isEmpty(appData.getMongoData()))){
            return DeployResp.failed(1,"没有任何发布的数据");
        }
        preProcess(appData,request);
        appData.setDeployId(request.getDeployId());
        //todo 为了兼容老数据对于应用如果是第一次用这个工具发布需要初始化sourceId，后面所有应用都发过一遍后这边的代码需要删除
        if(DeployConstants.DeployType.app.equalsIgnoreCase(request.getType())){
            DeployTask publishTask2 = mongoTemplate.findOne(Query.query(Criteria.where("appId").is(request.getAppId()).and("type").is(DeployConstants.DeployType.app)),DeployTask.class);
            if(null==publishTask2){
                test_initApplicationSourceId(request);
            }
        }else if(DeployConstants.DeployType.tenantApp.equalsIgnoreCase(request.getType())){
            DeployTask publishTask2 = mongoTemplate.findOne(Query.query(Criteria.where("appId").is(request.getAppId()).and("type").is(DeployConstants.DeployType.app)),DeployTask.class);
            if(null==publishTask2){
                return DeployResp.failed(1,"发版个案之前需要先发版一次标准");
            }
        }
        //推送队列
        DeployTask task = JSON.parseObject(JSON.toJSONString(request), DeployTask.class);
        task.setStatus(0);
        task.setCreateTime(new Date());
        task.setUpdateTime(System.currentTimeMillis());
        task.setEventId(Utils.uid());
        task.setVersion(Constant.TEST_VERSION);
        monitorService.monitorRuleHash(request);
        // 把上一步处理的租户数据保存下来
        task.setLastIndividualTenantIds(request.getLastIndividualTenantIds());
        task.setIndividualAddedTenantIds(request.getIndividualAddedTenantIds());
        task.setIndividualKeepTenantIds(request.getIndividualKeepTenantIds());
        task.setIndividualRemovedTenantIds(request.getIndividualRemovedTenantIds());
        saveAppData(request,appData);
        if(Boolean.TRUE.equals(request.getSync())){
            task.setStatus(1);
            mongoTemplate.save(task);
            process(task);
            task.setStatus(2);
        }
        mongoTemplate.save(task);
        response.setDeployId(request.getDeployId());
        response.setEventId(task.getEventId());
        return response;
    }


    public DeployResp switchApplications(DeployReq request){
        DeployResp resp = new DeployResp();

        DeployTask task = new DeployTask();
        task.setId(null);
        task.setStatus(1);
        task.setCreateTime(new Date());
        task.setUpdateTime(System.currentTimeMillis());
        task.setEventId(DeployConstants.batchSwitchPrefix+Utils.uid());
        task.setVersion(Constant.PROD_VERSION);
        task.setProcessCount(0);
        task.setCost(null);
        task.setSubDeployIds(request.getDeployIds());
        task.setSubEventIds(new ArrayList<>());
        task.setUpdateEspVersion(request.getUpdateEspVersion());
        task.setToken(request.getToken());
        resp.setEventId(task.getEventId());
        new Thread(){
            public void run(){
                for(String deployId:request.getDeployIds()){
                    DeployReq request2 = JSON.parseObject(JSON.toJSONString(request),DeployReq.class);
                    request2.setDeployId(deployId);
                    request2.setParentEventId(task.getEventId());
                    request2.setSync(true);
                    try {
                        DeployResp subResp = switchApplication(request2);
                        task.getSubEventIds().add(subResp.getEventId());
                        if(subResp.getCode()!=0){
                            resp.setCode(subResp.getCode());
                            resp.setMsg(subResp.getMsg());
                            task.setStatus(3);
                            task.setMsg(subResp.getMsg());
                            mongoTemplate.save(task);
                            break;
                        }
                    }catch (Exception e){
                        task.setStatus(3);
                        task.setMsg(e.getMessage());
                        mongoTemplate.save(task);
                        throw  e;
                    }
                }
                task.setStatus(2);
                mongoTemplate.save(task);
            }
        }.start();

        mongoTemplate.save(task);
        return resp;
    }




    public DeployResp switchApplication(DeployReq request){
        log.info("switchApplication...."+JSON.toJSONString(request));
        DeployResp response = new DeployResp();
        //安全校验
        boolean check = SecurityUtils.checkSign(request,appConfig.getPrivateKey());
        if(!check){
            return DeployResp.failed(1,"安全校验错误,"+request.getDeployId());
        }
        //参数校验
        if(null==request.getDeployId()){
            return DeployResp.failed(1,"参数错误,"+request.getDeployId());
        }
        //检查上次发版是否成功
        DeployTask publishTask = mongoTemplate.findOne(Query.query(Criteria.where("deployId").is(request.getDeployId()).and("version").is(Constant.TEST_VERSION)),DeployTask.class);
        if(null==publishTask
                || (publishTask.getStatus()!=DeployConstants.DeployStatus.done
                && publishTask.getStatus() != DeployConstants.DeployStatus.warn)) {
            DeployResp resp= DeployResp.failed(1,"发版没有成功 "+request.getDeployId());
            if(null!=publishTask){
                resp.setEventId(publishTask.getEventId());
            }
            return resp;
        }
        request.setSourceId(publishTask.getSourceId());
        //状态校验
        boolean deploying = appDeploying(request);
        if(deploying){
            List<DeployTask> switchTasks = mongoTemplate.find(Query.query(Criteria.where("deployId").is(request.getDeployId()).and("version").is(Constant.PROD_VERSION)),DeployTask.class);
            DeployResp resp= DeployResp.failed(1,"该应用正在部署，请稍后重试,"+request.getDeployId());
            if(switchTasks.size()>0){
                resp.setEventId(switchTasks.get(switchTasks.size()-1).getEventId());
            }
            return resp;
        }
        DeployTask task = JSON.parseObject(JSON.toJSONString(publishTask),DeployTask.class);
        task.setId(null);
        task.setStatus(0);
        task.setCreateTime(new Date());
        task.setUpdateTime(System.currentTimeMillis());
        task.setEventId(Utils.uid());
        task.setVersion(Constant.PROD_VERSION);
        task.setProcessCount(0);
        task.setCost(null);
        task.setParentEventId(request.getParentEventId());
        task.setUpdateEspVersion(request.getUpdateEspVersion());
        if(CollectionUtil.isNotEmpty(request.getTenantIds()) || DeployConstants.DeployType.app.equalsIgnoreCase(task.getType())){
            task.setTenantIds(request.getTenantIds());
        }
        if(null!=request.getToken()){
            request.setToken(request.getToken());
        }
        if(Boolean.TRUE.equals(request.getSync())){
            task.setStatus(1);
            mongoTemplate.save(task);
            process(task);
            task.setStatus(2);
        }
        mongoTemplate.save(task);
        response.setDeployId(request.getDeployId());
        response.setEventId(task.getEventId());
        return response;
    }


    public DeployResp revokeApp(DeployReq request){
        DeployResp response = new DeployResp();
        //安全校验
        boolean check = SecurityUtils.checkSign(request,appConfig.getPrivateKey());
        if(!check){
            return DeployResp.failed(1,"安全校验错误");
        }
        //参数校验
        if(null==request.getDeployId()){
            return DeployResp.failed(1,"deployId is null");
        }
        //检查上次发版是否成功
        DeployTask publishTask = mongoTemplate.findOne(Query.query(Criteria.where("deployId").is(request.getDeployId()).and("version").is(request.getVersion())),DeployTask.class);
        if(null==publishTask){
            return DeployResp.failed(1,"发版没有成功 "+request.getDeployId());
        }
        if(publishTask.getStatus()==DeployConstants.DeployStatus.doing && !Boolean.TRUE.equals(request.getForce())){
            return DeployResp.failed(1,"发布正在进行中 "+request.getDeployId());
        }

        publishTask.setStatus(DeployConstants.DeployStatus.revoke);
        publishTask.setUpdateTime(System.currentTimeMillis());
        mongoTemplate.save(publishTask);

        DeployContext deployContext = new DeployContext();
        deployContext.setAppId(publishTask.getAppId());
        deployContext.setDeployId(publishTask.getDeployId());
        deployContext.setEventId(publishTask.getEventId());
        deployContext.setSourceId(publishTask.getSourceId());
        deployContext.setProcess(0);
        HelpService.setDeployContext(deployContext);

        cleanData(publishTask,publishTask.getSourceId(),request.getVersion(),null);
        return response;
    }


    public DeployResp redoApp(DeployReq request){
        DeployResp response = new DeployResp();
        //安全校验
        boolean check = SecurityUtils.checkSign(request,appConfig.getPrivateKey());
        if(!check){
            return DeployResp.failed(1,"安全校验错误");
        }
        //参数校验
        if(null==request.getDeployId()){
            return DeployResp.failed(1,"参数错误");
        }
        //检查上次发版是否成功
        DeployTask publishTask = mongoTemplate.findOne(Query.query(Criteria.where("deployId").is(request.getDeployId()).and("version").is(request.getVersion())),DeployTask.class);
        if(null==publishTask){
            return DeployResp.failed(1,"发版没有成功 "+request.getDeployId());
        }
        if(publishTask.getStatus()==DeployConstants.DeployStatus.doing && !Boolean.TRUE.equals(request.getForce())){
            return DeployResp.failed(1,"发布正在进行中 "+request.getDeployId());
        }

        publishTask.setStatus(DeployConstants.DeployStatus.create);
        publishTask.setUpdateTime(System.currentTimeMillis());
        mongoTemplate.save(publishTask);

        return response;
    }


    public DeployResp updateVersion(DeployReq request){
        DeployResp response = new DeployResp();
        //安全校验
        boolean check = SecurityUtils.checkSign(request,appConfig.getPrivateKey());
        if(!check){
            return DeployResp.failed(1,"安全校验错误");
        }
        //参数校验
        if(null==request.getVersion()  || CollectionUtil.isEmpty(request.getTenantIds())){
            return DeployResp.failed(1,"参数错误");
        }
        // neo4jCrudService.updateTenantVersion(request.getTenantIds(), request.getVersion());
        Map<String, Object> param1 = new HashMap<>();
        param1.put("tenantId", request.getTenantIds());
        Bson setv = Updates.set(Constant.version, request.getVersion());
        mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(Constant.db_kg_sys).getCollection("tenantEntity").updateMany(buildBson(param1), setv);
        return response;
    }


    private void saveAppData(DeployReq req,ApplicationData data){

        List<DeployDataRecord> records = new ArrayList<>();
        for(String sql:data.getCyphers()){
            DeployDataRecord record = new DeployDataRecord();
            record.setDeployId(req.getDeployId());
            record.setType("neo4j");
            record.setCypher(sql);
            records.add(record);
        }

        for(ApplicationMongoData data1: data.getMongoData()){
            List<List<Document>> multiDocs = Lists.partition(data1.getDocs(), mongoDocSplitSize);
            for (List<Document> docs : multiDocs) {
                DeployDataRecord record = new DeployDataRecord();
                record.setDeployId(req.getDeployId());
                record.setType("mongo");
                ApplicationMongoData mongoData = new ApplicationMongoData();
                mongoData.setDb(data1.getDb());
                mongoData.setCol(data1.getCol());
                mongoData.setDocs(docs);
                mongoData.setParams(data1.getParams());
                record.setDatas(mongoData);
                records.add(record);
            }
        }

        if(null!=data.getEnumKeyMappingModule()){
            DeployDataRecord record = new DeployDataRecord();
            record.setDeployId(req.getDeployId());
            record.setType("espEnumKeys");
            record.setData(data.getEnumKeyMappingModule());
            records.add(record);
        }
        mongoTemplate.insertAll(records);

    }


    private ApplicationData loadData(String deployId){
        ApplicationData data = new ApplicationData();
        List<DeployDataRecord> records = mongoTemplate.find(Query.query(Criteria.where("deployId").is(deployId)), DeployDataRecord.class);
        if(CollectionUtil.isEmpty(records)){return null;}
        List<DeployDataRecord> mergedRecords = mergeMongoData(records);
        for(DeployDataRecord record : mergedRecords){
            if("neo4j".equalsIgnoreCase(record.getType())){
                data.getCyphers().add(record.getCypher());
            }else if("espEnumKeys".equalsIgnoreCase(record.getType())){
                EspActionEnumkeyModule module = JSON.parseObject((String)record.getData(),EspActionEnumkeyModule.class);
                data.setEnumKeyMapping((module.getEnumKeyMapping()));
            }
            else{
                data.getMongoData().add(record.getDatas());
            }
        }

        return data;
    }

    private List<DeployDataRecord> mergeMongoData(List<DeployDataRecord> records) {
        Map<String, DeployDataRecord> map = new HashMap<>();
        Iterator<DeployDataRecord> iterator = records.iterator();
        while (iterator.hasNext()) {
            DeployDataRecord record = iterator.next();
            if ("mongo".equalsIgnoreCase(record.getType())) {
                iterator.remove();
                String key = record.getDatas().getDb() + "." + record.getDatas().getCol();
                if (map.containsKey(key)) {
                    DeployDataRecord record1 = map.get(key);
                    record1.getDatas().getDocs().addAll(record.getDatas().getDocs());
                } else {
                    map.put(key, record);
                }
            }
        }
        List<DeployDataRecord> result = new ArrayList<>(records);
        result.addAll(map.values());
        return result;
    }

    private boolean appDeploying(DeployReq request){
        boolean r =mongoTemplate.exists(Query.query(Criteria.where("sourceId").is(request.getSourceId()).and("status").lt(DeployConstants.DeployStatus.done)), DeployTask.class);
        return r;
    }

    public List<DeployLog> deployLogs(DeployReq request){
        Query query = Query.query(Criteria.where("eventId").is(request.getEventId()));
        if(null!=request.getStartTime()){
            query.addCriteria(Criteria.where("createTime").gt(request.getStartTime()));
        }
        query.with(Sort.by(Sort.Direction.ASC,"createTime"));
        List<DeployLog> logs = mongoTemplate.find(query, DeployLog.class);
        return logs;
    }





    public ApplicationData parseFile(String application,String deployId,String fileId) throws IOException {
        ApplicationData data = new ApplicationData();
        //解压运行态数据
        String appDir = deployId;
        String applicationCompileZipPath = compileZipPath + File.separator + appDir + File.separator;
        String applicationCompileDataPath = compileDataPath + File.separator + appDir + File.separator;
        String compileDataZipPath = applicationCompileZipPath + appDir + ".zip";
        InputStream inputStream = dmcService.download(fileId);
        FileUtil.writeFromStream(inputStream, compileDataZipPath);
//       String compileDataZipPath="E:\\files\\PWD\\PWD.zip";//compileData.zip common-compileData.zip
//        String compileDataZipPath = "E:\\digiwin\\项目\\发版迁移\\BCB.zip";
        File compileDataDirector = new File(applicationCompileDataPath);//NOSONAR 该文件名是来自环境变脸的输入
        FileUtil.del(compileDataDirector);
        ZipUtil.unzip(compileDataZipPath, applicationCompileDataPath);
        File[] compileDataFiles = compileDataDirector.listFiles();
        if(null==compileDataFiles){return data;}
        for(File file: compileDataFiles){
            String filename = file.getName();
            if("cypher".equals(filename)){
                File[] files = file.listFiles();
                if(files==null){continue;}
                for(File file1:files){
                    if(file1.getName().endsWith("json")){
                        List<String> lines = FileUtil.readLines(file1,"UTF-8");
                        data.getCyphers().addAll(lines);
                    }
                }

            }else if("designer".equals(filename)){
                File[] files = file.listFiles();
                if(files==null){continue;}
                for(File file1:files){
                    if("espActionEnumKey".equals(file1.getName())){
                        File[] files2 = file1.listFiles();
                        if(files2==null || files2.length==0){continue;}
                        String content = FileUtil.readString(files2[0],"UTF-8");
                        if(!StringUtils.isEmpty(content)){
                            data.setEnumKeyMappingModule(content);
                        }
                    }
                }
            } else if(isDb(filename)){
                File[] dirs = file.listFiles();
                if(dirs==null){continue;}
                for(File col:dirs){
                    String colName = col.getName();
                    if(isCol(col)){
                        ApplicationMongoData mongoData = new ApplicationMongoData();
                        mongoData.setDb(filename);
                        mongoData.setCol(colName);
                        File[] files = col.listFiles();
                        if(files==null){continue;}
                        for(File file1:files){
                            if(file1.getName().endsWith("json")){
                                List<String> lines = FileUtil.readLines(file1,"UTF-8");
                                lines.forEach(line->{
                                    Document document = Document.parse(line);
                                    mongoData.getDocs().add(document);
                                });

                            }
                        }
                        data.getMongoData().add(mongoData);
                    }
                }

            } else{
                log.info("ignore file "+filename);
            }
        }
        FileUtil.del(compileDataZipPath);
        FileUtil.del(applicationCompileDataPath);
        return data;
    }


    private void preProcess(ApplicationData data,DeployReq req){
        String sourceId = req.getSourceId();
        String application = req.getAppId();
        data.getMongoData().forEach(applicationMongoData -> {
            applicationMongoData.setDb(applicationMongoData.getDb()+getDbSuffix());
            applicationMongoData.getDocs().forEach(document -> {
                document.remove("_id");
                document.remove("isMigrate");
                document.put("version", Constant.PUBLISH_VERSION);
//                if(null!=application){
//                    document.put("athena_namespace", application);
//                    document.put("application", application);
//                }
                if(null!=sourceId){
                    document.put("sourceId", sourceId);
                    document.put("deployId", req.getDeployId());
                }
                if(DeployConstants.DeployType.tenantApp.equalsIgnoreCase(req.getType())){
                    document.put("sourceLevel", DeployConstants.SourceLevel.tenantApp);
                } else if(DeployConstants.DeployType.tenantCustom.equalsIgnoreCase(req.getType())){
                    document.put("sourceLevel", DeployConstants.SourceLevel.tenantCustom);
                } else if(DeployConstants.DeployType.eocCustom.equalsIgnoreCase(req.getType())){
                    document.put("sourceLevel", DeployConstants.SourceLevel.eocCustom);
                }
            });
        });
    }


    private boolean isDb(String name){
        List<String> dbs = Arrays.asList("knowledgegraphSystem","datamap","preset","tagSystem","deliveryDesigner");
        return dbs.contains(name);
    }
    private boolean isCol(File file){
        return file.isDirectory();
    }





    public void startTaking(){
        while(!stop){
            RLock lock = redissonClient.getLock(DeployConstants.cachePrefix + "deployTask");
            DeployTask task =null;
            try {
                lock.lock(10,TimeUnit.SECONDS);
                Query query = new Query(Criteria.where("status").is(DeployConstants.DeployStatus.create));
                query.with(Sort.by(Sort.Direction.ASC,"updateTime"));
                task = mongoTemplate.findOne(query,DeployTask.class);
                System.out.println(new Date()+" "+ Thread.currentThread().getName()+" 获取发布任务："+task);
                if(null!=task){
                    task.setStatus(1);
                    task.setBeginTime(new Date());
                    if(null==task.getProcessCount()){
                        task.setProcessCount(1);
                    }else{
                        task.setProcessCount(task.getProcessCount()+1);
                    }
                    DeployTask finalTask = task;
                    mongoTemplate.save(task);
                    pool.submit(()->{
                        process(finalTask);
                    });
                }

            }catch (Exception e){
                log.error("startTaking error", e);
            }finally {
                if(null!=lock && lock.isHeldByCurrentThread()){
                    lock.unlock();
                }
            }
            if(null==task){
                try {
                    Thread.sleep(3000);
                } catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }

        }
    }


    public DeployResp stopTaking(DeployReq request,Boolean back){
        if(!back){
            boolean check = SecurityUtils.checkSign(request,appConfig.getPrivateKey());
            if(!check){
                return DeployResp.failed(1,"安全校验错误");
            }
        }
        if(null!=takingThread){
            stop=true;
            takingThread = null;
        }

        return new DeployResp();
    }

    public DeployResp restartTaking(DeployReq request,boolean back){
        try {
            stopTaking(request,back);
        }catch (Exception e){}
        stop=false;
        takingThread = new Thread(){
            public void run(){
                startTaking();
            }
        };

        takingThread.start();

        return new DeployResp();
    }


    public void  process(DeployTask task){
        task.setBeginTime(new Date());
        String appId = task.getAppId();
        String version = task.getVersion();
        try {
            DeployContext deployContext = new DeployContext();
            deployContext.setAppId(task.getAppId());
            deployContext.setDeployId(task.getDeployId());
            deployContext.setEventId(task.getEventId());
            deployContext.setSourceId(task.getSourceId());
            deployContext.setProcess(0);
            HelpService.setDeployContext(deployContext);
            log(task.getEventId(),"开始执行更新",0,null);
            ApplicationData appData = loadData(task.getDeployId());
            if(appData==null){
                log(task.getEventId(),"数据丢失",0,3);
                task.setStatus(3);
                task.setMsg("数据丢失");
                mongoTemplate.save(task);
                return;
            }
            JSONObject neo4jNodeKeyJson = new JSONObject();
            List<KmTable> kmTables = cleanableCaches.getKmTables();
            for(KmTable kmTable:kmTables){
                if("neo4j".equalsIgnoreCase(kmTable.getType())){
                    if(CollectionUtil.isNotEmpty(kmTable.getUniKey())){
                        neo4jNodeKeyJson.put(kmTable.getTable(),kmTable.getUniKey().get(0));
                    }
                }
            }
            List<Relation> relations = new ArrayList<>();
            if(isCommonApp(task)){
                Application2CommonRelationParam findApplication2CommonParam = new Application2CommonRelationParam()
                           // .setTenantIdList(tenantIds)
                            .setApplicationList(ListUtil.toList(appId, "espCommon"))
                            .setNeo4jNodeKeyJson(neo4jNodeKeyJson).setApplicationVersion(version).setCommonVersion(version);
                //查找应用到common应用中的某些action关联关系
                relations = commonDataService.findApp2OtherAppRelations(findApplication2CommonParam);
            }

            //检查租户和应用是否存在
            checkAppAndTenant(task);
            //清除脏数据
            cleanData(task,task.getSourceId(),Constant.PUBLISH_VERSION,null);
            //插入数据
            processApplicationData(task,appData);
            //清除老版本数据
            cleanData(task,task.getSourceId(),task.getVersion(),null);
            //清除个案包含租户其他版本的数据
            if(DeployConstants.DeployType.tenantApp.equalsIgnoreCase(task.getType()) && CollectionUtil.isNotEmpty(task.getCleanSourceTenants())){
                task.getCleanSourceTenants().forEach((k,v)->{
                    cleanData(task,k,task.getVersion(),v);
                });
            }
            //更新版本
            updateVersion(task,appData);
            //更新租户版本
//            if(CollectionUtil.isNotEmpty(task.getTenantIds())){
//                neo4jCrudService.updateTenantVersion(task.getTenantIds(),task.getVersion());
//            }
            // 机制一次编译
            boolean mechanismFirstCompileSuccess = true;
            // 机制一次编译只处理全量发布场景，不处理单作业发布
//            if (null == task.getJobList() || task.getJobList().isEmpty()) {
//                try {
//                    executeMechanismFirstCompile(task, appData.getMongoData());
//                } catch (Exception e) {
//                    mechanismFirstCompileSuccess = false;
//                    log(task.getEventId(),"机制一次编译失败" + e.getMessage(),0, null);
//                    log.error("机制一次编译失败", e);
//                }
//            }
            //action
            if(Constant.TEST_VERSION.equalsIgnoreCase(task.getVersion())){
                if(null!=appData.getEnumKeyMapping()){
                    log.info("updateEspActionEnumKey......");
                    actionService.updateEspActionEnumKey(appData.getEnumKeyMapping());
                }
                monitorService.monitorHash(task,task.getSourceId(),1);
            } else if(Constant.PROD_VERSION.equalsIgnoreCase(task.getVersion())){
                if(Boolean.TRUE.equals(task.getUpdateEspVersion())){
                    incrementSwitchEspAction(task.getEventId());
                }
            }

            if(isCommonApp(task)){
                //补足应用到common应用中的某些action关联关系
                CreateApplicationRelationParam createApplicationRelationParam = new CreateApplicationRelationParam()
                            .setRelationList(relations)
                            .setNeo4jNodeKeyJson(neo4jNodeKeyJson)
                            .setCommonVersion(version)
                            .setApplicationVersion(version);
                applicationService.createApplication2CommonRelation(createApplicationRelationParam);
            }
            //检查侦测变动并更新
            monitorService.checkAndPush(task);
            log(task.getEventId(),"检查侦测并推送成功",2,null);

            //构建组件清单
            try {
                kgService.updateApplicationComponentList(task);
            } catch (Exception e) {
                log.error("更新应用组件清单失败");
            }

            //清除km缓存
            //cleanCache();
            if (mechanismFirstCompileSuccess) {
                log(task.getEventId(),"更新全部成功",0,2);
                task.setStatus(DeployConstants.DeployStatus.done);
            } else {
                task.setStatus(DeployConstants.DeployStatus.warn);
                log(task.getEventId(),"更新操作成功，机制一次编译失败",0, 2);
            }
        }catch (Exception e){
            task.setStatus(DeployConstants.DeployStatus.error);
            task.setMsg(e.getMessage());
            log.error(e.getMessage(),e);
            log(task.getEventId(),"更新操作失败,"+e.getMessage(),0,3);
            try {cleanData(task,task.getSourceId(),Constant.PUBLISH_VERSION,null);}catch (Exception e2){}
        }
        task.setEndTime(new Date());
        task.setUpdateTime(System.currentTimeMillis());
        Long duration = DateUtil.between(task.getBeginTime(),task.getEndTime(), DateUnit.SECOND);
        task.setCost(duration);
        mongoTemplate.save(task);
        checkParent(task.getParentEventId());
    }


    private void checkParent(String parentEventId) {
        if (StringUtils.isEmpty(parentEventId)) {
            return;
        }
        DeployTask task = mongoTemplate.findOne(Query.query(Criteria.where("eventId").is(parentEventId)), DeployTask.class);
        if (null == task || CollectionUtil.isEmpty(task.getSubEventIds())) {
            return;
        }
        List<DeployTask> subTasks = mongoTemplate.find(Query.query(Criteria.where("eventId").in(task.getSubEventIds())), DeployTask.class);
        if (CollectionUtil.isEmpty(subTasks)) {
            return;
        }
        boolean hasRun = false;
        for (DeployTask t : subTasks) {
            if (DeployConstants.DeployStatus.create == t.getStatus() || DeployConstants.DeployStatus.doing == t.getStatus()) {
                hasRun = true;
                continue;
            }
            if (DeployConstants.DeployStatus.error == t.getStatus()) {
                task.setStatus(3);
                task.setMsg(t.getMsg());
                mongoTemplate.save(task);
                break;
            }
        }
        if (!hasRun) {
            task.setStatus(2);
            mongoTemplate.save(task);
        }
    }
    /**
     * 执行一次编译逻辑，从 mongodb 文件中找到机制 code
     * @param task
     * @param mongoData
     */
    private void executeMechanismFirstCompile(DeployTask task, List<ApplicationMongoData> mongoData) {
        List<String> mechanismCodes = mongoData
                .stream()
                .filter(each ->
                        ("knowledgegraphSystem" + getDbSuffix()).equals(each.getDb())
                                && "mechanism".equals(each.getCol()))
                .findFirst()
                .map(each ->
                        each.getDocs()
                                .stream()
                                .map(doc ->
                                        doc.get("code").toString())
                                .collect(Collectors.toList()))
                .orElseGet(Collections::emptyList);
        log(task.getEventId(),String.format("开始机制一次编译, mechanismCodes:%s", String.join(",", mechanismCodes)),1, null);
        kgService.executeMechanismCompile(task, mechanismCodes);
        log(task.getEventId(),String.format("机制一次编译成功, mechanismCodes:%s", String.join(",", mechanismCodes)),1, null);
    }


    private void incrementSwitchEspAction(String id){
        log.info("try incrementSwitchEspAction......");
        RLock rLock = redissonClient.getLock(DeployConstants.cachePrefix + "incrementSwitchEspAction");
        if(rLock.tryLock()){
            try {
                log.info("incrementSwitchEspAction......");
                actionService.incrementSwitchEspAction(id);
            }finally {
                rLock.unlock();
            }
        }
    }

    private void checkAppAndTenant(DeployTask task){

            Map<String,Object> map3 =new HashMap<>();
            map3.put("code",task.getAppId());
            List app = Lists.newArrayList();
            if(app.isEmpty()){
                log(task.getEventId(),"创建应用",1,null);
                createApplication(task.getAppId(), task.getAppName(),Boolean.TRUE.equals(task.getCommonApp()));
            }
        if(CollectionUtil.isNotEmpty(task.getTenantIds())){
            log(task.getEventId(),"检查租户",1,null);
            List<String> oldTenantIds = new ArrayList<>();
            List<Map<String,Object>> tenants = Lists.newArrayList();
            tenants.forEach(t->{
                try{
                    String tenantId = (String) t.get("tenantId");
                    oldTenantIds.add(tenantId);
                }catch (Exception e){
                    log.error("checkAppAndTenant error",e);
                }
            });
            List<String> newTenantIds = CollectionUtil.subtractToList(task.getTenantIds(),oldTenantIds);
            for (String newTenantId : newTenantIds) {
                String tenantName = newTenantId;
                if(null!=task.getTenantIdNames()){
                    tenantName = task.getTenantIdNames().get(newTenantId);
                }
                createTenant(newTenantId,tenantName,task.getVersion());
            }
//            neo4jCrudService.createRelation("TenantEntity",MapUtil.of("tenantId",task.getTenantIds()),"AppEntity",map3,"USE");
        }

        try {
            checkAppAndTenant2(task,task.getTenantIds());
        }catch (Exception e){
            e.printStackTrace();
        }


    }
    private void checkAppAndTenant2(DeployTask task,List<String> tenantIds){

        if(CollectionUtil.isEmpty(tenantIds)){return;}
        //创建tenantEntity
        CrudReq req2 = new CrudReq();
        req2.setDbName(Constant.db_kg_sys);
        req2.setColName("tenantEntity");
        Map<String,Object> param2 = new HashMap<>();
        param2.put("tenantId",tenantIds);
        req2.setParams(param2);
        List<Document> tenantInDb =mongoCrudService.query(req2);
        List<String> tenantIdInDb = tenantInDb.stream().map(document -> (String)document.get("tenantId")).collect(Collectors.toList());
        List<String> tenantIdInDbTodo = notContain(tenantIds,tenantIdInDb);
        ApplicationMongoData insertReq2 = new ApplicationMongoData();
        insertReq2.setDb(Constant.db_kg_sys);
        insertReq2.setCol("tenantEntity");
        for(String t:tenantIdInDbTodo){
            Document document = new Document();
            document.put("tenantId",t);
            document.put("version",task.getVersion());
            insertReq2.getDocs().add(document);
        }
        mongoCrudService.insert(insertReq2);


        //创建tenantAppRelation
        CrudReq req1 = new CrudReq();
        req1.setDbName(Constant.db_kg_sys);
        req1.setColName("tenantAppRelation");
        Map<String,Object> param1 = new HashMap<>();
        param1.put("appCode",task.getAppId());
        param1.put("tenantId",tenantIds);
        req1.setParams(param1);
        List<Document> apps = mongoCrudService.query(req1);
        List<String> tenantIds1 = apps.stream().map(document -> (String)document.get("tenantId")).collect(Collectors.toList());
        List<String> tenantIds1Todo = notContain(tenantIds,tenantIds1);
        ApplicationMongoData insertReq1 = new ApplicationMongoData();
        insertReq1.setDb(Constant.db_kg_sys);
        insertReq1.setCol("tenantAppRelation");
        for(String tenantId:tenantIds1Todo){
            Document document = new Document();
            document.put("tenantId",tenantId);
            document.put("appCode",task.getAppId());
            insertReq1.getDocs().add(document);
        }
        mongoCrudService.insert(insertReq1);
    }


    private List<String> notContain(List<String> all,List<String> sub){
        List<String> notcontain = new ArrayList<>();
        for(String str : all){
            if(!sub.contains(str)){
                notcontain.add(str);
            }
        }
        return notcontain;
    }

    private void cleanData(DeployTask task,String sourceId,String version,List<String> tenantIds){

        if(StringUtils.isEmpty(sourceId)){
            log.warn("cleanData need sourceId");
            return;
        }
        if(CollectionUtil.isNotEmpty(task.getJobList())){
            cleanDataForJobList(task,sourceId,version,tenantIds);
            return;
        }
        log(task.getEventId(), "开始删除老版本neo4j:"+version,1,null);
//        neo4jCrudService.cleanNeo4jData(sourceId,version,tenantIds);
        log(task.getEventId(), "删除老版本neo4j成功:"+version,2,null);
        log(task.getEventId(), "开始删除老版本mongo:"+version,1,null);

        Map<String,Object> params = new HashMap<>();
        params.put("version",version);
        params.put("sourceId",sourceId);
        Bson bson = MongoCrudService.buildBson(params);
        List<KmTable> tables = cleanableCaches.getKmTables();
        for(KmTable table :tables){
            if("neo4j".equalsIgnoreCase(table.getType())){
                continue;
            }
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).deleteMany(bson);
        }
        log(task.getEventId(), "删除老版本mongo成功:"+version,2,null);
    }

    private void cleanDataForJobList(DeployTask task,String sourceId,String version,List<String> tenantIds){
        log(task.getEventId(), "开始删除老版本neo4j "+version,2,null);
        Map<String,Object> baseMap = new HashMap<>();
        baseMap.put("sourceId",sourceId);
        baseMap.put("version",version);
        if(!CollectionUtils.isEmpty(tenantIds) &&
                (DeployConstants.DeployType.tenantApp.equalsIgnoreCase(task.getType())
                        || DeployConstants.DeployType.tenantCustom.equalsIgnoreCase(task.getType())
                        || DeployConstants.DeployType.eocCustom.equalsIgnoreCase(task.getType()))){
            baseMap.put("tenantId",tenantIds);
        }
        for(JobRecord record: task.getJobList()){
            if(CollectionUtil.isEmpty(record.getKeys())){continue;}
            if("neo4j".equalsIgnoreCase(record.getDb())){
                for(Map<String,Object> condition: record.getKeys()){
                    if(condition.isEmpty()){continue;}
                    Map<String,Object> param = new HashMap<>();
                    param.putAll(baseMap);
                    param.putAll(condition);
//                    neo4jCrudService.cleanNeo4jData(record.getTable(),param);
                }
            }else{
                for(Map<String,Object> key: record.getKeys()){
                    if(key.isEmpty()){continue;}
                    Map<String,Object> param = new HashMap<>();
                    param.putAll(baseMap);
                    param.putAll(key);
                    Bson bson = MongoCrudService.buildBson(param);
                    mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(record.getDb() + getDbSuffix()).getCollection(record.getTable()).deleteMany(bson);
                }
            }

        }
        log(task.getEventId(), "删除老版本neo4j成功 "+version,4,null);

    }

    public DeployResp cleanAppByNamespace(String namespace, Boolean force,String token){
        DeployResp resp = new DeployResp();
        if(StringUtils.isEmpty(namespace)){return resp;}
        monitorService.deleteMonitorRules(namespace, token);
        Map<String,Object> param = new HashMap<>();
        param.put("athena_namespace",namespace);
        String cyhper = "match(node) where node.athena_namespace=$athena_namespace detach delete node";
//        neo4jCrudService.executeCypher(cyhper,param);
     //   Bson bson = MongoCrudService.buildBson(param);
        Bson bson = Filters.and(
                Filters.or(Filters.eq("application", namespace), Filters.eq("athena_namespace", namespace)),
                Filters.or(Filters.eq("tenantId", null), Filters.eq("tenantId", "SYSTEM"), Filters.and(Filters.ne("tenantId", null), Filters.ne("tenantId", "SYSTEM"), Filters.eq("athena_publishType", "individualCase")))
        );
        if(Boolean.TRUE.equals(force)){
            bson = Filters.or(Filters.eq("application", namespace), Filters.eq("athena_namespace", namespace));
        }
        List<KmTable> tables = cleanableCaches.getKmTables();
        for(KmTable table :tables){
            if("neo4j".equalsIgnoreCase(table.getType())){
                continue;
            }
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).deleteMany(bson);
        }
//        kgService.updateApplicationComponentList(namespace,Constant.TEST_VERSION,null);
//        kgService.updateApplicationComponentList(namespace,Constant.PROD_VERSION,null);
        return resp;
    }

    public DeployResp cleanAppBySourceId(String sourceId, String appId, String token){
        DeployResp resp = new DeployResp();
        if(StringUtils.isEmpty(sourceId)){return resp;}

        DeployTask task = mongoTemplate.findOne(Query.query(Criteria.where("sourceId").is(sourceId)),DeployTask.class);
        if(null==appId){
            if(null!=task){
                appId = task.getAppId();
            }else{
                resp.setCode(1);
                resp.setMsg("cant find appId by sourceId:"+sourceId);
            }
        }
        monitorService.deleteMonitorRules(appId, token);
        Map<String,Object> param = new HashMap<>();
        param.put("sourceId",sourceId);
        String cyhper = "match(node) where node.sourceId=$sourceId detach delete node";
        // neo4jCrudService.executeCypher(cyhper,param);
        Bson bson = MongoCrudService.buildBson(param);
        List<KmTable> tables = cleanableCaches.getKmTables();
        for(KmTable table :tables){
            if("neo4j".equalsIgnoreCase(table.getType())){
                continue;
            }
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).deleteMany(bson);
        }
        if(null!=task && DeployConstants.DeployType.app.equalsIgnoreCase(task.getType())){
            deleteAppEntity(appId);
        }
//        kgService.updateApplicationComponentList(appId,Constant.TEST_VERSION,null);
//        kgService.updateApplicationComponentList(appId,Constant.PROD_VERSION,null);
        return resp;
    }

    private void deleteAppEntity(String appId){
        Map<String,Object> param = new HashMap<>();
        param.put("code",appId);
        String cyhper = "match(node:AppEntity) where node.code=$code detach delete node";
        //neo4jCrudService.executeCypher(cyhper,param);
    }


    private void createApplication(String appCode,String appName,Boolean commonApp){
        String name= appName==null?appCode:appName;
        String cql = "create(app:AppEntity{code:$code,athena_namespace:$code,namespace:$code,name:$name,commonApp:$commonApp,version:'2.0'})";
        Map map = new HashMap();
        map.put("code",appCode);
        map.put("name",name);
        map.put("commonApp",commonApp);
        // neo4jCrudService.executeCypher(cql,map);
        //mongo application表

    }
    private void createTenant(String tenantId,String tenantName,String version){
        String name= tenantName==null?tenantId:tenantName;
        String cql = "create(app:TenantEntity{tenantId:$tenantId,tenantName:$name,version:$version})";
        Map map = new HashMap();
        map.put("tenantId",tenantId);
        map.put("name",name);
        map.put("version",version);
        // neo4jCrudService.executeCypher(cql,map);
    }


    private void processApplicationData(DeployTask task,ApplicationData data){

        //neo4j 刷库
        if(DeployConstants.DeployType.app.equalsIgnoreCase(task.getType())){
            processApplicationData(task,data,Constant.SYSTEM);
        }else if(DeployConstants.DeployType.tenantApp.equalsIgnoreCase(task.getType())
                || DeployConstants.DeployType.tenantCustom.equalsIgnoreCase(task.getType())
                || DeployConstants.DeployType.eocCustom.equalsIgnoreCase(task.getType())){
            for(String tenantId:task.getTenantIds()){
                processApplicationData(task,data,tenantId);
            }
        }
        log(task.getEventId(), "数据刷入成功",20,null);
    }

    public static void main(String[] args) {
        String cypher = "create (node:Tag{athena_namespace:'APC9d5e51',code:'performer__apc_project_schedule__ORDER_40',commonApp:false,source:'designer',compileVersion:'0.0.0.2504010918_alpha',version:'{athena_version}',scope:['column'],name:'顺序40',tenantId:'SYSTEM',namespacePath:'task&apc_project_schedule',id:959381334059384834,nameSpace:'APC',category:'ORDER',status:1})";
        String tenantReplace = "tenantId:'tenant001',sourceLevel:200";
        cypher = cypher.replaceAll("tenantId:'SYSTEM'",tenantReplace);
        System.out.println(cypher);
    }

    private void processApplicationData(DeployTask task,ApplicationData data,String tenantId){
            log(task.getEventId(), "开始刷入数据 tenant:"+tenantId,1,null);
            List<String> cyphers = new ArrayList<>();
            for (String cypher : data.getCyphers()) {
                cypher= cypher.replaceAll("\\{athena_version}", Constant.PUBLISH_VERSION);
                cypher= cypher.replaceAll("\\{common_version}", task.getVersion());
                String tenantReplace = "tenantId:'"+tenantId+"',"+"sourceId:'"+task.getSourceId()+"'";
                if(DeployConstants.DeployType.tenantApp.equalsIgnoreCase(task.getType()) ){
                    tenantReplace = tenantReplace + ",sourceLevel:"+DeployConstants.SourceLevel.tenantApp;
                }else if(DeployConstants.DeployType.tenantCustom.equalsIgnoreCase(task.getType()) ){
                    tenantReplace = tenantReplace + ",sourceLevel:"+DeployConstants.SourceLevel.tenantCustom;
                } else if(DeployConstants.DeployType.eocCustom.equalsIgnoreCase(task.getType()) ){
                    tenantReplace = tenantReplace + ",sourceLevel:"+DeployConstants.SourceLevel.eocCustom;
                }
                cypher = cypher.replaceAll("tenantId:'SYSTEM'",tenantReplace);
                if(DeployConstants.DeployType.tenantApp.equalsIgnoreCase(task.getType())
                        || DeployConstants.DeployType.tenantCustom.equalsIgnoreCase(task.getType())
                        || DeployConstants.DeployType.eocCustom.equalsIgnoreCase(task.getType())){
                    cypher = cypher.replaceAll("tenantId='SYSTEM0'","tenantId='"+tenantId+"'");
                }
                cyphers.add(cypher);
            }
            //neo4jCrudService.executeCyphers(cyphers,new HashMap<>());
            //mongo 刷库
            for(ApplicationMongoData item:data.getMongoData()){
                item.getDocs().forEach(document -> {
                    Object docTenantId = document.get("tenantId");
                    if(StringUtils.isEmpty(docTenantId) || "SYSTEM".equals(docTenantId)
                    || DeployConstants.DeployType.tenantApp.equalsIgnoreCase(task.getType())
                            || DeployConstants.DeployType.tenantCustom.equalsIgnoreCase(task.getType())
                            || DeployConstants.DeployType.eocCustom.equalsIgnoreCase(task.getType())){
                        document.put("tenantId",tenantId);
                    }
                });
                mongoCrudService.insert(item);
                log(task.getEventId(), "mongo插入 "+item.getDb()+" "+item.getCol()+" "+item.getDocs().size()+"条记录",0,null);
            };

    }

    private void updateVersion(DeployTask task,ApplicationData appData){

        log(task.getEventId(), "开始更新发版数据版本neo4j",1,null);
        String cypher = "match(n{sourceId:$sourceId,version:$version}) set n.version=$updateVersion";
        Map<String,Object> params = new HashMap<>();
        params.put("sourceId",task.getSourceId());
        params.put("version",Constant.PUBLISH_VERSION);
        params.put("updateVersion",task.getVersion());
        //neo4jCrudService.executeCypher(cypher,params);
        log(task.getEventId(), "更新发版数据版本neo4j成功",2,null);

        log(task.getEventId(), "开始更新发版数据版本mongo",1,null);
        for (ApplicationMongoData item : appData.getMongoData()) {
            Map<String,Object> param1 = new HashMap<>();
            param1.put("sourceId",task.getSourceId());
            param1.put(Constant.version,Constant.PUBLISH_VERSION);
            Bson setv = Updates.set(Constant.version,task.getVersion());
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(item.getDb()).getCollection(item.getCol()).updateMany(buildBson(param1),setv);
        }
        log(task.getEventId(), "更新发版数据版本mongo成功",2,null);
    }


    public void cleanCache(){
        kgService.cleanCache();
        atmcService.cleanCache();
    }


    private void log(String group,String msg,Integer process,Integer status){
        helpService.logDetail(group,msg,process,status);
    }

    private boolean isCommonApp(DeployTask task){
        return Boolean.TRUE.equals(task.getCommonApp());
    }
    public DeployResp test_initApplicationSourceId(DeployReq request) throws IOException {
        DeployResp resp = new DeployResp();
        //参数校验
        if( null==request.getSourceId() || null==request.getAppId() ){
            return DeployResp.failed(1,"参数错误");
        }

        String cypher = "match(n) where n.athena_namespace=$appId and not any(label in labels(n) WHERE label in ['AppEntity','TenantEntity']) set n.sourceId=$sourceId";
        Map<String,Object> params = new HashMap<>();
        params.put("appId",request.getAppId());
        params.put("sourceId",request.getSourceId());
        // neo4jCrudService.executeCypher(cypher,params);

        Bson bson = Filters.and(
                Filters.or(Filters.eq("application", request.getAppId()), Filters.eq("athena_namespace", request.getAppId())),
                Filters.or(Filters.eq("tenantId", null), Filters.eq("tenantId", "SYSTEM"), Filters.and(Filters.ne("tenantId", null), Filters.ne("tenantId", "SYSTEM"), Filters.eq("athena_publishType", "individualCase")))
        );
//        Map<String,Object> param1 = new HashMap<>();
//        param1.put("athena_namespace",request.getAppId());
//        param1.put("tenantId","SYSTEM");
        Bson setv = Updates.set("sourceId",request.getSourceId());
        List<KmTable> tables = cleanableCaches.getKmTables();
        for(KmTable table :tables){
            if("neo4j".equalsIgnoreCase(table.getType())){
                continue;
            }
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).updateMany(bson,setv);
        }

        return  resp;
    }


    public DeployResp test_cleanApplicationSourceId(DeployReq request) throws IOException {
        DeployResp resp = new DeployResp();
        //参数校验
        if(null==request.getAppId() ){
            return DeployResp.failed(1,"参数错误");
        }

        String cypher = "match(n) where n.athena_namespace=$appId set n.sourceId=null";
        Map<String,Object> params = new HashMap<>();
        params.put("appId",request.getAppId());
        //neo4jCrudService.executeCypher(cypher,params);
        Bson bson = Filters.or(Filters.eq("application", request.getAppId()), Filters.eq("athena_namespace", request.getAppId()));
        Bson setv = Updates.set("sourceId",null);
        List<KmTable> tables = cleanableCaches.getKmTables();
        for(KmTable table :tables){
            if("neo4j".equalsIgnoreCase(table.getType())){
                continue;
            }
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).updateMany(bson,setv);
        }

        return  resp;
    }

    public DeployResp test_initTenantId() throws IOException {
        DeployResp resp = new DeployResp();


        String cypher = "match(n) where n.tenantId is null set n.tenantId='SYSTEM'";
        Map<String,Object> params = new HashMap<>();
        //neo4jCrudService.executeCypher(cypher,params);

        String cypher2 = "match(t:TenantEntity{ifCommon:true})-[]->(n) set n.commonApp=true";
        Map<String,Object> params2 = new HashMap<>();
        //neo4jCrudService.executeCypher(cypher2,params2);


        Bson qb = Filters.or(Filters.exists("tenantId",false),Filters.eq("tenantId",null),Filters.eq("tenantId",""));
        Bson setv = Updates.set("tenantId","SYSTEM");
        List<KmTable> tables = cleanableCaches.getKmTables();
        for(KmTable table :tables){
            if("neo4j".equalsIgnoreCase(table.getType())){
                continue;
            }
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(table.getDb()).getCollection(table.getTable()).updateMany(qb,setv);
        }

        return  resp;
    }


    public void cleandeploy(String deployId){
        Query query = Query.query(Criteria.where("deployId").is(deployId));
        //todo 临时不删除DeployTask，因为有个判断如果没发过记录则会初始化sourceid
       // mongoTemplate.remove(query,DeployTask.class);
        mongoTemplate.remove(query,DeployDataRecord.class);
        mongoTemplate.remove(query,DeployLog.class);
        mongoTemplate.remove(query, MonitorHash.class);

        String appDir = deployId;
        String applicationCompileZipPath = compileZipPath + File.separator + appDir ;
        String applicationCompileDataPath = compileDataPath + File.separator + appDir;
        FileUtil.del(applicationCompileZipPath);
        FileUtil.del(applicationCompileDataPath);
    }

    public boolean checkSource(String sourceId){
       long count= mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(Constant.db_kg_sys).getCollection("application"). countDocuments(Filters.eq("sourceId",sourceId));
        return count>0;
    }

    public void cleanHis(){

        long time = System.currentTimeMillis() - 15*24*3600*1000;
        Query query = Query.query(Criteria.where("updateTime").lt(time));
        List<DeployTask> tasks = mongoTemplate.find(query,DeployTask.class);
        System.out.println("清理历史数据...."+tasks.size());
        for(DeployTask task:tasks){
            cleandeploy(task.getDeployId());
        }
    }

    public void cleanTimeoutTask(){
        long time = System.currentTimeMillis() - expiredMinutes *60*1000;
        Query query = Query.query(Criteria.where("status").is(DeployConstants.DeployStatus.doing));
        List<DeployTask> tasks = mongoTemplate.find(query,DeployTask.class);
        for(DeployTask task:tasks){
            if(null!=task.getUpdateTime() && task.getUpdateTime()<time){
                System.out.println("任务已过期："+task);
                task.setStatus(DeployConstants.DeployStatus.timeout);
                task.setEndTime(new Date());
                mongoTemplate.save(task);
            }
        }
    }

    public void cleanAll(){
        Query query = new Query();
        mongoTemplate.remove(query,DeployTask.class);
        mongoTemplate.remove(query,DeployDataRecord.class);
        mongoTemplate.remove(query,DeployLog.class);
        mongoTemplate.remove(query,MonitorHash.class);

    }



    public List<KmTable>  initTables(){
        List<KmTable> tables = new ArrayList<>();
        List<KmTable> knowledgegraphSystem = Utils.loadObjects("/doc/knowledgegraphSystem.json", KmTable.class);
        List<KmTable> knowledgegraph = Utils.loadObjects("/doc/knowledgegraph.json", KmTable.class);
        List<KmTable> datamap = Utils.loadObjects("/doc/datamap.json", KmTable.class);
        List<KmTable> preset = Utils.loadObjects("/doc/preset.json", KmTable.class);
        List<KmTable> tagSystem = Utils.loadObjects("/doc/tagSystem.json", KmTable.class);
        List<KmTable> deliveryDesigner = Utils.loadObjects("/doc/deliveryDesigner.json", KmTable.class);
        List<KmTable> neo4j = Utils.loadObjects("/doc/neo4j.json", KmTable.class);
        tables.addAll(knowledgegraphSystem);
        tables.addAll(knowledgegraph);
        tables.addAll(datamap);
        tables.addAll(preset);
        tables.addAll(tagSystem);
        tables.addAll(deliveryDesigner);
        tables.addAll(neo4j);
        tables.forEach(table->{
            table.setDb(table.getDb()+getDbSuffix());
        });

        return tables;
    }

    public String getDbSuffix(){
        if(Boolean.TRUE.equals(appConfig.getUcMode())){
            return appConfig.getUcSuffix();
        }
        return "";
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Constant.db_datamap = Constant.db_datamap+getDbSuffix();
        Constant.db_kg = Constant.db_kg+getDbSuffix();
        Constant.db_kg_sys = Constant.db_kg_sys+getDbSuffix();
        restartTaking(null,true);

    }
}
