package com.digiwin.athena.km_deployer_service.service;

import com.digiwin.athena.deploy.DeployLog;
import com.digiwin.athena.km_deployer_service.domain.km.KmDeployLog;
import com.digiwin.athena.km_deployer_service.support.DeployContext;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.UUID;

@Service
@Slf4j
public class HelpService {


    @Autowired
    RedisLockRegistry redisLockRegistry;

    @Autowired
    MongoTemplate mongoTemplate;

    private static ThreadLocal<DeployContext> deployLocal = new InheritableThreadLocal<>();

    public static void setDeployContext(DeployContext context){
        deployLocal.set(context);
    }

    public static DeployContext getDeployContext(){
        return deployLocal.get();
    }

    // TODO: This method is not used anywhere in the codebase. It should be removed.
    public static void remove() {
        deployLocal.remove();
    }

    public static String uuid(){
        return UUID.randomUUID().toString().replaceAll("-","");
    }

    public boolean lock(String key){
        boolean result = redisLockRegistry.obtain(key).tryLock();
        return result;
    }

    public void logDetail(String group,String msg,Integer process,Integer status){
        if(null==process){
            process=0;
        }
        if(null==status){
            status=1;
        }
        DeployContext context = HelpService.getDeployContext();
        context.setProcess(context.getProcess()+process);
        DeployLog dlog = new DeployLog();
        dlog.setDeployId(context.getDeployId());
        dlog.setEventId(context.getEventId());
        dlog.setAppId(context.getAppId());
        dlog.setSourceId(context.getSourceId());
        dlog.setProcess(context.getProcess());
        dlog.setGroup(group);
        dlog.setMsg(msg);
        dlog.setStatus(status);
        dlog.setCreateTime(System.currentTimeMillis());
        if(status!=2 && dlog.getProcess()>99){
            dlog.setProcess(99);
        }
        if(status==2){
            dlog.setProcess(100);
        }
        mongoTemplate.save(dlog);
        log.info(dlog.getAppId()+" "+dlog.getSourceId()+" "+dlog.getDeployId()+" "+dlog.getEventId()+" "+msg +" "+dlog.getProcess());
    }

    public void logDetail(String group,String msg,int process){
       logDetail(group,msg,process,1);
    }

    public void logDetail(String group,String msg){

        log.info(group+" "+msg);

    }
}
