package com.digiwin.athena.km_deployer_service.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.deploy.ApplicationData;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.deploy.DeployResp;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.povo.CommonParadigmDeployDto;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.spi.KgService;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class ParadigmDeployService {

    @Value("${compile.zipPath}")
    private String compileZipPath;

    @Value("${compile.dataPath}")
    private String compileDataPath;

    @Autowired
    DmcService dmcService;

    @Autowired
    MongoCrudService mongoCrudService;


    public DeployResp publishApplication(CommonParadigmDeployDto request) throws IOException {
        log.info("Route==>ParadigmDeployService method=publishApplication:{}", JSON.toJSONString(request));
        DeployResp response = new DeployResp();

        //参数校验
        if(null==request.getEnv()){
            return DeployResp.failed(1,"deployId is null");
        }
        if( null==request.getTenantId()){
            return DeployResp.failed(1,"sourceId is null");
        }
        if( null==request.getFileId()){
            return DeployResp.failed(1,"appId is null");
        }
        if(null==request.getToken()){
            return DeployResp.failed(1,"type is null");
        }


        //解析数据
        ApplicationData appData=parseFile(request.getFileId());

        if(null==appData || (CollectionUtil.isEmpty(appData.getCyphers()) && CollectionUtil.isEmpty(appData.getMongoData()))){
            return DeployResp.failed(1,"没有任何发布的数据");
        }

        //1.0数据处理
        for(ApplicationMongoData item:appData.getMongoData()){

            if("paradigm".equals(item.getCol())){
                Map<String,Object> params=new HashMap<>();
                params.put("application",Constant.PARADIGM_COMMON_APPLICATION_FLAG);
                dataProcess(item,params,Constant.TEST_VERSION);
            }
        }
        //2.0数据处理
        for(ApplicationMongoData item:appData.getMongoData()){

            if("paradigm".equals(item.getCol())){
                Map<String,Object> params=new HashMap<>();
                params.put("application",Constant.PARADIGM_COMMON_APPLICATION_FLAG);
                dataProcess(item,params,Constant.PROD_VERSION);
            }
        }
        return response;
    }

    /**
     * 数据处理，包含删除新增
     * @param item 数据
     * @param params 附加条件
     */
    private void dataProcess(ApplicationMongoData item,Map<String,Object> params,String version) {

        item.getDocs().forEach(document -> {

            document.remove("_id");
            //默认为发版
            document.put("version", version);
            Object docTenantId = document.get("tenantId");
            if(StringUtils.isEmpty(docTenantId) || "SYSTEM".equals(docTenantId)){
                document.put("tenantId",Constant.SYSTEM);
            }
        });

        //批量删除
        log.info("Route==>ParadigmDeployService delete version:{},params:{}",version,params);

        CrudReq crudReq = new CrudReq();
        //根据version版本号和application=commonParadigm的条件删除
        params.put(Constant.version,version);
        crudReq.setParams(params);
        crudReq.setDbName(item.getDb());
        crudReq.setColName(item.getCol());
        mongoCrudService.delete(crudReq);

        log.info("Route==>ParadigmDeployService add: mongo插入 {} {} {}条记录,version:{}", item.getDb(), item.getCol(), item.getDocs().size(),version);
        //批量落盘
        mongoCrudService.insert(item);
    }

    /**
     * 从dmc下载文件，解压，解析数据
     * @param fileId dmc文件id
     * @return  ApplicationData
     */
    public ApplicationData parseFile(String fileId) throws IOException {
        ApplicationData data = new ApplicationData();
        //解压运行态数据
        String appDir = Constant.PARADIGM_COMMON_APPLICATION_FLAG;
        String applicationCompileZipPath = compileZipPath + File.separator + appDir + File.separator;
        String applicationCompileDataPath = compileDataPath + File.separator + appDir + File.separator;
        String compileDataZipPath = applicationCompileZipPath + appDir + ".zip";
        InputStream inputStream = dmcService.download(fileId);
        FileUtil.writeFromStream(inputStream, compileDataZipPath);

        File compileDataDirector = new File(applicationCompileDataPath);//NOSONAR 该文件名是来自环境变脸的输入
        FileUtil.del(compileDataDirector);
        ZipUtil.unzip(compileDataZipPath, applicationCompileDataPath);
        File[] compileDataFiles = compileDataDirector.listFiles();
        if(null==compileDataFiles){return data;}
        for(File file: compileDataFiles){
            String parentFilename = file.getName();
            if("mongo".equals(parentFilename)){
                File[] parentDirs = file.listFiles();
                if(parentDirs==null){continue;}
                for (File parentDir : parentDirs) {
                    String filename = parentDir.getName();
                    if(isDb(filename)){
                        File[] dirs = parentDir.listFiles();
                        if(dirs==null){continue;}
                        for(File col:dirs){
                            String colName = col.getName();
                            if(isCol(col)){
                                ApplicationMongoData mongoData = new ApplicationMongoData();
                                mongoData.setDb(filename);
                                mongoData.setCol(colName);
                                File[] files = col.listFiles();
                                if(files==null){continue;}
                                for(File file1:files){
                                    if(file1.getName().endsWith("json")){
                                        List<String> lines = FileUtil.readLines(file1,"UTF-8");
                                        lines.forEach(line->{
                                            Document document = Document.parse(line);
                                            mongoData.getDocs().add(document);
                                        });

                                    }
                                }
                                data.getMongoData().add(mongoData);
                            }
                        }
                    } else{
                        log.info("Route==>ParadigmDeployService method=parseFile ignore file "+filename);
                    }
                }
            }
        }
        FileUtil.del(compileDataZipPath);
        FileUtil.del(applicationCompileDataPath);
        return data;
    }

    private boolean isCol(File file){
        return file.isDirectory();
    }

    private boolean isDb(String name){
        List<String> dbs = Arrays.asList("knowledgegraphSystem","datamap","preset","tagSystem","deliveryDesigner");
        return dbs.contains(name);
    }
}
