package com.digiwin.athena.km_deployer_service.service;

import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.povo.EspServiceMapDto;
import com.digiwin.athena.km_deployer_service.povo.PageVo;
import com.digiwin.athena.km_deployer_service.povo.ServerMapReq;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.digiwin.athena.km_deployer_service.service.km.servermap.ServerMapInfoAppender;
import com.digiwin.athena.km_deployer_service.service.km.servermap.ServerMapMongoAnalyzer;
import com.digiwin.athena.km_deployer_service.service.km.servermap.ServerMapNeo4jAnalyzer;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

@Slf4j
@Service
public class ServerMapService {

    private final MongoTemplate mongoTemplate;

    private final MongoCrudService mongoCrudService;

    private final Neo4jCrudService neo4jCrudService;

    @Value("${spring.data.mongodb.database}")
    private String dbName;

    @Value("${serverMap.mongo.batch.size:100}")
    private int mongoBatchSize;

    @Value("${serverMap.neo4j.batch.size:100}")
    private int neo4jBatchSize;


    public ServerMapService(MongoTemplate mongoTemplate, MongoCrudService mongoCrudService,
                            Neo4jCrudService neo4jCrudService) {
        this.mongoTemplate = mongoTemplate;
        this.mongoCrudService = mongoCrudService;
        this.neo4jCrudService = neo4jCrudService;
    }

    @SneakyThrows
    public void analysisServer() {
        long start = System.currentTimeMillis();
        ExecutorService executorService = Executors.newFixedThreadPool(10);
        List<Future<Void>> futures = new ArrayList<>();
        ServerMapInfoAppender appender = new ServerMapInfoAppender(mongoCrudService, neo4jCrudService);
        futures.add(executorService.submit(
                new ServerMapNeo4jAnalyzer("MonitorRule", "侦测", neo4jCrudService, mongoTemplate, appender, neo4jBatchSize, mongoBatchSize)));
        futures.add(executorService.submit(
                new ServerMapMongoAnalyzer("datamap","project", "project", "项目", mongoCrudService, mongoTemplate, appender, mongoBatchSize)
        ));
        futures.add(executorService.submit(
                // TODO 确认 pageView 是否是正确的
                new ServerMapMongoAnalyzer("datamap","pageView", "task","任务", mongoCrudService, mongoTemplate, appender, mongoBatchSize)
        ));
        futures.add(executorService.submit(
                new ServerMapMongoAnalyzer("knowledgegraphSystem", "activityConfigs", "basicActivity", "基础资料/报表", mongoCrudService, mongoTemplate, appender, mongoBatchSize)
        ));
        futures.add(executorService.submit(
                new ServerMapMongoAnalyzer("knowledgegraphSystem", "mechanismCapacity", "mechanism", "机制", mongoCrudService, mongoTemplate, appender, mongoBatchSize)
        ));
        futures.add(executorService.submit(
                new ServerMapMongoAnalyzer("knowledgegraphSystem", "variableDefinition", "variableDefinition", "机制变量", mongoCrudService, mongoTemplate, appender, mongoBatchSize)
        ));
        for (Future<Void> each : futures) {
            each.get();
        }
        executorService.shutdown();
        log.info("analysisServer finished cost: {}", System.currentTimeMillis() - start);
    }

    public PageVo<EspServiceMapDto> query(ServerMapReq req) {
        return mongoCrudService.queryWithPage(dbName, "espServiceMapDto", req.getQueryParams(),
                req.getPage(), req.getPageSize(), EspServiceMapDto.class);
    }

    public void delete(ServerMapReq req) {
        CrudReq deleteReq = new CrudReq();
        deleteReq.setDbName(dbName);
        deleteReq.setColName("espServiceMapDto");
        deleteReq.setParams(req.getQueryParams());
        mongoCrudService.delete(deleteReq);
    }

    public void update(ServerMapReq req) {
        CrudReq update = new CrudReq();
        update.setDbName(dbName);
        update.setColName("espServiceMapDto");
        update.setParams(req.getQueryParams());
        update.setData(req.getUpdateParams());
        mongoCrudService.update(update);
    }

    public void insert(List<EspServiceMapDto> dto) {
        mongoTemplate.insertAll(dto);
    }

    public void deleteAll() {
        mongoTemplate.dropCollection("espServiceMapDto");
    }
}
