package com.digiwin.athena.km_deployer_service.service;

import cn.hutool.core.map.MapUtil;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.km_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.mongodb.client.model.Updates;
import lombok.extern.slf4j.Slf4j;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

@Slf4j
@Service
public class ToolService {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    private Neo4jCrudService neo4jCrudService;
    @Autowired
    MongoCrudService mongoCrudService;

    @Autowired
    private Driver driver;

    public Map<String,Object> copyEntity(){
        Map<String,Object> result = new HashMap<>();
        //租户
        CrudReq req1 = new CrudReq();
        req1.setDbName(Constant.db_kg_sys);
        req1.setColName("tenantEntity");
        List<Document> tenantInDb =mongoCrudService.query(req1);
        List<String> tenantIdInDb = tenantInDb.stream().map(document -> (String)document.get("tenantId")).collect(Collectors.toList());
        ApplicationMongoData insertReq1 = new ApplicationMongoData();
        insertReq1.setDb(Constant.db_kg_sys);
        insertReq1.setCol("tenantEntity");
        String cql = "match (te:TenantEntity) return  te.tenantId as tenantId,te.tenantName as tenantName,te.version as version,te.customerServiceCode as customerServiceCode";
        List<Map<String, Object>> tenantEntities = neo4jCrudService.queryByDriver(cql, new HashMap<>());
        tenantEntities.forEach(t->{
            String tenantId = MapUtil.getStr(t, "tenantId");
            if(!tenantIdInDb.contains(tenantId)){
                insertReq1.getDocs().add(new Document(t));
                tenantIdInDb.add(tenantId);
            }
        });
        insert(insertReq1);
        result.put("tenantEntity",insertReq1.getDocs().size());

        //租户关系
        CrudReq req2 = new CrudReq();
        req2.setDbName(Constant.db_kg_sys);
        req2.setColName("tenantAppRelation");
        List<Document> tenantAppRelationsInDb =mongoCrudService.query(req2);
        List<String> tenantIdAppInDb2 = tenantAppRelationsInDb.stream().map(document -> document.get("tenantId")+":"+document.get("appCode")).collect(Collectors.toList());
        ApplicationMongoData insertReq2 = new ApplicationMongoData();
        insertReq2.setDb(Constant.db_kg_sys);
        insertReq2.setCol("tenantAppRelation");
        String cql2 = "match (te:TenantEntity)-[:USE]->(app:AppEntity) return te.tenantId as tenantId,app.code as appCode";
        List<Map<String, Object>> maps2 = neo4jCrudService.queryByDriver(cql2, new HashMap<>());
        maps2.forEach(map->{
            String tenantApp =  map.get("tenantId")+":"+map.get("appCode");
            if(!tenantIdAppInDb2.contains(tenantApp)){
                insertReq2.getDocs().add(new Document(map));
                tenantIdAppInDb2.add(tenantApp);
            }
        });
        insert(insertReq2);
        result.put("tenantAppRelation",insertReq2.getDocs().size());

        return result;
    }


    private List<String> notContain(List<String> all,List<String> sub){
        List<String> notcontain = new ArrayList<>();
        for(String str : all){
            if(!sub.contains(str)){
                notcontain.add(str);
            }
        }
        return notcontain;
    }

    private void insert(ApplicationMongoData data){
        // 批量插入
        int batchSize = 1000;
        Lists.partition(data.getDocs(), batchSize).forEach(docs -> {
            try {
                mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(data.getDb()).getCollection(data.getCol()).insertMany(docs);
            }catch (Exception e){
                log.error("批量插入失败 insert error", e);
                for(Document doc:docs){
                    try {
                        mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(data.getDb()).getCollection(data.getCol()).insertOne(doc);
                    }catch (Exception e2){
                        log.error("单个插入失败 insert error, doc: {}", doc, e2);
                    }
                }
            }
        });
    }

    public void updateSubType(){
        String db = Constant.db_kg_sys;
        String table="applicationRelation";
        Map<String,String> patternSubTypeMap = new HashMap<>();
        patternSubTypeMap.put("DATA_ENTRY","base_entry");
        patternSubTypeMap.put("STATEMENT","statement");

        Map<String,List<String>> patternCodes = new HashMap<>();
        String cypher = "match(a:Activity) return distinct a.code as code,a.pattern as pattern";
        List<Map<String, Object>> it = neo4jCrudService.queryByDriver(cypher, new HashMap<>());
        it.forEach(cp->{
            String code = (String) cp.get("code");
            String pattern = (String) cp.get("pattern");
            List<String> codes = patternCodes.get(pattern);
            if(null==codes){
                codes = new ArrayList<>();
                patternCodes.put(pattern,codes);
            }
            codes.add(code);
        });

        patternCodes.forEach((k,v)->{
            Map<String,Object> param1 = new HashMap<>();
            param1.put("type", "activity");
            param1.put("code", v);
       //     param1.put("subType", null);
            Bson q1 = MongoCrudService.buildBson(param1);
            String subType = patternSubTypeMap.get(k);
            if(null==subType){
                subType = k;
            }
            mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(table).updateMany(q1, Updates.set("subType", subType));
        });

        Map<String,Object> param3 = new HashMap<>();
        param3.put("type", "activity");
        param3.put("subType", null);
        Bson q3 = MongoCrudService.buildBson(param3);
        mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(table).updateMany(q3, Updates.set("subType", "activity"));
    }

//    public void updateSubType(){
//
//        String DATA_ENTRY = "match(a:Activity) where a.pattern='DATA_ENTRY' return distinct a.code as code";
//        String STATEMENT = "match(a:Activity) where a.pattern='STATEMENT' return distinct a.code as code";
//        Session session = sessionFactory.openSession();
//
//        List<String> DATA_ENTRYCodes= new ArrayList<>();
//        Iterable<String> it = session.query(String.class,DATA_ENTRY,new HashMap<>());
//        it.forEach(code->{
//            DATA_ENTRYCodes.add(code);
//        });
//
//        List<String> STATEMENTCodes= new ArrayList<>();
//        Iterable<String> it2 = session.query(String.class,STATEMENT,new HashMap<>());
//        it2.forEach(code->{
//            STATEMENTCodes.add(code);
//        });
//        String db = Constant.db_kg_sys;
//        String table="applicationRelation";
//
//
//        Map<String,Object> param1 = new HashMap<>();
//        param1.put("type", "activity");
//        param1.put("code", DATA_ENTRYCodes);
//        param1.put("subType", null);
//        Bson q1 = MongoCrudService.buildBson(param1);
//        mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(table).updateMany(q1, Updates.set("subType", "base_entry"));
//
//        Map<String,Object> param2 = new HashMap<>();
//        param2.put("type", "activity");
//        param2.put("code", STATEMENTCodes);
//        param2.put("subType", null);
//        Bson q2 = MongoCrudService.buildBson(param2);
//        mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(table).updateMany(q2, Updates.set("subType", "statement"));
//
//        Map<String,Object> param3 = new HashMap<>();
//        param3.put("type", "activity");
//        param3.put("subType", null);
//        Bson q3 = MongoCrudService.buildBson(param3);
//        mongoTemplate.getMongoDatabaseFactory().getMongoDatabase(db).getCollection(table).updateMany(q3, Updates.set("subType", "activity"));
//    }

    /**
     * 复制activity到mongo
     * @return 复制结果
     */
    public Map<String,Object> copyActivity() {
        log.info("开始 copy activity-----------------");
        Map<String, Object> result = new HashMap<>();
        //查询mongo中的activityConfigsBasic，第一次调用没有数据，后续调用存在数据了，比对mongo跟neo4j查询数据，如果有差异，则更新mongo，保证接口重复调用
        CrudReq req1 = new CrudReq();
        req1.setDbName(Constant.db_kg_sys);
        req1.setColName("activityConfigsBasic");
        List<Document> activityConfigsBasic =mongoCrudService.query(req1);
        List<String> codeSourceIdVersions = activityConfigsBasic.stream().map(document -> document.get("code") + "," + document.get("sourceId") + "," + document.get("version")).collect(Collectors.toList());
        result.put("mongo_count", codeSourceIdVersions.size());
        // 数据量不大  可以一次性加载进内存
        String cypher = "match(activity:Activity) where activity.version in ['1.0','2.0'] return activity ";
        // key为activity -> 值为activity的map
        List<Map<String, Object>> activityMaps = new Neo4jManager(driver).ExecuteQueryToMap(cypher, new HashMap<>());
        result.put("neo4j_count", activityMaps.size());
        // 去重后的activity的map数据
        List<Map<String, Object>> deduplicatedList = new ArrayList<>(
                activityMaps.stream().map(map -> {
                            return  convertToNestedMap((Map<String, Object>) map.get("activity"));
                        }).collect(Collectors.toMap(
                                map -> String.join(",",
                                        (String) map.get("code"),
                                        (String) map.get("sourceId"),
                                        (String) map.get("version")), // 使用code, sourceId, version的组合作为唯一键
                                map -> map, // 值为原始的Map对象
                                (existing, replacement) -> existing // 如果有重复，保留现有的Map对象
                        ))
                        .values() // 获取去重后的Map集合
        );
        result.put("neo4j_deduplicated_count", deduplicatedList.size());
        AtomicInteger insertCount = new AtomicInteger();
        ApplicationMongoData insertReq1 = new ApplicationMongoData();
        insertReq1.setDb(Constant.db_kg_sys);
        insertReq1.setCol("activityConfigsBasic");
        // activityConfigs中dependOnGroundEnd字段同时到activityConfigBasic表对应的记录中
        List<Map> codeDependOnGroundEndList = mongoCrudService.find(Constant.db_kg_sys, "activityConfigs", new Document(), new Document("code", 1).append("dependOnGroundEnd", 1).append("authorityPrefix", 1).append("_id", 0), Map.class);
        // 将结 codeDependOnGroundEndList 转为 key为code得值 -> value为dependOnGroundEnd值 的 Map
        Map<String, List<Boolean>> codeDependOnGroundEndMap = codeDependOnGroundEndList.stream()
                .filter(map -> map.get("code")!= null)
                .collect(Collectors.groupingBy(
                        map -> (String) map.get("code"),
                        Collectors.collectingAndThen(
                                Collectors.toList(),
                                list -> list.stream()
                                        .map(m -> (Boolean) m.get("dependOnGroundEnd"))
                                        .filter(Objects::nonNull) // 过滤掉 dependOnGroundEnd 为 null 的元素
                                        .collect(Collectors.toList())
                        )
                ));
        // 将结 codeDependOnGroundEndList 转为 key为code得值 -> value为authorityPrefix值 的 Map
        Map<String, List<String>> authorityPrefixMap = codeDependOnGroundEndList.stream()
                .filter(map -> map.get("code")!= null)
                .collect(Collectors.groupingBy(
                        map -> (String) map.get("code"),
                        Collectors.collectingAndThen(
                                Collectors.toList(),
                                list -> list.stream()
                                        .map(m -> (String) m.get("authorityPrefix"))
                                        .filter(Objects::nonNull) // 过滤掉 authorityPrefix 为 null 的元素
                                        .collect(Collectors.toList())
                        )
                ));
        deduplicatedList.forEach(map -> {
          String codeSourceIdVersion = String.join(",", (String) map.get("code"), (String) map.get("sourceId"), (String) map.get("version"));
            if(!codeSourceIdVersions.contains(codeSourceIdVersion)){
                if (codeDependOnGroundEndMap.containsKey((String) map.get("code")) && !CollectionUtils.isEmpty(codeDependOnGroundEndMap.get((String) map.get("code")))) {
                    map.put("dependOnGroundEnd", codeDependOnGroundEndMap.get((String) map.get("code")).get(0));
                }
                if (authorityPrefixMap.containsKey((String) map.get("code")) && !CollectionUtils.isEmpty(authorityPrefixMap.get((String) map.get("code")))) {
                    map.put("authorityPrefix", authorityPrefixMap.get((String) map.get("code")).get(0));
                }
                insertReq1.getDocs().add(new Document(map));
                codeSourceIdVersions.add(codeSourceIdVersion);
                insertCount.getAndIncrement();
            }
        });
        // 批量插入
        insert(insertReq1);
        result.put("insertCount", insertCount);
        log.info("copy activity 结束------------------");
        return result;
    }

    public List<Map<String, Object>> getActivity() {
        List<Map> codeDependOnGroundEndList = mongoCrudService.find(Constant.db_kg_sys, "activityConfigs", new Document(), new Document("code", 1).append("dependOnGroundEnd", 1).append("_id", 0), Map.class);
        // 将结 codeDependOnGroundEndList 转为 key为code得值 -> value为dependOnGroundEnd值 的 Map
        Map<String, Set<Boolean>> codeDependOnGroundEndMap = codeDependOnGroundEndList.stream()
                .filter(map -> map.get("code")!= null)
                .collect(Collectors.groupingBy(map -> (String) map.get("code"), Collectors.mapping(map -> (Boolean) map.get("dependOnGroundEnd"), Collectors.toSet())));
        // 查询neo4j中的activity，将code和dependOnGroundEnd合并到一起
        String cypher = "match(activity:Activity) where activity.version in ['1.0','2.0'] return activity ";
        List<Map<String, Object>> re = new Neo4jManager(driver).ExecuteQueryToMap(cypher, new HashMap<>());
        List<Map<String, Object>> deduplicatedList = new ArrayList<>(
                re.stream().map(map -> {
                            return (Map<String, Object>) map.get("activity");
                        }).collect(Collectors.toMap(
                                map -> String.join(",",
                                        (String) map.get("code"),
                                        (String) map.get("sourceId"),
                                        (String) map.get("version")), // 使用code, sourceId, version的组合作为唯一键
                                map -> map, // 值为原始的Map对象
                                (existing, replacement) -> existing // 如果有重复，保留现有的Map对象
                        ))
                        .values() // 获取去重后的Map集合
        );
        return deduplicatedList;
    }

    public static void main(String[] args) {
        // 示例输入
        Map<String, Object> flatMap = new HashMap<>();
        flatMap.put("_id", "111");
        flatMap.put("code", "code");
        flatMap.put("lang.name.zh_CN", "api作业员");
        flatMap.put("lang.name.zh_US", "api作业员");
        flatMap.put("expectedDuration", "{'dueDateType':0,'type':'MINUTE','value':0}");

        // 转换为嵌套Map
        Map<String, Object> nestedMap = convertToNestedMap(flatMap);
        System.out.println(nestedMap);
    }

    /**
     * 将扁平的Map转换为嵌套的Map
     * @param flatMap 扁平的Map
     * @return  嵌套的Map，去除_id字段
     */
    public static Map<String, Object> convertToNestedMap(Map<String, Object> flatMap) {
        Map<String, Object> result = new HashMap<>();

        for (Map.Entry<String, Object> entry : flatMap.entrySet()) {
            String key = entry.getKey();
            // 去除_id字段
            if ("_id".equals(key)) {
                continue;
            }
            Object value = entry.getValue();

            if (key.contains(".")) {
                // 处理点号分隔的键
                String[] keys = key.split("\\.");
                Map<String, Object> currentMap = result;

                for (int i = 0; i < keys.length - 1; i++) {
                    currentMap.putIfAbsent(keys[i], new HashMap<String, Object>());
                    currentMap = (Map<String, Object>) currentMap.get(keys[i]);
                }

                currentMap.put(keys[keys.length - 1], value);
            } else if (isJsonStyle(value)) {
                // 处理JSON样式的字符串值
                Object jsonValue = parseJsonStyleString((String) value);
                result.put(key, jsonValue);
            } else {
                // 直接放入结果Map
                result.put(key, value);
            }
        }

        return result;
    }

    private static boolean isJsonStyle(Object value) {
        // 简单检查是否可能是JSON样式的字符串（这里假设用单引号包围，需要转换为JSON格式）
        if (value instanceof String) {
            String valueString = (String) value;
            return (valueString.startsWith("{") && valueString.endsWith("}")) || (valueString.startsWith("[") && valueString.endsWith("]"));
        } else {
            return false;
        }
    }

    private static Object parseJsonStyleString(String value) {
        // 将单引号替换为双引号以符合JSON格式
        String jsonCompatibleString = value.replace("'", "\"");
        try {
            if (value.startsWith("{") && value.endsWith("}")) {
                return new ObjectMapper().readValue(jsonCompatibleString, Map.class);
            } else if (value.startsWith("[") && value.endsWith("]")) {
                return new ObjectMapper().readValue(jsonCompatibleString, List.class);
            } else {
                return new ObjectMapper().readValue(jsonCompatibleString, Object.class);
            }
        } catch (JsonProcessingException e) {
            // json解析失败，返回原字符串
            log.error("解析JSON样式字符串失败, value: {}", value, e);
            return value;
        }
    }

}
