package com.digiwin.athena.km_deployer_service.service.appEntity.impl;


import cn.hutool.core.util.StrUtil;
import com.digiwin.athena.km_deployer_service.service.appEntity.AppEntityService;
import com.digiwin.athena.km_deployer_service.util.Neo4jMultipleUtil;
import lombok.extern.slf4j.Slf4j;
import org.neo4j.driver.Driver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class AppEntityServiceImpl implements AppEntityService {

    @Autowired
    private Driver driver1;

    @Autowired(required = false)
    @Qualifier("domain2Driver")
    private Driver driver2;


    @Override
    public void initAppEntityVersion(String application, String version) {
        // 如果没有节点，创建节点version为1.0
        StringBuilder cql = new StringBuilder(StrUtil.format("MERGE (n:AppEntity{code:'{}'})", application));
        cql.append(StrUtil.format(" ON CREATE SET n.version = '{}',n.namespace = '{}' ", version, application));
        Neo4jMultipleUtil.executeCql(cql.toString(), driver1, driver2);
    }
}
