package com.digiwin.athena.km_deployer_service.service.asaDeploy.impl;

import com.digiwin.athena.km_deployer_service.config.mongodb.AsaMongodbConfig;
import com.digiwin.athena.km_deployer_service.config.mongodb.DataMapMongodbConfig;
import com.digiwin.athena.km_deployer_service.config.mongodb.KgsysMongodbConfig;
import com.digiwin.athena.km_deployer_service.config.mongodb.PresetMongodbConfig;
import com.digiwin.athena.km_deployer_service.domain.asa.param.DeployVersionParam;
import com.digiwin.athena.km_deployer_service.domain.asa.param.SwitchVersionParam;
import com.digiwin.athena.km_deployer_service.helper.AniaHelper;
import com.digiwin.athena.km_deployer_service.helper.AssistantRhApiHelper;
import com.digiwin.athena.km_deployer_service.helper.IMApiHelper;
import com.digiwin.athena.km_deployer_service.service.appEntity.AppEntityService;
import com.digiwin.athena.km_deployer_service.service.asaDeploy.AsaDeployService;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.CacheService;
import com.digiwin.athena.km_deployer_service.service.km.TenantService;
import com.digiwin.athena.km_deployer_service.service.page.PageService;
import com.digiwin.athena.km_deployer_service.spi.AtmcService;
import com.digiwin.athena.km_deployer_service.spi.KgService;
import com.digiwin.athena.km_deployer_service.template.ITemplate;
import com.digiwin.athena.km_deployer_service.thread.DeployThread;
import com.digiwin.athena.km_deployer_service.thread.SwitchVersionThread;
import com.digiwin.athena.km_deployer_service.util.CurThreadInfoUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * 部署服务
 */
@Slf4j
@Service
public class AsaDeployServiceImpl implements AsaDeployService {
    @Resource(name = AsaMongodbConfig.MONGO_TEMPLATE_REF)
    private MongoTemplate asaMongoTemplate;

    @Resource(name = DataMapMongodbConfig.MONGO_TEMPLATE_REF)
    private MongoTemplate kmMongoTemplate;

    @Resource(name = KgsysMongodbConfig.MONGO_TEMPLATE_REF)
    private MongoTemplate kgsysMongoTemplate;

    @Resource(name = PresetMongodbConfig.MONGO_TEMPLATE_REF)
    private MongoTemplate presetMongoTemplate;

    @Value("${compile.zipPath}")
    private String compileZipPath;

    @Value("${compile.dataPath}")
    private String compileDataPath;

    @Value("${spring.data.mongo-datamap.database}")
    private String datamapDBName;

    @Value("${spring.data.mongo-kgsys.database}")
    private String kgsysDBName;

    @Value("${spring.data.mongo-preset.database}")
    private String presetDBName;

    @Autowired
    private CacheService cacheService;

    @Autowired
    private DmcService dmcService;

    @Autowired
    private TenantService tenantService;

    @Autowired
    protected PageService pageService;

    @Autowired
    private AppEntityService appEntityService;

    @Autowired
    private IMApiHelper imApiHelper;

    @Autowired
    private KgService kgService;

    @Autowired
    private AtmcService atmcService;

    @Resource
    private ApplicationContext applicationContext;

    @Autowired
    private Map<String, ITemplate> templateMap;

    @Autowired
    private AssistantRhApiHelper assistantRhApiHelper;

    @Autowired
    private AniaHelper aniaHelper;

    @Override
    public void deploy(DeployVersionParam deployVersionParam) {
        // 部署过程利用SSE，采用流式处理方式返回athena_deploy，因此需要单独起线程来处理
        DeployThread deployThread = new DeployThread(deployVersionParam);
        deployThread.setCacheService(cacheService);
        deployThread.setDmcService(dmcService);
        deployThread.setTenantService(tenantService);
        deployThread.setPageService(pageService);
        deployThread.setAppEntityService(appEntityService);
        deployThread.setMongoTemplate(asaMongoTemplate);
        deployThread.setKmMongoTemplate(kmMongoTemplate);
        deployThread.setKgsysMongoTemplate(kgsysMongoTemplate);
        deployThread.setPresetMongoTemplate(presetMongoTemplate);
        deployThread.setImApiHelper(imApiHelper);
        deployThread.setKgService(kgService);
        deployThread.setAtmcService(atmcService);
        deployThread.setCompileZipPath(compileZipPath);
        deployThread.setCompileDataPath(compileDataPath);
        deployThread.setApplicationContext(applicationContext);
        deployThread.setTemplateMap(templateMap);
        deployThread.setDatamapDBName(datamapDBName);
        deployThread.setKgsysDBName(kgsysDBName);
        deployThread.setPresetDBName(presetDBName);
        deployThread.setAssistantRhApiHelper(assistantRhApiHelper);
        deployThread.setAniaHelper(aniaHelper);
        deployThread.setRouterKey(CurThreadInfoUtils.getRouterKey());
        deployThread.start();
    }

    /**
     * @description: 切换租户和应用数据之间的version
     * @author liyuetao
     * @date 2022/10/20 16:29
     */
    @Override
    public void switchVersion(SwitchVersionParam switchVersionParam) {
        SwitchVersionThread switchVersionThread = new SwitchVersionThread(switchVersionParam);
        switchVersionThread.setCacheService(cacheService);
        switchVersionThread.setMongoTemplate(asaMongoTemplate);
        switchVersionThread.setKmMongoTemplate(kmMongoTemplate);
        switchVersionThread.setKgsysMongoTemplate(kgsysMongoTemplate);
        switchVersionThread.setPresetMongoTemplate(presetMongoTemplate);
        switchVersionThread.setImApiHelper(imApiHelper);
        switchVersionThread.setKgService(kgService);
        switchVersionThread.setAtmcService(atmcService);
        switchVersionThread.setApplicationContext(applicationContext);
        switchVersionThread.setDatamapDBName(datamapDBName);
        switchVersionThread.setKgsysDBName(kgsysDBName);
        switchVersionThread.setPresetDBName(presetDBName);
        switchVersionThread.setTenantService(tenantService);
        switchVersionThread.setPageService(pageService);
        switchVersionThread.setAssistantRhApiHelper(assistantRhApiHelper);
        switchVersionThread.setAniaHelper(aniaHelper);
        switchVersionThread.setRouterKey(CurThreadInfoUtils.getRouterKey());
        switchVersionThread.start();
    }
}
