package com.digiwin.athena.km_deployer_service.service.assistant.impl;

import com.digiwin.athena.km_deployer_service.config.mongodb.AsaMongodbConfig;
import com.digiwin.athena.km_deployer_service.config.mongodb.PresetMongodbConfig;
import com.digiwin.athena.km_deployer_service.domain.asa.assistant.Assistant;
import com.digiwin.athena.km_deployer_service.service.assistant.AssistantService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Slf4j
@Service
public class AssistantServiceImpl implements AssistantService {
    @Resource(name = AsaMongodbConfig.MONGO_TEMPLATE_REF)
    private MongoTemplate asaMongoTemplate;

    @Override
    public Assistant getAssistant(String assistantCode, String version) {
        Query query = new Query(Criteria.where("assistantCode").is(assistantCode).and("version").is(version));
        Assistant assistant = asaMongoTemplate.findOne(query, Assistant.class, "assistant");

        return assistant;
    }
}
