package com.digiwin.athena.km_deployer_service.service.deploy;

import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class KmPublishRepo2  {

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    MongoCrudService mongoCrudService;

    public Set<String> findUseAppTenants(String appId, String version) {
        CrudReq req1 = new CrudReq();
        req1.setDbName(Constant.db_kg_sys);
        req1.setColName("tenantAppRelation");
        Map<String,Object> param1 = new HashMap<>();
        param1.put("appCode",appId);
        req1.setParams(param1);
        List<Document> apps = mongoCrudService.query(req1);
        List<String> tenantIds1 = apps.stream().map(document -> (String)document.get("tenantId")).collect(Collectors.toList());
        return new HashSet<>(tenantIds1);
    }

    public List<String> findUseSourceAppTenants(String sourceId, String version) {
        CrudReq req1 = new CrudReq();
        req1.setDbName(Constant.db_kg_sys);
        req1.setColName("application");
        Map<String,Object> param1 = new HashMap<>();
        param1.put("sourceId",sourceId);
        if(null!=version){
            param1.put("version",version);
        }
        req1.setParams(param1);
        List<Document> apps = mongoCrudService.query(req1);
        List<String> tenantIds1 = apps.stream().map(document -> (String)document.get("tenantId")).distinct().collect(Collectors.toList());
        return tenantIds1;
    }

    public String appSourceId(String appId) {
        CrudReq req1 = new CrudReq();
        req1.setDbName(Constant.db_kg_sys);
        req1.setColName("application");
        Map<String,Object> param1 = new HashMap<>();
        param1.put("code",appId);
        param1.put("tenantId","SYSTEM");
        req1.setParams(param1);
        try {
            List<Document> apps = mongoCrudService.query(req1);
            Optional<String> sourceIds = apps.stream().map(document -> (String)document.get("sourceId")).findFirst();
            if(sourceIds.isPresent()){
                return sourceIds.get();
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        return null;
    }

}
