package com.digiwin.athena.km_deployer_service.service.deploy;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.deploy.DeployConstants;
import com.digiwin.athena.deploy.DeployResp;
import com.digiwin.athena.deploy.DeployTask;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.domain.MonitorHash;
import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.repository.KmPublishRepo;
import com.digiwin.athena.km_deployer_service.povo.CrudReq;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
public class MonitorService {

    private final static String DEFAULT_VERSION = Constant.TEST_VERSION;
    private static final List<String> EXCLUDE_FIELDS = Arrays.asList("_id","_class" ,"id", "version", "compileVersion", "oldNodeId", "publishTime","sourceId","athena_namespace","application","pluginId","tenantId","deployId");


    @Resource
    private MongoCrudService mongoCrudService;
    @Resource
    private MongoTemplate mongoTemplate;
    @Resource
    private Neo4jCrudService neo4jCrudService;

    @Resource
    KmPublishRepo kmPublishRepo;

    @Autowired
    KmPublishRepo2 kmPublishRepo2;

    @Value("${module.km.domain}/restful/service/knowledgegraph/")
    private String knowledgeGraphUrl;




    public void monitorRuleHash(DeployTask task){

        if(DeployConstants.DeployType.tenantApp.equalsIgnoreCase(task.getType())){
            if(!Boolean.TRUE.equals(task.getIndividualAll())){return;}
            List<String> oldTenants=  kmPublishRepo2.findUseSourceAppTenants(task.getSourceId(), task.getVersion());
            task.setLastIndividualTenantIds(oldTenants);
            //这一次被删除的
             List<String> individualRemovedTenantIds = new ArrayList<>();
            //这一次新增的
             List<String> individualAddedTenantIds= new ArrayList<>();
            //这一次保留的
             List<String> individualKeepTenantIds= new ArrayList<>();
             for(String tenantId:task.getTenantIds()){
                if(oldTenants.contains(tenantId)){
                    individualKeepTenantIds.add(tenantId);
                }else{
                    individualAddedTenantIds.add(tenantId);
                }
             }
            for(String tenantId:oldTenants){
                if(!task.getTenantIds().contains(tenantId)){
                    individualRemovedTenantIds.add(tenantId);
                }
            }
            task.setIndividualAddedTenantIds(individualAddedTenantIds);
            task.setIndividualKeepTenantIds(individualKeepTenantIds);
            task.setIndividualRemovedTenantIds(individualRemovedTenantIds);
            monitorHash(task,task.getSourceId(),0);
            //如果有新增的租户，该租户的对比对象应该是标准应用，所以这里需要记录标准应用的hash
            if(!individualAddedTenantIds.isEmpty() || !individualRemovedTenantIds.isEmpty()){
                String appSourceId = kmPublishRepo2.appSourceId(task.getAppId());
                if(null!=appSourceId){
                    monitorHash(task,appSourceId,2);
                }
            }
        }else {
            monitorHash(task,task.getSourceId(),0);
        }
    }

    /*insert=true表示对一次部署前插入，false表示部署后再次计算hash
    隐藏问题：
        仅对比了2.0的侦测
        租户范围为从neo4j中取的，这里对租户取消订购应用的情况没有做处理
    */
    public void monitorHash(DeployTask deployReq,String sourceId,int position){
        CrudReq req = new CrudReq();
        req.setDbName(Constant.db_kg_sys);
        req.setColName("applicationRelation");
        req.setParams(new HashMap<>());
        req.getParams().put("version", DEFAULT_VERSION);
        req.getParams().put("sourceId", sourceId);
        req.getParams().put("type", "monitorRule");
        List<Document> applicationRelations = mongoCrudService.query(req);
        if (CollectionUtil.isEmpty(applicationRelations)) {
            return ;
        }
        // 侦测code
        List<String> monitorCodes = applicationRelations.stream().map(e -> MapUtil.getStr(e, "code")).distinct().collect(Collectors.toList());

        /*key=侦测code，value的每个map为侦测本地以及每个产品的信息
        {"monitor001":{"monitorRule":{"code":"monitor001","name":""},"product01":{"monitorRuleId":"","productName":""},"product02":{"monitorRuleId":"","productName":""}}}
         */
        Map<String,Map<String,Map<String,Object>>> monitorMaps = new HashMap<>();

        Map<String, Object> monitorParam = new HashMap<>();
        monitorParam.put("sourceId", sourceId);
        monitorParam.put("version", DEFAULT_VERSION);
        monitorParam.put("code", monitorCodes);
        List<Map<String, Object>> monitorRules = neo4jCrudService.query("MonitorRule", monitorParam);
        Map<String, Map<String, Object>> monitorRuleMap = new HashMap<>();
        //  查询基础定义
        if (CollectionUtil.isNotEmpty(monitorRules)) {
            monitorRuleMap = monitorRules.stream().collect(Collectors.toMap(e -> MapUtil.getStr(e, "code"), e -> e,(a,b)->a));
            monitorRuleMap.forEach((k,v)->{
                // 剔除不需要的字段
                EXCLUDE_FIELDS.forEach(v::remove);
                Map<String, Map<String, Object>> info = new HashMap<>();
                info.put("monitorRule",v);
                monitorMaps.put(k,info);
            });
        }

        // 查询侦测定义--产品级定义
        CrudReq monitorRuleProductConfigReq = new CrudReq();
        monitorRuleProductConfigReq.setDbName(Constant.db_kg_sys);
        monitorRuleProductConfigReq.setColName("monitorRuleProductConfig");
        monitorRuleProductConfigReq.setParams(new HashMap<>());
        monitorRuleProductConfigReq.getParams().put("version", DEFAULT_VERSION);
        monitorRuleProductConfigReq.getParams().put("sourceId", sourceId);
        List<Document> monitorRuleProductConfigs = mongoCrudService.query(monitorRuleProductConfigReq);
        for(Document productDoc:monitorRuleProductConfigs){
            String monitorCode = productDoc.getString("monitorRuleId");
            String productName = productDoc.getString("productName");
            if(null==monitorCode || null==productName){
                continue;
            }
            Map<String, Map<String, Object>> monitorMap = monitorMaps.get(monitorCode);
            if(null==monitorMap){
                continue;
            }
            EXCLUDE_FIELDS.forEach(productDoc::remove);
            monitorMap.put(productName,productDoc);
        }
        List<MonitorHash> last = mongoTemplate.find(Query.query(Criteria.where("deployId").is(deployReq.getDeployId())),MonitorHash.class);
        for (String code : monitorCodes) {
            MonitorHash mh = new MonitorHash();
            for(MonitorHash hash:last){
                    if(code.equals(hash.getMonitorCode())){
                        mh = hash;
                        break;
                    }
            }
            mh.setDeployId(deployReq.getDeployId());
            mh.setMonitorCode(code);
            // 合并侦测定义
            Map<String, Map<String, Object>> map = monitorMaps.get(code);
            if (MapUtil.isNotEmpty(map)) {
                int hash = HashUtil.apHash(JSON.toJSONString(map));
                switch (position){
                    case 0 : mh.setHash0(hash);break;
                    case 1 : mh.setHash1(hash);break;
                    case 2 : mh.setHash2(hash);break;
                }
                Map<String, Object> info = map.get("monitorRule");
                // 即新增的情况如果actionType=workflow 也需要推送到sd
                mh.setActionType(MapUtil.getStr(info, "actionType"));
                mh.setAutoRun(MapUtil.getBool(info,"autoRun"));
                StringBuilder stringBuilder =new StringBuilder();
                map.forEach((k,v)->{
                    if(!"monitorRule".equals(k)){
                        stringBuilder.append(k).append(",");
                    }
                });

                mh.setProductNames(stringBuilder.toString());
            }
            mongoTemplate.save(mh);
        }
    }


    public void checkAndPush(DeployTask task){
        List<MonitorHash> hashs =mongoTemplate.find(Query.query(Criteria.where("deployId").is(task.getDeployId())),MonitorHash.class);
        if(DeployConstants.DeployType.tenantApp.equalsIgnoreCase(task.getType()) || DeployConstants.DeployType.tenantCustom.equalsIgnoreCase(task.getType())){
            //删除的租户
            if(!CollectionUtils.isEmpty(task.getIndividualRemovedTenantIds())){
                for(MonitorHash hash:hashs){
                    if(null!=hash.getHash0() && null==hash.getHash2()){
                        monitorDelete(task.getToken(),hash,task.getIndividualRemovedTenantIds());
                        hash.setAction("delete");
                        hash.setActionTime(new Date());
                        hash.setDesc("Individual delete code="+hash.getMonitorCode()+",tenants="+task.getIndividualRemovedTenantIds());
                        mongoTemplate.save(hash);
                    }
                }
            }
            //新增的租户
            if(!CollectionUtils.isEmpty(task.getIndividualAddedTenantIds())){
                Set<String> updateCodes = new HashSet<>();
                List<String> addedCodes = new ArrayList<>();
                for(MonitorHash hash:hashs){
                    //新增
                    if(null!=hash.getHash1() && null==hash.getHash2()){
                        if("workflow".equalsIgnoreCase(hash.getActionType()) || Boolean.TRUE.equals(hash.getAutoRun())){
                            addedCodes.add(hash.getMonitorCode());
                            hash.setAction("add");
                            hash.setActionTime(new Date());
                            hash.setDesc("Individual add code="+hash.getMonitorCode()+",tenants="+task.getIndividualAddedTenantIds());
                            mongoTemplate.save(hash);
                        }
                        continue;
                    }
                    //修改
                    if(Boolean.TRUE.equals(hash.getShouldPush()) || (null!=hash.getHash1() && !hash.getHash1().equals(hash.getHash2()))){
                        // System.out.println("侦测变动，但推送被禁用:"+hash.getMonitorCode());
                        hash.setAction("modify");
                        hash.setActionTime(new Date());
                        hash.setDesc("Individual modify code="+hash.getMonitorCode()+",tenants="+task.getIndividualAddedTenantIds());
                        mongoTemplate.save(hash);
                        updateCodes.add(hash.getMonitorCode());
                        continue;
                    }
                    //删除
                    if(null==hash.getHash1() && null!=hash.getHash2()){
                        monitorDelete(task.getToken(),hash,task.getIndividualAddedTenantIds());
                        hash.setAction("delete");
                        hash.setActionTime(new Date());
                        hash.setDesc("Individual delete code="+hash.getMonitorCode()+",tenants="+task.getIndividualAddedTenantIds());
                        mongoTemplate.save(hash);
                    }
                }
                monitorAdd(task,addedCodes,task.getIndividualAddedTenantIds());
                monitorModify(task,updateCodes,new HashSet<>(task.getIndividualAddedTenantIds()));
            }
            //保留的租户
            if(!CollectionUtils.isEmpty(task.getIndividualKeepTenantIds())){
                checkAndPush0(hashs,task,new HashSet<>(task.getIndividualKeepTenantIds()));
            }
        }else{
            Set<String> useAppTenants = kmPublishRepo2.findUseAppTenants(task.getAppId(), task.getVersion());
            checkAndPush0(hashs,task,useAppTenants);
        }
    }
    public void checkAndPush0(List<MonitorHash> last,DeployTask deployReq,  Set<String> useAppTenants){
        if(CollectionUtils.isEmpty(useAppTenants)){
            return;
        }
        Set<String> updateCodes = new HashSet<>();
        List<String> addedCodes = new ArrayList<>();
        for(MonitorHash hash: last){
            //不应该有这种情况
            if(null==hash.getHash0() && null==hash.getHash1()){
                continue;
            }
            //新增
            if(null==hash.getHash0()){
                if("workflow".equalsIgnoreCase(hash.getActionType()) || Boolean.TRUE.equals(hash.getAutoRun())){
                    addedCodes.add(hash.getMonitorCode());
                    hash.setAction("add");
                    hash.setActionTime(new Date());
                    mongoTemplate.save(hash);
                }
                continue;
            }
            //删除
            if(null==hash.getHash1()){
                monitorDelete(deployReq.getToken(),hash,useAppTenants);
                hash.setAction("delete");
                hash.setActionTime(new Date());
                mongoTemplate.save(hash);
                continue;
            }
            //修改 暂时屏蔽，存在租户级调整数据后出现不一致问题
            if(Boolean.TRUE.equals(hash.getShouldPush()) || !hash.getHash0().equals(hash.getHash1())){
               // System.out.println("侦测变动，但推送被禁用:"+hash.getMonitorCode());
                hash.setAction("modify");
                hash.setActionTime(new Date());
                mongoTemplate.save(hash);
                updateCodes.add(hash.getMonitorCode());
                continue;
            }
        }
        if(DeployConstants.DeployType.tenantApp.equalsIgnoreCase(deployReq.getType()) || DeployConstants.DeployType.tenantCustom.equalsIgnoreCase(deployReq.getType())){
            monitorModify(deployReq,updateCodes,useAppTenants);
            monitorAdd(deployReq,addedCodes,useAppTenants);
        }else{
            monitorModify(deployReq,updateCodes,null);
            monitorAdd(deployReq,addedCodes,null);
        }

    }



    private void monitorAdd(DeployTask req,MonitorHash hash,Set<String> useAppTenants){

        String code = hash.getMonitorCode();
        System.out.println("monitorAdd:"+code);
        List<String> products = new ArrayList<>();
        if(null!=hash.getProductNames()){
            products.addAll(Arrays.asList(hash.getProductNames().split(",")));
        }else{
            products.add(req.getAppId());
        }
        for (String tenantId : useAppTenants) {
                Document d = new Document();
                d.put("monitorRuleId", code);
                d.put("tenantId", tenantId);
                d.put("status", 1);
                d.put("configId", RandomUtil.randomStringUpper(33));
                for(String pro : products){
                    d.put("productName", pro);
                    JSONObject paramJson = new JSONObject();
                    paramJson.put("config", d);
                    requestKg("MonitorRuleConfig", paramJson, Method.PUT,req.getToken());
                }
        }
    }

    private void monitorAdd(DeployTask req,List<String> monitorCodes,Collection<String> useAppTenants){
        if(monitorCodes.isEmpty()){return;}
        System.out.println("monitorAdd:"+monitorCodes);
        Map<String,Object> param = new HashMap<>();
        param.put("appCode",req.getAppId());
        param.put("ruleIdList",monitorCodes);
        param.put("tenantIds",useAppTenants);
        JSONObject paramJson = new JSONObject();
        paramJson.put("param", param);
        requestKg("tenant/initMonitorRuleForExistsTenant", paramJson, Method.POST,req.getToken());

    }

    private void monitorDelete(String token, MonitorHash hash,Collection<String> useAppTenants){
        System.out.println("monitorDelete:"+hash.getMonitorCode());
        for (String tenantId : useAppTenants) {
            JSONObject config = new JSONObject();
            config.fluentPut("tenantId", tenantId).fluentPut("monitorRuleId", hash.getMonitorCode());
            JSONObject param = new JSONObject();
            param.put("config", config);
            requestKg("MonitorRuleConfig", param, Method.DELETE, token);
        }
    }

    private void monitorModify(DeployTask req,Set<String> updateCodes,Set<String> useAppTenants){
        if(updateCodes.isEmpty()){return;}
        System.out.println("monitorModify:"+updateCodes);
        JSONObject noticeInfo = new JSONObject();
        noticeInfo.fluentPut("ruleIds", updateCodes)
                .fluentPut("version", req.getVersion())
                .fluentPut("limitedTenantIdList", useAppTenants)
                .fluentPut("excludedTenantIdList", Collections.emptyList())
                .fluentPut("productChangeInfo", Collections.emptyMap());
        JSONObject paramJson = new JSONObject();
        paramJson.put("noticeInfo", noticeInfo);
        requestKg("MonitorRuleConfig/noticeWhenMonitorRuleConfigChange", paramJson, Method.POST,req.getToken());
    }



    public void deleteMonitorRules(String appId, String token){
        if(StringUtils.isEmpty(appId)){return;}
        Set<String> tenants= kmPublishRepo2.findUseAppTenants(appId,null);
        CrudReq req = new CrudReq();
        req.setDbName(Constant.db_kg_sys);
        req.setColName("applicationRelation");
        req.setParams(new HashMap<>());
        req.getParams().put("appCode", appId);
        req.getParams().put("type", "monitorRule");
        List<Document> applicationRelations = mongoCrudService.query(req);
        if (CollectionUtil.isEmpty(applicationRelations)) {
            return ;
        }
        // 侦测code
        List<String> monitorCodes = applicationRelations.stream().map(e -> MapUtil.getStr(e, "code")).distinct().collect(Collectors.toList());

        for(String code:monitorCodes){
            MonitorHash monitorHash = new MonitorHash();
            monitorHash.setMonitorCode(code);
            monitorDelete(token, monitorHash, tenants);
        }

    }





    private void requestKg(String serviceName, JSONObject paramJson, Method method,String token) {
        String url = knowledgeGraphUrl + serviceName;
        try {
            String response = HttpUtil.createRequest(method, url).header("token",token).body(paramJson.toJSONString()).execute().body();
            log.info("请求kg成功:{}", response);
        } catch (Exception e) {
            log.error("请求kg失败:{}", e.getMessage());
        }

    }
}
