package com.digiwin.athena.km_deployer_service.service.dmc.impl;

import cn.hutool.core.io.FileUtil;
import com.digiwin.athena.km_deployer_service.config.dmc.DMCConfig;
import com.digiwin.athena.km_deployer_service.domain.dmc.FileInfo;
import com.digiwin.athena.km_deployer_service.domain.dmc.MidWareResponse;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.CacheService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
//import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName DmcServiceImpl
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/27 10:02
 * @Version 1.0
 **/
@Service
@Slf4j
public class DmcServiceImpl implements DmcService {

    @Autowired
    @Qualifier("dmcRestTemplate")
    RestTemplate dmcRestTemplate;

    @Autowired
    private DMCConfig dmcConfig;

    @Autowired
    private CacheService cacheService;


    @Override
    public String refreshToken() {
        String appToken = dmcConfig.getAppToken();
        String dmcUrl = dmcConfig.getUrl();
        String url = dmcUrl + "/api/dmc/v1/auth/login";

        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.APPLICATION_JSON);
        header.set("digi-middleware-auth-app", appToken);

        Map<String, String> reqMap = new HashMap<>();
        reqMap.put("username", dmcConfig.getUserName());
        reqMap.put("pwdhash", dmcConfig.getPassword());

        HttpEntity<MultiValueMap<String, String>> httpEntity = new HttpEntity(reqMap, header);
        ResponseEntity<Map> resMap = dmcRestTemplate.postForEntity(url, httpEntity, Map.class);
        System.out.println(resMap.getBody());
        String token = (String) resMap.getBody().get("userToken");
        if (StringUtils.isEmpty(token)) {
            throw new BusinessException("Failed to obtain token");
        }
        cacheService.set("dmcToken", token, 3600L);

        return token;
    }

    public String getToken() {
        String token = cacheService.get("dmcToken");
        if (null == token) {
            token = refreshToken();
        }
        return token;
    }

    @Override
    public String upload(File file, String contentType, FileInfo fileInfo) {
        String appToken = dmcConfig.getAppToken();
        String dmcUrl = dmcConfig.getUrl();

        MultiValueMap<String, Object> multiValueMap = new LinkedMultiValueMap<>();
        HttpHeaders header = new HttpHeaders();
        header.setContentType(MediaType.MULTIPART_FORM_DATA);
        header.add("digi-middleware-auth-user", getToken());
        header.add("digi-middleware-auth-app", appToken);

        HttpHeaders fileHeader = new HttpHeaders();
        fileHeader.setContentType(MediaType.parseMediaType(contentType));
        fileHeader.setContentDispositionFormData("file", file.getName());

        HttpHeaders fileInfoHeader = new HttpHeaders();
        fileInfoHeader.setContentType(MediaType.APPLICATION_JSON);

        try {
            HttpEntity<ByteArrayResource> fileEntity = new HttpEntity<>(new ByteArrayResource(FileUtil.readBytes(file)),
                    fileHeader);
            HttpEntity<FileInfo> fileInfoEntity = new HttpEntity<>(fileInfo, fileInfoHeader);
            multiValueMap.add("file", fileEntity);
            multiValueMap.add("fileInfo", fileInfoEntity);

            String url = dmcUrl + "/api/dmc/v2/file/Athena/upload";

            HttpEntity<MultiValueMap<String, Object>> httpEntity = new HttpEntity<>(multiValueMap, header);
            ResponseEntity<MidWareResponse> postForEntity = dmcRestTemplate.postForEntity(url, httpEntity, MidWareResponse.class);
            MidWareResponse<Map> midWareResponse = postForEntity.getBody();
            if (midWareResponse.getSuccess()) {
                return (String) midWareResponse.getData().get("id");
            } else {
                log.error("调用上传api失败");
                throw new BusinessException("Failed to call the upload API");
            }
        } catch (Exception e) {
            log.error("", e);
            throw new BusinessException("", e);
        }

    }

    @Override
    public InputStream download(String fileId) {
        String token = getToken();
        String dmcUrl = dmcConfig.getUrl();
        String appToken = dmcConfig.getAppToken();

        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("digi-middleware-auth-app", appToken);

        String url = dmcUrl + "/api/dmc/v2/file/" + dmcConfig.getBucket() + "/download/" + fileId;
        ResponseEntity<byte[]> restRes = dmcRestTemplate.exchange(
                url,
                HttpMethod.GET,
                new HttpEntity<byte[]>(headers),
                byte[].class);
        return new ByteArrayInputStream(restRes.getBody());
    }

    @Override
    public InputStream downloadByUrl(String shareUrl) {
        HttpHeaders headers = new HttpHeaders();
        ResponseEntity<byte[]> restRes = dmcRestTemplate.exchange(
                shareUrl,
                HttpMethod.GET,
                new HttpEntity<byte[]>(headers),
                byte[].class);

        return new ByteArrayInputStream(restRes.getBody());

    }
}
