package com.digiwin.athena.km_deployer_service.service.km;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

@Service
public class CacheService {

    @Autowired
    StringRedisTemplate stringRedisTemplate;


    public void set(String key,String value,Long exp){
        String ckey = Constant.namespace+key;
        stringRedisTemplate.opsForValue().set(ckey,value);
        stringRedisTemplate.expire(ckey,exp, TimeUnit.SECONDS);
    }

    public String get(String key){
        String ckey = Constant.namespace+key;
        return stringRedisTemplate.opsForValue().get(ckey);
    }

    /**
     * Object转成JSON数据
     */
    public String toJson(Object object) {
        if (object instanceof Integer || object instanceof Long || object instanceof Float ||
                object instanceof Double || object instanceof Boolean || object instanceof String) {
            return String.valueOf(object);
        }
        return JSON.toJSONString(object);
    }

    public <T> T get(String partition, String key, Class<T> clazz) {
        key = partition + ":" + key;
        return get(key, clazz);
    }

    public <T> T get(String key, Class<T> clazz) {
        Object obj = stringRedisTemplate.opsForValue().get(key);
        return obj == null ? null : fromJson(String.valueOf(obj), clazz);
    }

    public void set(String partition, String key, Object value) {
        key = partition + ":" + key;
        set(key, value, 0);
    }

    public void set(String key, Object value, long expire) {
        if (expire > 0) {
            stringRedisTemplate.opsForValue().set(key, toJson(value), expire);
        } else {
            stringRedisTemplate.opsForValue().set(key, toJson(value));
        }
    }

    public void delete(String partition, String key) {
        //删除单个key
        key = partition + ":" + key;
        delete(key);
    }

    public void delete(String key) {
        //删除单个key
        stringRedisTemplate.delete(key);
    }

    /**
     * JSON数据，转成Object
     */
    private <T> T fromJson(String json, Class<T> clazz) {
        return JSON.parseObject(json, clazz);
    }

}
