package com.digiwin.athena.km_deployer_service.service.km;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.domain.TenantUser;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.km_deployer_service.domain.system.TenantUserResult;
import com.digiwin.athena.km_deployer_service.util.Neo4jMultipleUtil;


import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author yueyyc
 * @version 1.0
 * @date 2022/10/24 9:56
 */
public interface TenantService {

    JSONObject queryUserTenants(String tenantId);

    TenantUserResult queryUserInTenant(String tenantId, String token, Integer pageSize, Integer pageNum);

    List<JSONObject> queryAllUserInTenant(String tenantId, String token);

    boolean currentUserExistInTenant(String userId, String tenantId, String token);

    void createTenants(List<String> tenantIds, String version);

    void createOrUpdateTenants(List<String> tenantIds, String version);

    void createTenantAndApplicationRelation(String application, String tenantVersion, String appVersion, List<String> tenantIds);

    // 创建所有跟应用有关联的指定版本的租户和应用数据的关系
    void createAllAuthTenantAndApplicationRelation(String application, String tenantVersion, String appVersion);

    void createTenantAndCommonRelation(List<String> tenantIds, String version);

    List<Cql> createAllTenantAndCommonRelation(String version);

    // 获取指定版本租户和对应版本common和espCommon的关系的Cql
    List<Cql> getSpecificTenantAndCommonAndEspRelationCql(String tenantId, String version);

    // 获取指定版本租户和对应版本espCommon/espAction的关系的Cql
    Cql getSpecificTenantAndEspActionRelationCql(String tenantId, String version);

    List<String> getAuthAppTenantIdList(String application, String version, List<String> excludeTenants);

    void createRelation(String application, String tenantVersion, String appVersion, List<String> tenantIds);

    // 获取租户和应用数据关联的cql语句，考虑流程引擎
    List<Cql> getMergeTenantAndAppDataRelationCql(String application, String tenantVersion, String appVersion, List<String> authAppTenantIdList);

    String analyzeIamToken(String token);

    JSONObject getTenantInfoByToken(String token);

    // 获取环境下所有租户节点的tenantId
    Set<String> getAllTenants(String version);

    /**
     * 获取租户当前版本
     *
     * @param tenantIdList 租户list
     * @return
     */
    Map<String, String> getTenantVersion(List<String> tenantIdList);

    // 获取appEntity的fullNamespace属性
    Set<String> getAppEntityFullNamespace(Set<String> appCode);

    // 处理发版/切版时租户和common/espCommon的关系
    List<Cql> mergeRelationBetweenTenantAndCommon(String application, List<String> tenantIdList, String targetVersion, Map<String, String> tenantVersionMap);

    // 修改切版时租户和应用数据不匹配的情况
    void modifyTenantRelaWithNotMatchAppDataInSwitch(String application, List<String> tenantIdList);

    // 删除指定版本租户和指定版本应用数据的关系
    List<Cql> deleteRelationBetweenAppAndTenant(String application, String tenantVersion, String appVersion, List<String> authAppTenantIdList);

    // 修改发版时租户和应用数据不匹配的情况
    void modifyTenantRelaWithNotMatchAppDataInPublish(String tenantVersion, String appVersion, List<String> tenantIdList);

    //更新tenantConfig数据（租户版本更新为n.0，这边mongo表数据version要改成n.x）
    void modifyTenantConfig(String version, List<String> tenantIdList);

    String grantUserAuth(TenantUser tenantUser, String application, String strategyCode, String token);

    String getRealTimeTenantToken(String tenantId);

    void updateTenantVersion(List<String> tenantIdList, String application, String deployVersion);

    Set<String> getNotCommonAppCodeRelaToTenantId(String tenantId);

    void createOneTenantAndMoreAppRelation(Set<String> appCodeList, String tenantVersion, String appVersion, String tenantId);

    void updateAppDataVersion(String application, String oldVersion, String newVersion, List<String> tenantIdList);

    void copyAppVersionData(String application, String oldVersion, String newVersion);

}
