package com.digiwin.athena.km_deployer_service.service.km.handler;

import com.digiwin.athena.km_deployer_service.domain.km.KmEventParam;

/**
 * @Author QinQiang
 * @Description
 * @Date 2024/1/19
 **/
public interface KmDeployEventHandler {

    /**
     * 处理的组件类型
     *
     * @return 组件类型
     */
    String handlerComponentType();

    /**
     * 发版前事件处理
     *
     * @param param 事件参数
     */
    void handleBeforePublish(KmEventParam param);

    /**
     * 发版后事件处理
     *
     * @param param 事件参数
     */
    void handleAfterPublish(KmEventParam param);

    /**
     * 切版前事件处理
     *
     * @param param 事件参数
     */
    void handleBeforeSwitch(KmEventParam param);

    /**
     * 切版后事件处理
     *
     * @param param 事件参数
     */
    void handleAfterSwitch(KmEventParam param);
}
