package com.digiwin.athena.km_deployer_service.service.km.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.deploy.DeployConstants;
import com.digiwin.athena.km_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.km_deployer_service.povo.ApiDataFieldMetadataDTO;
import com.digiwin.athena.km_deployer_service.povo.EspActionIdSwitchResDto;
import com.digiwin.athena.km_deployer_service.povo.EspSwitchMsgEnum;
import com.digiwin.athena.km_deployer_service.service.km.ActionService;
import com.digiwin.athena.km_deployer_service.service.km.ApplicationService;
import com.digiwin.athena.km_deployer_service.util.Neo4jMultipleUtil;
import io.netty.util.internal.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.text.StringEscapeUtils;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.InternalNode;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * <Description> <br>
 *
 * @author wang.xinyuan<br>
 * @version 1.0<br>
 * @CreateDate 2023/7/26 <br>
 */
@Service
@Slf4j
public class ActionServiceImpl implements ActionService {

    @Autowired
    private Driver driver1;
    @Autowired(required = false)
    @Qualifier("domain2Driver")
    private Driver driver2;
    @Autowired
    private ApplicationService applicationService;

    @Override
    public void updateEspActionEnumKey(Map<String, List<String>> espActionEnumKey) {
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        for (Map.Entry<String, List<String>> entry : espActionEnumKey.entrySet()) {
            executorService.submit(() -> updateEspDictionaryKey(entry.getKey(), entry.getValue()));
//            UpdateEspDictionaryKey(entry.getKey(), entry.getValue());
        }
        executorService.shutdown();
    }

    @Override
    public void incrementSwitchEspAction(String id) {
        // 举例：
        // 查询同一个actionId，version1.0存在但是2.0不存在的数据：MATCH (a1:EspAction) WHERE a1.version = '1.0' AND NOT (:EspAction {actionId: a1.actionId, version: '2.0'})-[:NEXT]->(a1) RETURN a1
        // 查询同一个actionId，version1.0的节点的updateTime时间比2.0更新，或者version1.0存在updateTime属性但是2.0数据不存在这个属性的数据：MATCH (n:EspAction{version:'1.0'}) MATCH (m:EspAction{version:'2.0'}) where n.actionId = m.actionId and ((n.updateTime>m.updateTime) or (n.updateTime is not null and m.updateTime is null)) return n
        Neo4jManager neo4jManager1 = new Neo4jManager(driver1);
        List<Map<String, Object>> testAction = neo4jManager1.ExecuteQuery("MATCH (n:EspAction) WHERE n.version = '1.0' RETURN n.actionId as actionId", new HashMap<>());
        List<Map<String, Object>> prodAction = neo4jManager1.ExecuteQuery("MATCH (n:EspAction) WHERE n.version = '2.0' RETURN n.actionId as actionId", new HashMap<>());
        List<String> testActionIdList = new ArrayList<>();
        if (CollUtil.isNotEmpty(testAction)) {
            testAction.forEach(ta -> testActionIdList.add(String.valueOf(ta.get("actionId"))));
        }
        List<String> prodActionIdList = new ArrayList<>();
        if (CollUtil.isNotEmpty(prodAction)) {
            prodAction.forEach(ta -> prodActionIdList.add(String.valueOf(ta.get("actionId"))));
        }
        // 1.0版本的数据去除2.0版本的数据，剩余都是需要新增的数据
        testActionIdList.removeAll(prodActionIdList);
        Map<String, Object> params = new HashMap<>();
        params.put("actionIdList", testActionIdList);
        List<Map<String, Object>> needCreateNodes = neo4jManager1.ExecuteQuery("MATCH (node:EspAction) WHERE node.actionId in $actionIdList RETURN node", params);
        List<Map<String, Object>> needUpdateNodes = neo4jManager1.ExecuteQuery("MATCH (node:EspAction{version:'1.0'}) MATCH (m:EspAction{version:'2.0'}) where node.actionId = m.actionId and ((node.updateTime>m.updateTime) or (node.updateTime is not null and m.updateTime is null)) return node", new HashMap<>());

        List<Cql> executeCqlList = new ArrayList<>();
        // 新建节点并关联关系的Cql
        for (Map<String, Object> nodeResult : needCreateNodes) {
            StringBuffer nodeCypher = new StringBuffer("create (node");
            Collection<String> labels = ((InternalNode) nodeResult.get("node")).labels();
            for (String label : labels) {
                nodeCypher.append(String.format(":%s", label));
            }
            nodeCypher.append("{");
            Map<String, Object> properties = ((InternalNode) nodeResult.get("node")).asMap();
            String actionId = ObjectUtils.isEmpty(properties.get("actionId")) ? "" : (String) properties.get("actionId");
            // 取到属性组装cql
            applicationService.combineNodeProperties(properties, nodeCypher);
            nodeCypher.append(String.format("version:'2.0', switchTime:'%s'}) return id(node) as nodeId", DateUtil.now()));
            executeCqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava(nodeCypher.toString())));
        }
        // 创建所有2.0租户和新增的2.0的espAction之间的关系
//        Map<String, Object> param = new HashMap<>();
//        param.put("actionIdList", testActionIdList);
//        param.put("addTime", DateUtil.now());
//        param.put("deployId", id);
//        String createRelationCql = "match(n:TenantEntity{version:'2.0'}) match(m:EspAction{version:'2.0'}) where m.actionId in $actionIdList merge (n)-[:ACTION]->(m)";
//        String createRelationCql2 = "match(n:TenantEntity{version:'2.0'})-[r]->(m:EspAction{version:'2.0'}) where m.actionId in $actionIdList set r.addTime=$addTime, r.deployId=$deployId";
//        executeCqlList.add(new Cql().setCql(createRelationCql).setParams(param));
//        executeCqlList.add(new Cql().setCql(createRelationCql2).setParams(param));
        // 更新节点数据的Cql
        for (Map<String, Object> nodeResult : needUpdateNodes) {
            Map<String, Object> properties = ((InternalNode) nodeResult.get("node")).asMap();
            String actionId = ObjectUtils.isEmpty(properties.get("actionId")) ? "" : (String) properties.get("actionId");

            StringBuffer nodeCypher = new StringBuffer("match (node");
            Collection<String> labels = ((InternalNode) nodeResult.get("node")).labels();
            for (String label : labels) {
                nodeCypher.append(String.format(":%s", label));
            }
            nodeCypher.append("{actionId:'").append(actionId).append("', version:'2.0'}) set ");
            properties.forEach((k, v) -> {
                if (!"version".equals(k) && !"actionId".equals(k)) {
                    if (k.contains(".")) {
                        nodeCypher.append("node.").append(String.format("`%s`", k));
                    } else {
                        nodeCypher.append("node.").append(String.format("%s", k));
                    }
                    if (v instanceof String) {
                        String propertyValue = (String) v;
                        propertyValue = propertyValue.replace("'", "\\\"");
                        nodeCypher.append("=").append(String.format("'%s',", propertyValue));
                    } else if (v instanceof Collection) {
                        nodeCypher.append("=[");
                        List propertyValueList = (List) v;
                        propertyValueList.forEach(propertyValue -> {
                            if (propertyValue instanceof String) {
                                nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                            } else {
                                nodeCypher.append(propertyValue).append(",");
                            }
                        });
                        if (!propertyValueList.isEmpty()) {
                            nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                        }
                        nodeCypher.append("],");
                    } else {
                        nodeCypher.append("=").append(v).append(",");
                    }
                }
            });
            nodeCypher.append(String.format("node.switchTime='%s' return node", DateUtil.now()));
            executeCqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava(nodeCypher.toString())));
        }
        // 一起执行上述Cql
        Neo4jMultipleUtil.executeCqlTrans(executeCqlList, driver1, driver2);
    }

    @Override
    public EspActionIdSwitchResDto assignSwitchEspAction(String id, String actionId, List<String> createdActionIdList){
        Neo4jManager neo4jManager1 = new Neo4jManager(driver1);
        Map<String, Object> param = new HashMap<>();
        param.put("actionId",actionId);
        List<Map<String, Object>> testAction = neo4jManager1.ExecuteQuery("MATCH (n:EspAction) WHERE n.version = '1.0' and n.actionId=$actionId RETURN n.actionId as actionId", param);
        List<Map<String, Object>> prodAction = neo4jManager1.ExecuteQuery("MATCH (n:EspAction) WHERE n.version = '2.0' and n.actionId=$actionId RETURN n.actionId as actionId", param);

        List<String> testActionIdList = new ArrayList<>();
        List<String> prodActionIdList = new ArrayList<>();

        if (CollUtil.isEmpty(testAction)){
            return new EspActionIdSwitchResDto(EspSwitchMsgEnum.UPDATE_FAIL.getType(),EspSwitchMsgEnum.UPDATE_FAIL.formatMsg(actionId,"未查到1.0版本的数据"));
        }
        testAction.forEach(ta -> testActionIdList.add(String.valueOf(ta.get("actionId"))));

        if (CollUtil.isNotEmpty(prodAction)) {
            prodAction.forEach(ta -> prodActionIdList.add(String.valueOf(ta.get("actionId"))));
        }

        List<Cql> executeCqlList = new ArrayList<>();
        if (prodActionIdList.size() > 0) {
            List<Map<String, Object>> needUpdateNodes = neo4jManager1.ExecuteQuery("MATCH (node:EspAction{version:'1.0'}) MATCH (m:EspAction{version:'2.0'})" +
                    " where node.actionId = m.actionId and m.actionId = $actionId and ((node.updateTime>m.updateTime) or (node.updateTime is not null and m.updateTime is null)) return node", param);
            if (needUpdateNodes.isEmpty()) {
                return new EspActionIdSwitchResDto(EspSwitchMsgEnum.NOT_NEED_UPDATE.getType(), EspSwitchMsgEnum.NOT_NEED_UPDATE.formatMsg(actionId, "1.0和2.0数据更新时间相同"));
            }

            for (Map<String, Object> nodeResult : needUpdateNodes) {
                StringBuffer nodeCypher = buildUpdateNodeStatement(nodeResult);
                executeCqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava(nodeCypher.toString())));
            }
            Neo4jMultipleUtil.executeCqlTrans(executeCqlList, driver1, driver2);
        } else {
            List<Map<String, Object>> needCreateNodes = neo4jManager1.ExecuteQuery("MATCH (node:EspAction) WHERE node.version='1.0' and node.actionId = $actionId RETURN node", param);

            for (Map<String, Object> nodeResult : needCreateNodes) {
                StringBuffer nodeCypher = buildCreateNodeStatement(nodeResult);
                executeCqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava(nodeCypher.toString())));
            }
            Neo4jMultipleUtil.executeCqlTrans(executeCqlList, driver1, driver2);
            createdActionIdList.add(actionId);

        }
        return new EspActionIdSwitchResDto(EspSwitchMsgEnum.UPDATE_SUCCESS.getType(), EspSwitchMsgEnum.UPDATE_SUCCESS.formatMsg(actionId, StringUtil.EMPTY_STRING));
    }

    @Override
    public void createEspActionRelaWithVirtualTenant() {

    }

    private StringBuffer buildUpdateNodeStatement(Map<String, Object> nodeResult) {
        Map<String, Object> properties = ((InternalNode) nodeResult.get("node")).asMap();
        String actionId = ObjectUtils.isEmpty(properties.get("actionId")) ? "" : (String) properties.get("actionId");

        StringBuffer nodeCypher = new StringBuffer("match (node");
        Collection<String> labels = ((InternalNode) nodeResult.get("node")).labels();
        for (String label : labels) {
            nodeCypher.append(String.format(":%s", label));
        }
        nodeCypher.append("{actionId:'").append(actionId).append("', version:'2.0'}) set ");
        properties.forEach((k, v) -> {
            if (!"version".equals(k) && !"actionId".equals(k)) {
                if (k.contains(".")) {
                    nodeCypher.append("node.").append(String.format("`%s`", k));
                } else {
                    nodeCypher.append("node.").append(String.format("%s", k));
                }
                if (v instanceof String) {
                    String propertyValue = (String) v;
                    propertyValue = propertyValue.replace("'", "\\\"");
                    nodeCypher.append("=").append(String.format("'%s',", propertyValue));
                } else if (v instanceof Collection) {
                    nodeCypher.append("=[");
                    List propertyValueList = (List) v;
                    propertyValueList.forEach(propertyValue -> {
                        if (propertyValue instanceof String) {
                            nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                        } else {
                            nodeCypher.append(propertyValue).append(",");
                        }
                    });
                    if (!propertyValueList.isEmpty()) {
                        nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                    }
                    nodeCypher.append("],");
                } else {
                    nodeCypher.append("=").append(v).append(",");
                }
            }
        });
        nodeCypher.append(String.format("node.switchTime='%s' return node", DateUtil.now()));
        return nodeCypher;
    }

    private StringBuffer buildCreateNodeStatement(Map<String, Object> nodeResult) {
        StringBuffer nodeCypher = new StringBuffer("create (node");
        Collection<String> labels = ((InternalNode) nodeResult.get("node")).labels();
        for (String label : labels) {
            nodeCypher.append(String.format(":%s", label));
        }
        nodeCypher.append("{");
        Map<String, Object> properties = ((InternalNode) nodeResult.get("node")).asMap();
        String actionId = ObjectUtils.isEmpty(properties.get("actionId")) ? "" : (String) properties.get("actionId");
        // 取到属性组装cql
        applicationService.combineNodeProperties(properties, nodeCypher);
        nodeCypher.append(String.format("version:'2.0', switchTime:'%s'}) return id(node) as nodeId", DateUtil.now()));
        return nodeCypher;
    }

    public void updateEspDictionaryKey(String actionId, List<String> actionEnumKey) {
        // actionEnumKey关系形式：入参/出参___fullPath___字段id___枚举key
        Neo4jManager neo4jManager = new Neo4jManager(driver1);
        Map<String, Object> upAppParams = new HashMap<>();
        upAppParams.put("actionId", actionId);
        upAppParams.put("version", "1.0");
        List<Map<String, Object>> executeQuery = neo4jManager.ExecuteQuery("match(n:EspAction) where n.actionId=$actionId and n.version=$version return n.request_parameters as request_parameters,n.response_object as response_object", upAppParams);
        if (executeQuery.size() > 0) {
            Object request_parameters_str = executeQuery.get(0).get("request_parameters");
            List<ApiDataFieldMetadataDTO> request_parameters = JSONArray.parseArray((String) request_parameters_str, ApiDataFieldMetadataDTO.class);
            request_parameters.forEach(request_parameter -> putEnumKey(Constant.ATTR_TYPE_REQUEST, request_parameter.getData_name(), request_parameter, actionEnumKey));
//            String request_str = JSON.toJSONString(request_parameters, SerializerFeature.NotWriteDefaultValue);
            String request_str = JSON.toJSONString(request_parameters);
            Object response_object_str = executeQuery.get(0).get("response_object");
            String response_str = "";
            if (!ObjectUtils.isEmpty(response_object_str)) {
                ApiDataFieldMetadataDTO response_object = JSONObject.parseObject((String) response_object_str, ApiDataFieldMetadataDTO.class);
                putEnumKey(Constant.ATTR_TYPE_RESPONSE, response_object.getData_name(), response_object, actionEnumKey);
//                response_str = JSON.toJSONString(response_object, SerializerFeature.NotWriteDefaultValue);
                response_str = JSON.toJSONString(response_object);
            }
            // 记录当前更新action的时间
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            System.out.println(dateFormat.format(date));

            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Match (action:Action:EspAction {");
            stringBuffer.append("actionId:'");
            stringBuffer.append(actionId);
            stringBuffer.append("'}) set action.request_parameters='");
            stringBuffer.append(request_str);
            stringBuffer.append("', action.response_object='");
            stringBuffer.append(response_str);
            stringBuffer.append("', action.updateTime='");
            stringBuffer.append(dateFormat.format(date));
            stringBuffer.append("'");
            Neo4jMultipleUtil.executeCql(StringEscapeUtils.escapeJava(stringBuffer.toString()), new HashMap<>(), driver1, driver2);
//            neo4jManager.ExecuteNoQuery(StringEscapeUtils.escapeJava(stringBuffer.toString()));
        }
    }

    public void putEnumKey(String type, String fullPath, ApiDataFieldMetadataDTO apiDataFieldMetadataDTO, List<String> actionEnumKey) {
        if ("object".equals(apiDataFieldMetadataDTO.getData_type())) {
            List<ApiDataFieldMetadataDTO> subFieldList = apiDataFieldMetadataDTO.getField();
            for (ApiDataFieldMetadataDTO subField : subFieldList) {
                if ("object".equals(subField.getData_type())) {
                    putEnumKey(type, fullPath + "." + subField.getData_name(), subField, actionEnumKey);
                } else {
                    String path = type + Constant.ACTION_ENUMKEY + fullPath + "." + subField.getData_name() + Constant.ACTION_ENUMKEY + subField.getData_name();
                    subField.setEnum_key(findEnumKey(actionEnumKey, path));
                }
            }
        } else {
            String path = type + Constant.ACTION_ENUMKEY + fullPath + Constant.ACTION_ENUMKEY + apiDataFieldMetadataDTO.getData_name();
            apiDataFieldMetadataDTO.setEnum_key(findEnumKey(actionEnumKey, path));
        }

    }

    private String findEnumKey(List<String> actionEnumKey, String path) {
        String data = actionEnumKey.stream().filter(ae -> ae.contains(path)).findFirst().orElse(null);
        if (StringUtils.isEmpty(data)) {
            return null;
        }
        String[] split = data.split(path + Constant.ACTION_ENUMKEY); // NOSONAR sonar 判断错误，StringUtils.isEmpty(data) 已经处理过 null
        if (split.length > 1) {
            return split[split.length - 1];
        } else {
            return null;
        }
    }
}