package com.digiwin.athena.km_deployer_service.service.km.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.km_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.km_deployer_service.domain.neo4j.*;
import com.digiwin.athena.km_deployer_service.povo.*;
import com.digiwin.athena.km_deployer_service.service.km.CommonDataService;
import com.digiwin.athena.km_deployer_service.service.km.MdcService;
import com.digiwin.athena.km_deployer_service.util.MongoHelper;
import com.digiwin.athena.km_deployer_service.util.Neo4jMultipleUtil;
import com.mongodb.client.model.Filters;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.text.StringEscapeUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.neo4j.driver.Driver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author liyuetao
 * @title: CommonDataServiceImpl
 * @projectName athena_deployer_service
 * @description: TODO
 * @date 2022/11/209:58
 */
@Service
@Slf4j
public class CommonDataServiceImpl implements CommonDataService {

    @Autowired
    private Driver driver1;

    @Autowired(required = false)
    @Qualifier("domain2Driver")
    private Driver driver2;

    @Autowired
    private MongoHelper mongoHelper;
    @Autowired
    private MdcService mdcService;

    /**
     * 　@description: 找出所有非更新的应用指向Common的关系
     * 　@author liyuetao
     * 　@date 2022/11/2 10:25
     */
    @Override
    public List<Relation> findApplication2CommonRelations(Application2CommonRelationParam findApplication2CommonParam) {
        List<String> applicationList = findApplication2CommonParam.getApplicationList();
        String applicationVersion = findApplication2CommonParam.getApplicationVersion();
        String commonVersion = findApplication2CommonParam.getCommonVersion();
        // 获取应用code不在ApplicationList之内的所有neo4j里version是applicationVersion的数据和所有common/espCommon里version是commonVersion数据的节点、属性值及关联关系
        String cql = "match (applicationNode{version:$applicationVersion})-[relation]->(commonNode{version:$commonVersion}) where (not applicationNode.athena_namespace in $applicationList or not applicationNode.nameSpace in $applicationList) and commonNode.nameSpace in ['common','espCommon'] return labels(applicationNode) as applicationNodeLabels,properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(commonNode) as commonNodeLabels,properties(commonNode) as commonNodeProperties";
        Map<String, Object> param = new HashMap<>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("commonVersion", commonVersion);
        return getRelationInCqlResult(cql,param, findApplication2CommonParam.getNeo4jNodeKeyJson(), applicationVersion, commonVersion);
    }

    //todo 和上面总体一样，只不过otherAppNode.nameSpace in $applicationList有区别
    public List<Relation> findApp2OtherAppRelations(Application2CommonRelationParam findApplication2CommonParam) {
        List<String> applicationList = findApplication2CommonParam.getApplicationList();
        String applicationVersion = findApplication2CommonParam.getApplicationVersion();
        String commonVersion = findApplication2CommonParam.getCommonVersion();
        String cql = "match (applicationNode{version:$applicationVersion})-[relation]->(otherAppNode{version:$otherAppVersion}) where " +
                "(not applicationNode.athena_namespace in $applicationList or not applicationNode.nameSpace in $applicationList) and " +
                "otherAppNode.nameSpace in $applicationList return labels(applicationNode) as applicationNodeLabels," +
                "properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(otherAppNode) as commonNodeLabels," +
                "properties(otherAppNode) as commonNodeProperties";
        Map<String, Object> param = new HashMap<>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("otherAppVersion", commonVersion);
        return getRelationInCqlResult(cql,param, findApplication2CommonParam.getNeo4jNodeKeyJson(), applicationVersion, commonVersion);
    }

    public static void main(String[] args) {
        String cql = "match (applicationNode{version:$applicationVersion})-[relation]->(commonNode{version:$commonVersion}) where (not applicationNode.athena_namespace in $applicationList or not applicationNode.nameSpace in $applicationList) and commonNode.nameSpace in ['common','espCommon'] return labels(applicationNode) as applicationNodeLabels,properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(commonNode) as commonNodeLabels,properties(commonNode) as commonNodeProperties";
        String cql2 = "match (applicationNode{version:$applicationVersion})-[relation]->(otherAppNode{version:$otherAppVersion}) where " +
                "(not applicationNode.athena_namespace in $applicationList or not applicationNode.nameSpace in $applicationList) and " +
                "otherAppNode.nameSpace in $applicationList return labels(applicationNode) as applicationNodeLabels," +
                "properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(otherAppNode) as commonNodeLabels," +
                "properties(otherAppNode) as commonNodeProperties";
        System.out.println(cql);
        System.out.println(cql2);

    }

    public List<Relation> findSpecialApp2OtherCommonAppRelations(Application2CommonRelationParam findApplication2CommonParam) {
        List<String> applicationList = findApplication2CommonParam.getApplicationList();
        String applicationVersion = findApplication2CommonParam.getApplicationVersion();
        String commonVersion = findApplication2CommonParam.getCommonVersion();
        // 查询公共类型应用的code
        List<String> commonAppCodeList = getCommonAppCode(true);

        String cql2 = "match (applicationNode{version:$applicationVersion})-[relation]->(otherAppNode{version:$otherAppVersion}) where " +
                "(applicationNode.athena_namespace in $applicationList or applicationNode.nameSpace in $applicationList) and " +
                "otherAppNode.nameSpace in $commonAppCodeList return labels(applicationNode) as applicationNodeLabels," +
                "properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(otherAppNode) as commonNodeLabels," +
                "properties(otherAppNode) as commonNodeProperties";
        Map<String, Object> param = new HashMap<>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("otherAppVersion", commonVersion);
        param.put("commonAppCodeList", commonAppCodeList);
        return getRelationInCqlResult(cql2,param, findApplication2CommonParam.getNeo4jNodeKeyJson(), applicationVersion, commonVersion);
    }

    private List<String> getCommonAppCode(Boolean addEspCommonOrNot){
        String cql1 = "match (m:AppEntity{commonApp:true}) return m.code as code";
        List<Map<String, Object>> commonAppCodeRes = new Neo4jManager(driver1).ExecuteQuery(cql1, new HashMap<>());
        List<String> commonAppCodeList = commonAppCodeRes.stream().map(cac -> String.valueOf(cac.get("code"))).collect(Collectors.toList());
        if(addEspCommonOrNot) {
            commonAppCodeList.add("espCommon");
        }
        return commonAppCodeList;
    }
    @Override
    public List<Relation> findSpecialApplication2CommonRelations(Application2CommonRelationParam findApplication2CommonParam) {
        List<String> applicationList = findApplication2CommonParam.getApplicationList();
        String applicationVersion = findApplication2CommonParam.getApplicationVersion();
        String commonVersion = findApplication2CommonParam.getCommonVersion();
        // 获取指定应用的所有neo4j里version是applicationVersion的数据和所有common/espCommon里version是commonVersion数据的节点、属性值及关联关系
        String cql = "match (applicationNode{version:$applicationVersion})-[relation]->(commonNode{version:$commonVersion}) where (applicationNode.athena_namespace in $applicationList or applicationNode.nameSpace in $applicationList) and commonNode.nameSpace in ['common','espCommon'] return labels(applicationNode) as applicationNodeLabels,properties(applicationNode) as applicationNodeProperties,type(relation) as relationType,labels(commonNode) as commonNodeLabels,properties(commonNode) as commonNodeProperties";
        Map<String, Object> param = new HashMap<>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("commonVersion", commonVersion);
        return getRelationInCqlResult(cql,param, findApplication2CommonParam.getNeo4jNodeKeyJson(), applicationVersion, commonVersion);
    }

    private List<Relation> getRelationInCqlResult(String cql, Map<String, Object> param, JSONObject neo4jNodeKeyJson, String applicationVersion, String commonVersion){
        List<Relation> relations = new ArrayList<>();
        List<Map<String, Object>> queryResult = new Neo4jManager(driver1).ExecuteQuery(cql, param);
        List<Application2CommonRelation> application2CommonRelationList = queryResult.stream().map(map -> JSON.parseObject(JSON.toJSONString(map), Application2CommonRelation.class)).collect(Collectors.toList());
        for (Application2CommonRelation application2CommonRelation : application2CommonRelationList) {
            List<String> applicationNodeLabels = application2CommonRelation.getApplicationNodeLabels();
            JSONObject applicationNodeProperties = application2CommonRelation.getApplicationNodeProperties();
            String relationType = application2CommonRelation.getRelationType();
            List<String> commonNodeLabels = application2CommonRelation.getCommonNodeLabels();
            JSONObject commonNodeProperties = application2CommonRelation.getCommonNodeProperties();

            FromNode fromNode = new FromNode();
            String applicationNodeLabel = applicationNodeLabels.get(0);
            fromNode.setLabel(applicationNodeLabel)
                    .setPrimaryKey(applicationNodeProperties.get(neo4jNodeKeyJson.getString(applicationNodeLabel)))
                    .setApplication(applicationNodeProperties.getString("athena_namespace"))
                    .setVersion(applicationVersion);

            ToNode toNode = new ToNode();
            String commonNodeLabel = commonNodeLabels.get(0);
            toNode.setType(relationType)
                    .setLabel(commonNodeLabel)
                    .setApplication(commonNodeProperties.getString("athena_namespace"))
                    .setPrimaryKey(commonNodeProperties.get(neo4jNodeKeyJson.getString(commonNodeLabel)))
                    .setVersion(commonVersion);
            Relation relation = new Relation().setFromNode(fromNode).setToNode(toNode);
            relations.add(relation);
        }
        return relations;
    }

    @Override
    public void updateVersion(UpdateVersionParam updateVersionParam) {
        List<Cql> cqlList = getUpdateCommonDataVersionCql(updateVersionParam);
        Neo4jMultipleUtil.executeCqlTrans(cqlList, driver1, driver2);
    }

    @Override
    public List<Cql> getUpdateVersionCqlList(UpdateVersionParam updateVersionParam) {
        List<Cql> cqlList = getUpdateCommonDataVersionCql(updateVersionParam);
        return cqlList;
    }

    private List<Cql> getUpdateCommonDataVersionCql(UpdateVersionParam updateVersionParam) {
        String oldVersion = updateVersionParam.getOldVersion();
        String newVersion = updateVersionParam.getNewVersion();
        List<String> applicationList = updateVersionParam.getApplicationList();
        List<JSONObject> publishDbMongoData = updateVersionParam.getPublishDbMongoData();

        //更新Mongo数据version,先删除新版本数据，再将旧版本数据的version更新成新版本
        List<String> upperCaseApplicationList = applicationList.stream().map(application -> application.toUpperCase()).collect(Collectors.toList());
        Bson filter = Filters.and(Filters.eq("version", oldVersion), Filters.in("application", upperCaseApplicationList));
        Bson deleteFilter = Filters.and(Filters.eq("version", newVersion), Filters.in("application", upperCaseApplicationList));
        Bson update = new Document("$set", new Document().append("version", newVersion));
        mongoHelper.deleteAndUpdate(publishDbMongoData, filter, deleteFilter, update);

        //更新neo4j数据version,先删除新版本数据，再将旧版本数据的version更新成新版本
        List<Cql> cqlList = new ArrayList<>();

        HashMap<String, Object> param = new HashMap<>();
        param.put("oldVersion", oldVersion);
        param.put("newVersion", newVersion);
        param.put("applicationList", applicationList);
        Cql updateCql = new Cql();
        updateCql.setCql("match (node) where node.version = $oldVersion and node.nameSpace in $applicationList set node.version=$newVersion");
        updateCql.setParams(param);

        Cql deleteCql = new Cql();
        deleteCql.setCql("match (node) where node.version = $newVersion and node.nameSpace in $applicationList detach delete node");
        deleteCql.setParams(param);

        cqlList.add(deleteCql);
        cqlList.add(updateCql);
        return cqlList;
    }

    @Override
    public void deleteApplication2CommonRelations(Application2CommonRelationParam application2CommonRelationParam) {
        List<Cql> executeCqlList = new ArrayList<>();
        List<String> applicationList = application2CommonRelationParam.getApplicationList();
        String applicationVersion = application2CommonRelationParam.getApplicationVersion();
        String commonVersion = application2CommonRelationParam.getCommonVersion();
        List<String> tenantIdList = application2CommonRelationParam.getTenantIdList();
        String cql1 = "match (applicationNode{version:$applicationVersion})-[relation]->(commonNode{version:$commonVersion}) where (not applicationNode.athena_namespace in $applicationList or not applicationNode.nameSpace in $applicationList) and commonNode.nameSpace in ['common','espCommon'] delete relation";
//        String cql2 = "match (tenant:TenantEntity{version:$applicationVersion})-[relation]->(commonNode{version:$commonVersion}) where not tenant.tenantId in $tenantIdList and commonNode.nameSpace in ['common','espCommon'] delete relation";
        Map<String, Object> param = new HashMap<>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("commonVersion", commonVersion);
        param.put("tenantIdList", tenantIdList);
        executeCqlList.add(new Cql().setCql(cql1).setParams(param));
//        executeCqlList.add(new Cql().setCql(cql2).setParams(param));
        Neo4jMultipleUtil.executeCqlTrans(executeCqlList, driver1, driver2);
    }

    @Override
    public void deleteSpecialApplication2CommonRelations(Application2CommonRelationParam application2CommonRelationParam) {
        List<Cql> executeCqlList = new ArrayList<>();
        List<String> applicationList = application2CommonRelationParam.getApplicationList();
        String applicationVersion = application2CommonRelationParam.getApplicationVersion();
        String commonVersion = application2CommonRelationParam.getCommonVersion();
        List<String> tenantIdList = application2CommonRelationParam.getTenantIdList();
        String cql1 = "match (applicationNode{version:$applicationVersion})-[relation]->(commonNode{version:$commonVersion}) where (applicationNode.athena_namespace in $applicationList or applicationNode.nameSpace in $applicationList) and commonNode.nameSpace in ['common','espCommon'] delete relation";
        Map<String, Object> param = new HashMap<>();
        param.put("applicationList", applicationList);
        param.put("applicationVersion", applicationVersion);
        param.put("commonVersion", commonVersion);
        param.put("tenantIdList", tenantIdList);
        executeCqlList.add(new Cql().setCql(cql1).setParams(param));
        Neo4jMultipleUtil.executeCqlTrans(executeCqlList, driver1, driver2);
    }

    @Override
    public void syncEspMetaData(String deployVersion) {
        // 查询esp里的api数据
        List<ApiInfoDTO> espApiList = mdcService.getEspApiList();
        espApiList.forEach(espApi -> {
            String apiName = espApi.getName();
            String espApiLastUpdateTime = espApi.getLast_update_time();
            HashMap<String, Object> param = new HashMap<>();
            param.put("deployVersion", deployVersion);
            param.put("apiName", apiName);
            List<Map<String, Object>> queryResult = new Neo4jManager(driver1).ExecuteQuery("match (action:EspAction{version:$deployVersion}) where action.tenantId is null and action.serviceName=$apiName return action.request_parameters as request_parameters,action.response_object as response_object,action.lastUpdateTime as lastUpdateTime", param);
            if (!ObjectUtils.isEmpty(queryResult)) {
                Object lastUpdateTime = queryResult.get(0).get("lastUpdateTime");
                if (espApi.getLast_update_time().equals(lastUpdateTime))
                    return;
            }
            ApiMetadataDataDTO espApiMetadata = mdcService.getEspApiMetadata(apiName);
            if (espApiMetadata == null)
                return;
            String apiVersion = espApiMetadata.getApi_version();
            String remark_cn = espApiMetadata.getRemark().getZh_CN();
            String remark_tw = espApiMetadata.getRemark().getZh_TW();
            String desc_cn = espApiMetadata.getDescription().getZh_CN();
            String desc_tw = espApiMetadata.getDescription().getZh_TW();
            String url = espApiMetadata.getUrl() == null ? "" : espApiMetadata.getUrl();
            String invokeType = espApiMetadata.getType();
            boolean idempotency = espApiMetadata.getIdempotency();
            String actionId = "esp_" + apiName;
            ApiDataMetadataDTO dataMetadata = espApiMetadata.getData_metadata();
            List<ApiDataFieldMetadataDTO> fieldsOfParameter = new ArrayList<>();
            if (dataMetadata.getRequest().getBody().getField() != null && dataMetadata.getRequest().getBody().getField().get(0).getField() != null) {
                fieldsOfParameter = dataMetadata.getRequest().getBody().getField().get(0).getField();
            }
            List<ApiDataFieldMetadataDTO> fieldRequestObjects = new ArrayList<>();
            for (ApiDataFieldMetadataDTO fieldOfParameter : fieldsOfParameter) {
                if (!fieldOfParameter.getData_name().equals("enterprise_no")
                        && !fieldOfParameter.getData_name().equals("site_no")
                        && !fieldOfParameter.getData_name().equals("call_id")) {
                    fieldRequestObjects.add(fieldOfParameter);
                }
            }
            //TODO 暂时从库里已有的EnumKey同步
            if (!ObjectUtils.isEmpty(queryResult)) {
                List<ApiDataFieldMetadataDTO> request_parameters = JSONArray.parseArray(String.valueOf(queryResult.get(0).get("request_parameters")), ApiDataFieldMetadataDTO.class);
                putEnumKey(fieldRequestObjects, request_parameters);
            }

            String request_str = JSON.toJSONString(fieldRequestObjects, SerializerFeature.NotWriteDefaultValue);
            List<ApiDataFieldMetadataDTO> fieldsOfResponse = dataMetadata.getResponse_success().getBody().getField();
            ApiDataFieldMetadataDTO fieldReponseObject = null;
            for (ApiDataFieldMetadataDTO fieldOfResponse : fieldsOfResponse) {
                if (fieldOfResponse.getData_name().equals("parameter")) {
                    fieldReponseObject = fieldOfResponse;
                    break;
                }
            }
            String response_str = "";
            if (fieldReponseObject != null && fieldReponseObject.getField().size() > 0) {
                Optional<ApiDataFieldMetadataDTO> findObject = fieldReponseObject.getField().stream().filter(field -> "object".equals(field.getData_type())).findFirst();
                if (findObject.isPresent()) {
                    ApiDataFieldMetadataDTO apiDataFieldMetadataDTO = findObject.get();
                    //TODO 暂时从库里已有的EnumKey同步
                    if (!ObjectUtils.isEmpty(queryResult)) {
                        ApiDataFieldMetadataDTO response_object = JSONObject.parseObject(String.valueOf(queryResult.get(0).get("response_object")), ApiDataFieldMetadataDTO.class);
                        if (response_object != null) {
                            putEnumKey(apiDataFieldMetadataDTO, response_object);
                        }
                    }
                    response_str = JSON.toJSONString(apiDataFieldMetadataDTO, SerializerFeature.NotWriteDefaultValue);
                } else
                    response_str = JSON.toJSONString(fieldReponseObject.getField().get(0), SerializerFeature.NotWriteDefaultValue);
            }
            if (ObjectUtils.isEmpty(queryResult)) {
                log.info("创建：{}", actionId);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Create (action:Action:EspAction {");
                stringBuffer.append("actionId:'");
                stringBuffer.append(actionId);
                stringBuffer.append("', url:'");
                stringBuffer.append(url);
                stringBuffer.append("', serviceName:'");
                stringBuffer.append(apiName);
                stringBuffer.append("', serviceVersion:'");
                stringBuffer.append(apiVersion);
                stringBuffer.append("', actionName:'");
                stringBuffer.append(desc_cn);
                stringBuffer.append("', actionName_tw:'");
                stringBuffer.append(desc_tw);
                stringBuffer.append("', desc:'");
                stringBuffer.append(remark_cn);
                stringBuffer.append("', desc_tw:'");
                stringBuffer.append(remark_tw);
                stringBuffer.append("', request_parameters:'");
                stringBuffer.append(request_str);
                stringBuffer.append("', response_object:'");
                stringBuffer.append(response_str);
                stringBuffer.append("', invokeType:'");
                stringBuffer.append(invokeType);
                stringBuffer.append("', lastUpdateTime:'");
                stringBuffer.append(espApiLastUpdateTime);
                stringBuffer.append("', idempotency:");
                stringBuffer.append(idempotency);
                stringBuffer.append(", version:'");
                stringBuffer.append(deployVersion);
                stringBuffer.append("', nameSpace:'");
                stringBuffer.append("espCommon");
                stringBuffer.append("'})");
                Neo4jMultipleUtil.executeCql(StringEscapeUtils.escapeJava(stringBuffer.toString()), driver1, driver2);
            } else {
                log.info("更新：{}", actionId);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Match (action:Action:EspAction {");
                stringBuffer.append("actionId:'");
                stringBuffer.append(actionId);
                stringBuffer.append("'})  where action.tenantId is null set action.url='");
                stringBuffer.append(url);
                stringBuffer.append("', action.serviceName='");
                stringBuffer.append(apiName);
                stringBuffer.append("', action.serviceVersion='");
                stringBuffer.append(apiVersion);
                stringBuffer.append("', action.actionName='");
                stringBuffer.append(desc_cn);
                stringBuffer.append("', action.actionName_tw='");
                stringBuffer.append(desc_tw);
                stringBuffer.append("', action.desc='");
                stringBuffer.append(remark_cn);
                stringBuffer.append("', action.desc_tw='");
                stringBuffer.append(remark_tw);
                stringBuffer.append("', action.request_parameters='");
                stringBuffer.append(request_str);
                stringBuffer.append("', action.response_object='");
                stringBuffer.append(response_str);
                stringBuffer.append("', action.invokeType='");
                stringBuffer.append(invokeType);
                stringBuffer.append("', action.lastUpdateTime='");
                stringBuffer.append(espApiLastUpdateTime);
                stringBuffer.append("', action.idempotency=");
                stringBuffer.append(idempotency);
                stringBuffer.append(", action.version='");
                stringBuffer.append(deployVersion);
                stringBuffer.append("', action.nameSpace='");
                stringBuffer.append("espCommon");
                stringBuffer.append("'");
                Neo4jMultipleUtil.executeCql(StringEscapeUtils.escapeJava(stringBuffer.toString()), driver1, driver2);
            }
        });
    }

    private void putEnumKey(ApiDataFieldMetadataDTO toApiDataFieldMeta, ApiDataFieldMetadataDTO fromApiDataFieldMeta) {
        if (toApiDataFieldMeta.getData_name().equals(fromApiDataFieldMeta.getData_name())) {
            if ("object".equals(toApiDataFieldMeta.getData_type()) && "object".equals(fromApiDataFieldMeta.getData_type())) {
                List<ApiDataFieldMetadataDTO> toApiSubDataFieldMeta = toApiDataFieldMeta.getField();
                List<ApiDataFieldMetadataDTO> fromApiSubDataFieldMeta = fromApiDataFieldMeta.getField();
                putEnumKey(toApiSubDataFieldMeta, fromApiSubDataFieldMeta);
            } else {
                toApiDataFieldMeta.setEnum_key(fromApiDataFieldMeta.getEnum_key());
            }
        }
    }

    private void putEnumKey(List<ApiDataFieldMetadataDTO> toApiDataFieldMetas, List<ApiDataFieldMetadataDTO> fromApiDataFieldMetas) {
        toApiDataFieldMetas.forEach(toApiDataFieldMetadata -> {
            Optional<ApiDataFieldMetadataDTO> fromApiDataFieldMeta = fromApiDataFieldMetas.stream().filter(fromApiDataFieldMetadata -> fromApiDataFieldMetadata.getData_name().equals(toApiDataFieldMetadata.getData_name())).findFirst();
            if (fromApiDataFieldMeta.isPresent())
                putEnumKey(toApiDataFieldMetadata, fromApiDataFieldMeta.get());
        });
    }

}
