package com.digiwin.athena.km_deployer_service.service.km.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.config.ModuleConfig;
import com.digiwin.athena.km_deployer_service.povo.ApiInfoDTO;
import com.digiwin.athena.km_deployer_service.povo.ApiMetadataDataDTO;
import com.digiwin.athena.km_deployer_service.service.km.MdcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName DmcServiceImpl
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/27 10:02
 * @Version 1.0
 **/
@Service
@Slf4j
public class MdcServiceImpl implements MdcService {

    @Autowired
    @Qualifier("mdcRestTemplate")
    RestTemplate restTemplate;
    @Autowired
    ModuleConfig moduleConfig;

    @Override
    public List<ApiInfoDTO> getEspApiList() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        Map<String, String> bodys = new HashMap<>();
        bodys.put("language", "zh_CN");
        HttpEntity<Map<String, String>> httpEntity = new HttpEntity<>(bodys, httpHeaders);
        ResponseEntity<JSONObject> responseEntity = restTemplate.postForEntity(moduleConfig.getMdc().getDomain() + "/restful/standard/mdc/ApiList/Get", httpEntity, JSONObject.class);
        JSONObject responseEntityBody = responseEntity.getBody();
        JSONObject data = responseEntityBody.getJSONObject("data");
        JSONArray apiList = data.getJSONArray("api_info");
        List<ApiInfoDTO> espApiList = apiList.toJavaList(ApiInfoDTO.class);
        return espApiList;
    }
    @Override
    public ApiMetadataDataDTO getEspApiMetadata(String apiName) {
        String apiMetadataUrl = moduleConfig.getMdc().getDomain() + "/restful/standard/mdc/ApiMetadata/Get";
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", "application/json");
        Map<String, String> bodys = new HashMap<>();
        bodys.put("api_name", apiName);
        HttpEntity<Map<String, String>> httpEntity = new HttpEntity<>(bodys, httpHeaders);
        ApiMetadataDataDTO apiMetadataDataDTO;
        try {
            ResponseEntity<JSONObject> responseEntity = restTemplate.postForEntity(apiMetadataUrl, httpEntity, JSONObject.class);
            apiMetadataDataDTO = JSON.parseObject(responseEntity.getBody().getJSONObject("data").toJSONString(), ApiMetadataDataDTO.class);
        } catch (Exception e) {
            log.error("同步api:{}，失败,失败原因:{}", apiName, e.getMessage());
            return null;
        }
        return apiMetadataDataDTO;
    }
}
