package com.digiwin.athena.km_deployer_service.service.km.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ZipUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.deploy.ApplicationData;
import com.digiwin.athena.deploy.ApplicationMongoData;
import com.digiwin.athena.km_deployer_service.povo.DeployRequest;
import com.digiwin.athena.km_deployer_service.povo.DeployResponse;
import com.digiwin.athena.km_deployer_service.constant.Constant;
import com.digiwin.athena.km_deployer_service.domain.km.*;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Relation;
import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.repository.KmPublishRepo;
import com.digiwin.athena.km_deployer_service.povo.*;
import com.digiwin.athena.km_deployer_service.service.HelpService;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.*;
import com.digiwin.athena.km_deployer_service.service.km.handler.KmDeployEventHandler;
import com.digiwin.athena.km_deployer_service.support.DeployContext;
import com.digiwin.athena.km_deployer_service.util.Utils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;
import java.util.stream.Collectors;

@Service
@Slf4j
public class PublishServiceImpl implements IPublishService {

    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoCrudService mongoCrudService;
    @Autowired
    Neo4jCrudService neo4jCrudService;
    @Autowired
    RedisLockRegistry redisLockRegistry;

    @Autowired
    DmcService dmcService;

    @Value("${compile.zipPath}")
    private String compileZipPath;

    @Value("${compile.dataPath}")
    private String compileDataPath;

    @Autowired
    KmPublishRepo kmPublishRepo;

    @Autowired
    HelpService helpService;

    @Autowired
    CommonDataService commonDataService;

    @Autowired
    ApplicationService applicationService;

    @Autowired
    ActionService actionService;

    @Autowired
    List<KmDeployEventHandler> eventHandlers;

    @Override
    public void test01() {
        rebuildAppAndTenantRelation("tuo1","1.0",Arrays.asList("tuo1"));
    }

    // @Async
    @Override
    public DeployResponse publishApplication(DeployRequest request) {
        DeployResponse response = new DeployResponse();
        System.out.println("开始发版："+request.getAppId());
        //创建发布事件
        KmDeployEvent event = createEvent(request);
        response.setEventId(event.getId());
        DeployContext context = new DeployContext();
        context.setDeployId(event.getDeployId());
        context.setEventId(event.getEventId());
        context.setAppId(request.getAppId());
        HelpService.setDeployContext(context);

        try{

            //下载文件内容，并解析
            ApplicationData appData = parseFile(request.getAppId(),request.getFileId());
            appData.setDeployId(event.getDeployId());
            mongoTemplate.save(appData);

            publish(request,appData);

            //处理枚举值问题
            if(Constant.COMMON_CODE.equals(request.getAppId()) && null!=appData.getEnumKeyMappingModule()){
                EspActionEnumkeyModule module = JSON.parseObject(appData.getEnumKeyMappingModule(),EspActionEnumkeyModule.class);
                if(null!=module && null!=module.getEnumKeyMapping()){
                    actionService.updateEspActionEnumKey(module.getEnumKeyMapping());
                }
            }

            event.setStatus(2);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            response.setCode(-1);
            response.setMsg(e.getMessage());
            event.setStatus(3);
            event.setMsg(e.getMessage());

        }finally {
            updateEvent(event);
        }

        return response;
    }

  //  @Async
    @Override
    public DeployResponse switchApplication(DeployRequest request) {
        DeployResponse response = new DeployResponse();
        //找到上次发版的数据
        System.out.println("开始切版"+request.getAppId());
        Query query = Query.query(Criteria.where("appId").is(request.getAppId()).and("status").is(2));
        query.with(Sort.by(Sort.Direction.DESC,"updateTime"));
        KmDeployEvent event = mongoTemplate.findOne(query,KmDeployEvent.class);
        if(null==event){
            response.setCode(-1);
            response.setMsg("未找到上次发版成功的记录，请先发版！");
            return response;
        }
        ApplicationData appData = mongoTemplate.findOne(Query.query(Criteria.where("deployId").is(event.getDeployId())),ApplicationData.class);
        if(null==appData){
            response.setCode(-1);
            response.setMsg("未找到上次发版成功的应用，请先发版！");
            return response;
        }
        if(null==request.getEventId()){
            request.setEventId(HelpService.uuid());
        }

        DeployContext context = new DeployContext();
        context.setDeployId(event.getDeployId());
        context.setEventId(request.getEventId());
        context.setAppId(request.getAppId());
        HelpService.setDeployContext(context);
        event.setSwitchEventId(request.getEventId());
        event.setStatus(4);
        updateEvent(event);

        try {
            publish(request,appData);

            //增量action
            if(Boolean.TRUE.equals(request.getUpdateEspVersion())){
                actionService.incrementSwitchEspAction(request.getEventId());
            }

            event.setStatus(5);
        }catch (Exception e){
            event.setStatus(6);
            event.setMsg(e.getMessage());
            log.error(e.getMessage(),e);
        }finally {
            updateEvent(event);
        }


        return response;
    }

    @Override
    public List<KmDeployLog> deployLogs(DeployRequest request) {

        Query query = Query.query(Criteria.where("eventId").is(request.getEventId()));
        if(null!=request.getStartTime()){
            query.addCriteria(Criteria.where("createTime").gt(request.getStartTime()));
        }
        query.with(Sort.by(Sort.Direction.ASC,"createTime"));
        List<KmDeployLog> logs = mongoTemplate.find(query,KmDeployLog.class);
        return logs;
    }

//    @Override
//    public DeployResponse publishSkill(SkillCompileDto dto) {
//
//        ApplicationData applicationData =   aiCompileService.skillCompile(dto);
//
//        DeployRequest deployRequest = new DeployRequest();
//        deployRequest.setEventId(HelpService.uuid());
//        deployRequest.setVersion(dto.getVersion());
//        deployRequest.setAppId(dto.getAppCode());
//        deployRequest.setTenantIds(dto.getTenantIds());
//        String pluginId = dto.getSkillProduct().getCode();
//        applicationData.getMongoData().forEach(mdata->{
//            mdata.getDocs().forEach(doc->{
//                doc.put("pluginId", pluginId);
//            });
//        });
//
//        publish(deployRequest,applicationData);
//
//
//        return null;
//    }

    @Override
    public void handleEvent(KmEventParam param) {
        log.info("发布事件开始，params：{}", param);
        Optional<KmDeployEventHandler> first = eventHandlers.stream().filter(handler -> handler.handlerComponentType().equals(param.getObjectType())).findFirst();
        if (!first.isPresent()) {
            return;
        }
        KmDeployEventHandler kmDeployEventHandler = first.get();
        // 如果是发版
        if ("publish".equals(param.getType())) {
            if ("begin".equals(param.getTimeOn())) {
                // 1、发版前，则生成event
                KmDeployEvent event = createEvent(param);
                // 前端没传的时候后端自己生成，透传的处理器中
                param.setEventId(event.getEventId());
                kmDeployEventHandler.handleBeforePublish(param);
            } else if ("end".equals(param.getTimeOn())) {
                // 发版后
                kmDeployEventHandler.handleAfterPublish(param);
            }
        } else if ("switch".equals(param.getType())) {
            if ("begin".equals(param.getTimeOn())) {
                // 切版前
                kmDeployEventHandler.handleBeforeSwitch(param);
            } else if ("end".equals(param.getTimeOn())) {
                // 切版后
                kmDeployEventHandler.handleAfterSwitch(param);
            }
        }
    }

    /*
        发版在删除数据到更新版本以及创建新的关系会存在一个空窗期，期间内该应用不可用
        需要根据耗时的情况调整多个租户的创建关系部分

     */

    public void publish(DeployRequest request,ApplicationData appData){
        String appId = request.getAppId();
        String version = request.getVersion();
        List<String> tenantIds = request.getTenantIds();
        List<Relation> relations = new ArrayList<>();
        if(Constant.COMMON_CODE.equals(request.getAppId())){
            if(null!=request.getNeo4jNodeKeyJson()){
                Application2CommonRelationParam findApplication2CommonParam = new Application2CommonRelationParam()
                        .setTenantIdList(tenantIds)
                        .setApplicationList(ListUtil.toList("common", "espCommon"))
                        .setNeo4jNodeKeyJson(request.getNeo4jNodeKeyJson()).setApplicationVersion(version).setCommonVersion(version);
                //补足应用到common应用中的某些action关联关系
                relations = commonDataService.findApplication2CommonRelations(findApplication2CommonParam);
            }
        }else{
            Application2CommonRelationParam findApplication2CommonParam = new Application2CommonRelationParam()
                    .setTenantIdList(tenantIds)
                    .setApplicationList(ListUtil.toList(appId))
                    .setApplicationVersion(version).setCommonVersion(version);
            relations = commonDataService.findSpecialApp2OtherCommonAppRelations(findApplication2CommonParam);
        }

        //检查 tenantEntity和appEntity是否存在，如果不存在则创建
        checkAppAndTenant(request);

        //清除可能存在的发版时数据
        helpService.logDetail("create","开始清理数据",10);
        cleanAppData(appId, Constant.PUBLISH_VERSION,appData);

        //数据更新到库，设置版本为3.0
        helpService.logDetail("create","开始插入数据",12);
        processApplicationData(appData);

        //查询使用当前版本应用的所有租户
        Set<String> useAppTenantIds = kmPublishRepo.findUseAppTenants(appId,version);
        List<String> allTenants = new ArrayList<>();
        allTenants.addAll(useAppTenantIds);
        allTenants.addAll(tenantIds);

        //清除老版本数据
        helpService.logDetail("remove","开始删除老版本数据",40);
        cleanAppData(appId, version,appData);

        //更新发版数据版本号
        helpService.logDetail("update","开始更新发版数据版本",50);
        neo4jCrudService.updateVersion(appId,Constant.PUBLISH_VERSION,version);
        for (ApplicationMongoData mongoDatum : appData.getMongoData()) {
            mongoCrudService.updateVersion(mongoDatum,appId,Constant.PUBLISH_VERSION,version);
        }

        //创建关联关系 todo 拆分或者分线程做
        helpService.logDetail("link","开始更新发版数据版本",60);
        createRelation(appId,version,allTenants);

        //重建租户和应用关联
        rebuildAppAndTenantRelation(request.getAppId(), request.getVersion(), allTenants);

        //更新发版租户版本号
        helpService.logDetail("update","开始更新发版数据版本",90);
        neo4jCrudService.updateTenantVersion(tenantIds,version);


        if(Constant.COMMON_CODE.equals(request.getAppId())){
            //补足应用到common应用中的某些action关联关系
            if(null!=request.getNeo4jNodeKeyJson()){
                CreateApplicationRelationParam createApplicationRelationParam = new CreateApplicationRelationParam()
                        .setRelationList(relations)
                        .setNeo4jNodeKeyJson(request.getNeo4jNodeKeyJson())
                        .setCommonVersion(version)
                        .setApplicationVersion(version);
                applicationService.createApplication2CommonRelation(createApplicationRelationParam);
            }
        }

        helpService.logDetail("end","数据更新完成",100);
    }

    /**
     * 准备切掉tenantEntity和节点关联，全部使用版本号查.仅保留TenantEntity和AppEntity的关联
     * @param appId
     * @param version
     * @param tenantIds
     */
    @Deprecated
    public void createRelation(String appId,String version,List<String> tenantIds){
        Map<String,Object> param1 = new HashMap<>();
        param1.put("tenantId",tenantIds);
        Map<String,Object> param2 = new HashMap<>();
        param2.put(Constant.athena_namespace,appId);
        param2.put(Constant.version,version);
        helpService.logDetail("link","开始创建关联到Task",60);
        neo4jCrudService.createRelation("TenantEntity",param1,"Task",param2,"TASK");
        helpService.logDetail("link","开始创建关联到Activity",65);
        neo4jCrudService.createRelation("TenantEntity",param1,"Activity",param2,"ACTIVITY");
        helpService.logDetail("link","开始创建关联到Action",70);
        neo4jCrudService.createRelation("TenantEntity",param1,"Action",param2,"ACTION");
        helpService.logDetail("link","开始创建关联到MonitorRule",75);
        neo4jCrudService.createRelation("TenantEntity",param1,"MonitorRule",param2,"USE");

    }


    private void checkAppAndTenant(DeployRequest request){
        if(!Constant.COMMON_CODE.equals(request.getAppId())){
            Map<String,Object> map3 =new HashMap<>();
            map3.put("code",request.getAppId());
            map3.put("version",request.getVersion());
            List app = neo4jCrudService.query("AppEntity", map3);
            if(app.isEmpty()){
                helpService.logDetail("createApp","正在创建应用",1);
                createApplication(request.getAppId(), request.getAppName(),request.getVersion());
            }
        }

        if(CollectionUtil.isNotEmpty(request.getTenantIds())){
            helpService.logDetail("createTenant","正在创建租户",2);
            List<String> oldTenantIds = new ArrayList<>();
            List<Map<String,Object>> tenants = neo4jCrudService.query("TenantEntity", MapUtil.of("tenantId",request.getTenantIds()));
            tenants.forEach(t->{
                try{
                    String tenantId = (String) t.get("tenantId");
                    oldTenantIds.add(tenantId);
                }catch (Exception e){
                    log.error(e.getMessage(),e);
                }
            });
            List<String> newTenantIds = CollectionUtil.subtractToList(request.getTenantIds(),oldTenantIds);
            for (String newTenantId : newTenantIds) {
                createTenant(newTenantId,newTenantId,request.getVersion());
            }
        }
    }

    private void rebuildAppAndTenantRelation(String appId,String version,List<String> tenantIds){
        if(Constant.COMMON_CODE.equals(appId)){return;}
        Map<String,Object> map2 =new HashMap<>();
        map2.put("appId",appId);
        map2.put("tenantIds",tenantIds);
        String cyhper = "match(a:TenantEntity)-[r:USE]->(b:AppEntity) where a.tenantId in $tenantIds and b.code=$appId  delete r";
        neo4jCrudService.executeCypher(cyhper,map2);

        Map<String,Object> map3 =new HashMap<>();
        map3.put("code",appId);
        map3.put("version",version);
        neo4jCrudService.createRelation("TenantEntity",MapUtil.of("tenantId",tenantIds),"AppEntity",map3,"USE");

    }

    public void cleanAppData(String appId, String version, ApplicationData appData){
        helpService.logDetail("remove","开始删除老版本neo4j",40);
        CleanNeo4jParam cleanNeo4jParam = new CleanNeo4jParam();
        cleanNeo4jParam.setApplication(appId);
        cleanNeo4jParam.setDeployVersion(version);
        neo4jCrudService.cleanNeo4jData(cleanNeo4jParam);
        helpService.logDetail("remove","开始删除老版本mongo",45);
        CleanMongoParam cleanMongoParam = new CleanMongoParam();
        cleanMongoParam.setApplication(appId);
        cleanMongoParam.setDeployVersion(version);
        Map<String, List<String>> collectionInfo = new HashMap<>();
        appData.getMongoData().forEach(mongodata->{
            List<String> cols = collectionInfo.get(mongodata.getDb());
            if(null==cols){
                cols = new ArrayList<>();
                collectionInfo.put(mongodata.getDb(),cols);
            }
            cols.add(mongodata.getCol());
        });
        cleanMongoParam.setCollectionInfo(collectionInfo);
        mongoCrudService.cleanMongoData(cleanMongoParam);
    }

    private KmDeployEvent createEvent(DeployRequest request){
        KmDeployEvent event = new KmDeployEvent();
        event.setEventId(request.getEventId());
        event.setAppId(request.getAppId());
        event.setStatus(1);
        event.setCreateTime(new Date());
        event.setUpdateTime(System.currentTimeMillis());
        event.setPercent(0);
        event.setRequest(request);

        if(null==event.getDeployId()){
            event.setDeployId(HelpService.uuid());
        }
        if(null==event.getEventId()){
            event.setEventId(HelpService.uuid());
        }
        mongoTemplate.save(event);
        return event;
    }

    private KmDeployEvent createEvent(KmEventParam param) {
        KmDeployEvent event = new KmDeployEvent();
        event.setDeployId(HelpService.uuid());
        if (null == param.getEventId()) {
            event.setEventId(HelpService.uuid());
        }
        event.setAppId(param.getAppCode());
        event.setStatus(1);
        event.setCreateTime(new Date());
        event.setUpdateTime(System.currentTimeMillis());
        event.setPercent(0);
        ApplicationMongoData insertRequest = new ApplicationMongoData();
        insertRequest.setDb(Constant.db_kg_sys);
        insertRequest.setCol("kmDeployEvent");
        Document document = Document.parse(JSON.toJSONString(event));
        insertRequest.setDocs(Collections.singletonList(document));
        mongoCrudService.insert(insertRequest);
        return event;
    }

    private void updateEvent(KmDeployEvent event){
        event.setUpdateTime(System.currentTimeMillis());
        mongoTemplate.save(event);
    }
    public void createApplication(String appCode,String appName,String version){
        String name= appName==null?appCode:appName;
        String cql = "create(app:AppEntity{code:$code,athena_namespace:$code,name:$name,version:$version})";
        Map map = new HashMap();
        map.put("code",appCode);
        map.put("name",name);
        map.put("version",version);
        neo4jCrudService.executeCypher(cql,map);
        //mongo application表

    }
    public void createTenant(String tenantId,String tenantName,String version){
        String name= tenantName==null?tenantId:tenantName;
        String cql = "create(app:TenantEntity{tenantId:$tenantId,name:$name,version:$version})";
        Map map = new HashMap();
        map.put("tenantId",tenantId);
        map.put("name",name);
        map.put("version",version);
        neo4jCrudService.executeCypher(cql,map);
    }


    public ApplicationData parseFile(String application,String fileId) throws IOException {
        helpService.logDetail("parseFile","开始下载文档内容"+fileId,5);
        ApplicationData data = new ApplicationData();
        //解压运行态数据
        String appDir = application;
        if(null==appDir){
            appDir = Utils.uid();
        }
        String applicationCompileZipPath = compileZipPath + File.separator + appDir + File.separator;
        String applicationCompileDataPath = compileDataPath + File.separator + appDir + File.separator;
        String compileDataZipPath = applicationCompileZipPath + appDir + ".zip";
        InputStream inputStream = dmcService.download(fileId);
        FileUtil.writeFromStream(inputStream, compileDataZipPath);//NOSONAR 该文件名是来自环境变脸的输入
        ZipUtil.unzip(compileDataZipPath, applicationCompileDataPath);//NOSONAR 该文件名是来自环境变脸的输入
        File compileDataDirector = new File(applicationCompileDataPath);//NOSONAR 该文件名是来自环境变脸的输入
        File[] compileDataFiles = compileDataDirector.listFiles();
        if(null==compileDataFiles){return data;}
        helpService.logDetail("parseFile","开始解析内容"+fileId,8);
        for(File file: compileDataFiles){
            String filename = file.getName();
            if("cypher".equals(filename)){
                File[] files = file.listFiles();
                if(files==null){continue;}
                for(File file1:files){
                    if(file1.getName().endsWith("json")){
                        List<String> lines = FileUtil.readLines(file1,"UTF-8").stream().map(line->{return line.replaceAll("\\{athena_version}", Constant.PUBLISH_VERSION);}).collect(Collectors.toList());
                        data.getCyphers().addAll(lines);
                    }
                }

            }else if("designer".equals(filename)){
                File[] files = file.listFiles();
                if(files==null){continue;}
                for(File file1:files){
                    if("espActionEnumKey".equals(file1.getName())){
                        File[] files2 = file1.listFiles();
                        if(files2==null || files2.length==0){continue;}
                        String content = FileUtil.readString(files2[0],"UTF-8");
                        if(!StringUtils.isEmpty(content)){
                            data.setEnumKeyMappingModule(content);
                        }
                    }
                }
            } else if(isDb(filename)){
                File[] dirs = file.listFiles();
                if(dirs==null){continue;}
                for(File col:dirs){
                    String colName = col.getName();
                    if(isCol(col)){
                        ApplicationMongoData mongoData = new ApplicationMongoData();
                        mongoData.setDb(filename);
                        mongoData.setCol(colName);
                        File[] files = col.listFiles();
                        if(files==null){continue;}
                        for(File file1:files){
                            if(file1.getName().endsWith("json")){
                                List<String> lines = FileUtil.readLines(file1,"UTF-8");
                                lines.forEach(line->{
                                    Document document = Document.parse(line);
                                    document.remove("_id");
                                    document.remove("isMigrate");
                                    document.put("version", Constant.PUBLISH_VERSION);
                                    if(null!=application){
                                        document.put("athena_namespace", application);
                                        document.put("application", application);
                                    }
                                    mongoData.getDocs().add(document);
                                });

                            }
                        }
                        data.getMongoData().add(mongoData);
                    }
                }

            } else{
               log.info("ignore file "+filename);
            }
        }
        helpService.logDetail("parseFile","完成解析内容"+fileId,10);

        return data;
    }


    public void processApplicationData(ApplicationData data){

        //neo4j 刷库
        helpService.logDetail("create","开始执行cypher,条数"+data.getCyphers().size());
        neo4jCrudService.executeCyphers(data.getCyphers(),new HashMap<>());

        //mongo 刷库
        helpService.logDetail("create","开始执行mongo数据插入");
        for(ApplicationMongoData item:data.getMongoData()){
            helpService.logDetail("create","开始插入表 "+item.getDb()+"."+item.getCol());
            mongoCrudService.insert(item);
        };


    }


    private boolean isDb(String name){
        List<String> dbs = Arrays.asList("knowledgegraphSystem","datamap","preset","tagSystem");
        return dbs.contains(name);
    }
    private boolean isCol(File file){
        return file.isDirectory();
    }
}
