package com.digiwin.athena.km_deployer_service.service.km.impl;

import com.digiwin.athena.deploy.ApplicationData;
import com.digiwin.athena.km_deployer_service.povo.DeployResponse;
import com.digiwin.athena.km_deployer_service.constant.DbInfo;
import com.digiwin.athena.km_deployer_service.neo4jbasepkg.master.repository.KmPublishRepo;
import com.digiwin.athena.km_deployer_service.povo.*;
import com.digiwin.athena.km_deployer_service.service.HelpService;
import com.digiwin.athena.km_deployer_service.service.dmc.DmcService;
import com.digiwin.athena.km_deployer_service.service.km.*;
import com.digiwin.athena.km_deployer_service.service.km.handler.KmDeployEventHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.integration.redis.util.RedisLockRegistry;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Service
public class TenantPublishServiceImpl implements ITenantPublishService {

    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    MongoCrudService mongoCrudService;
    @Autowired
    Neo4jCrudService neo4jCrudService;
    @Autowired
    RedisLockRegistry redisLockRegistry;

    @Autowired
    DmcService dmcService;

    @Value("${compile.zipPath}")
    private String compileZipPath;

    @Value("${compile.dataPath}")
    private String compileDataPath;

    @Autowired
    KmPublishRepo kmPublishRepo;

    @Autowired
    HelpService helpService;

    @Autowired
    CommonDataService commonDataService;

    @Autowired
    ApplicationService applicationService;

    @Autowired
    ActionService actionService;

    @Autowired
    List<KmDeployEventHandler> eventHandlers;


    @Autowired
    PublishServiceImpl publishService;



    @Override
    public DeployResponse publishTenant(DeployTenantRequest request) {
        DeployResponse response = new DeployResponse();
        String version = neo4jCrudService.tenantVersion(request.getTenantId());

        try {
            //解析文件
            ApplicationData appData = publishService.parseFile(null,request.getFileId());
            appData.getMongoData().forEach(mongoData -> {
                mongoData.getDocs().forEach(doc->{
                   doc.put("tenantId",request.getTenantId());
                   doc.put("pluginId",request.getDataId());
                   doc.put("version", version);
                });
            });

            //清除老数据
            cleanData(request.getDataId(), request.getTenantId());

            //插入新数据
            publishService.processApplicationData(appData);



        } catch (IOException e) {
            throw new RuntimeException(e);
        }

        return response;
    }

    @Override
    public DeployResponse revokeTenant(DeployTenantRequest request) {
        DeployResponse response = new DeployResponse();

        cleanData(request.getDataId(), request.getTenantId());

        return response;
    }



    public void cleanData(String pluginId,String tenantId){
        Map<String,Object> params = new HashMap<>();
        params.put("tenantId",tenantId);
        params.put("pluginId",pluginId);
        DbInfo.dbTables.forEach((db,tables)->{
            tables.forEach(table->{
                CrudReq req = new CrudReq();
                req.setDbName(db);
                req.setColName(table);
                req.setParams(params);
                mongoCrudService.delete(req);
            });
        });
    }
}
