package com.digiwin.athena.km_deployer_service.service.km.servermap;

import com.digiwin.athena.km_deployer_service.povo.EspServiceMapDto;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.digiwin.athena.km_deployer_service.service.km.Neo4jCrudService;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import lombok.RequiredArgsConstructor;
import org.bson.Document;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RequiredArgsConstructor
public class ServerMapInfoAppender {

    private final MongoCrudService mongoCrudService;

    private final Neo4jCrudService neo4jCrudService;

    public void addAppNameAndEspName(List<EspServiceMapDto> dto) {
        if (dto.isEmpty()) {
            return;
        }
        Map<String, String> appCodeToName = new HashMap<>();
        Map<String, String> espToName = new HashMap<>();
        for (EspServiceMapDto each : dto) {
            if (!each.getAppCode().isEmpty()) {
                appCodeToName.put(each.getAppCode(), "");
            }
            espToName.put(each.getEspServiceId(), "");
        }
        List<Document> documents = mongoCrudService.find("knowledgegraphSystem",
                "application",
                Filters.in("code", appCodeToName.keySet()),
                Projections.include("code", "name"),
                Document.class);
        for (Document doc : documents) {
            appCodeToName.put(doc.getString("code"), doc.getString("name"));
        }
        for (EspServiceMapDto each : dto) {
            each.setAppName(appCodeToName.getOrDefault(each.getAppCode(), ""));
        }
        Map<String, Object> params = new HashMap<>();
        params.put("actionId", espToName.keySet());
        List<Map<String,Object>> actions = neo4jCrudService.query("Action", params);
        for (Map<String, Object> action : actions) {
            espToName.put(action.get("actionId").toString(), action.getOrDefault("actionName", "").toString());
        }
        for (EspServiceMapDto each : dto) {
            each.setEspServiceName(espToName.getOrDefault(each.getEspServiceId(), ""));
        }
    }
}
