package com.digiwin.athena.km_deployer_service.service.km.servermap;

import com.digiwin.athena.km_deployer_service.povo.EspServiceMapDto;
import com.digiwin.athena.km_deployer_service.service.km.MongoCrudService;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;

import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.Callable;

@Slf4j
@RequiredArgsConstructor
public class ServerMapMongoAnalyzer implements Callable<Void> {

    private final String db;

    private final String col;

    private final String type;

    private final String name;

    private final MongoCrudService mongoCrudService;

    private final MongoTemplate mongoTemplate;

    private final ServerMapInfoAppender serverMapInfoAppender;

    private final int mongoBatchSize;

    private final List<EspServiceMapDto> toInsert = new ArrayList<>();

    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Void call() {
        long start = System.currentTimeMillis();
        mongoCrudService.processLargeQuery(db, col, Collections.emptyMap(), mongoBatchSize,
                this::processBatch);
        log.info("processLargeQuery from mongo col: {} cost: {}", col, System.currentTimeMillis() - start);
        return null;
    }

    @SneakyThrows
    private void processBatch(List<Map<String, Object>> batch, boolean isLastBatch) {
        for (Map<String, Object> map : batch) {
            String s = objectMapper.writeValueAsString(map);
            List<String> espStrings = EspExtractUtil.extractEspStrings(s);
            for (String esp : espStrings) {
                EspServiceMapDto espServiceMapDto = new EspServiceMapDto();
                espServiceMapDto.setKey(UUID.randomUUID().toString());
                espServiceMapDto.setType(type);
                espServiceMapDto.setName(name);
                espServiceMapDto.setAppCode(map.getOrDefault("application",
                        map.getOrDefault("sourceId", "")).toString());
                espServiceMapDto.setEspServiceId(esp);
                espServiceMapDto.setCreateTime(LocalDateTime.now());
                espServiceMapDto.setFlag(0);
                toInsert.add(espServiceMapDto);
            }
        }
        if (toInsert.size() >= mongoBatchSize || isLastBatch) {
            serverMapInfoAppender.addAppNameAndEspName(toInsert);
            saveToMongo(toInsert);
            toInsert.clear();
        }
    }


    private void saveToMongo(List<EspServiceMapDto> dto) {
        if (dto.isEmpty()) {
            return;
        }
        // TODO 考虑是否需要积累到一定的量再一起批量插入
        mongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, EspServiceMapDto.class)
                .insert(dto)
                .execute();
    }
}
