package com.digiwin.athena.km_deployer_service.service.page.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.config.neo4j.Neo4jManager;
import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.neo4j.Cql;
import com.digiwin.athena.km_deployer_service.service.page.PageService;
import com.digiwin.athena.km_deployer_service.util.Neo4jMultipleUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.text.StringEscapeUtils;
import org.neo4j.driver.Driver;
import org.neo4j.driver.internal.InternalNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service
@Slf4j
public class PageServiceImpl implements PageService {
    @Autowired
    private Driver driver1;

    @Autowired(required = false)
    @Qualifier("domain2Driver")
    private Driver driver2;

    @Override
    public void pagePublish2KM(JSONObject neo4jDatas, JSONObject originalCodeRelationShip, String version) {
        if (neo4jDatas.get("Activity") != null) {
            List<String> activityDatas = (List<String>)neo4jDatas.get("Activity");

            log.info("activityDatas:{}", activityDatas);

            for (String neo4jData : activityDatas) {
                neo4jData = neo4jData.replaceAll("\\{athena_version}", version);

                List<String> newNeo4jDatas = this.replaceCode(neo4jData, originalCodeRelationShip);

                for (String cql : newNeo4jDatas) {
                    Neo4jMultipleUtil.executeCql(cql, driver1, driver2);
                }
            }
        }
    }

    private List<String> replaceCode(String neo4jData, JSONObject originalCodeRelationShip) {
        String originalCode = "";
        // 使用正则表达式查找code的值
        Pattern pattern = Pattern.compile("code:'(\\w+)'");
        Matcher matcher = pattern.matcher(neo4jData);

        if (matcher.find()) {
            originalCode = matcher.group(1);
        }

        List<String> newNeo4jDatas = new ArrayList<>();
        JSONObject activityConfigRelation = originalCodeRelationShip.getJSONObject(AsaConstant.COLLECTION_NAME_ACTIVITY_CONFIGS);
        if (activityConfigRelation.get(originalCode) != null) {
            List<String> relaItemStepCodes = (List<String>)activityConfigRelation.get(originalCode);

            for (String itemStepCode : relaItemStepCodes) {
                String newCode = itemStepCode + originalCode;

                // 替换原始的code值
                String newNeo4jData = neo4jData.replace("code:'" + originalCode + "'", "code:'" + newCode + "'");
                newNeo4jDatas.add(newNeo4jData);
            }
        }
        return newNeo4jDatas;
    }

    @Override
    public void cleanPageDataFromKM(String application, String version) {
        List<Cql> cqlList = new ArrayList<>();
        Map<String, Object> param = new HashMap<>();
        param.put("application", application);
        param.put("version", version);
        String cqlStr = "MATCH (n:Activity {athena_namespace: $application, version: $version})OPTIONAL MATCH (n)-[r]-() DELETE r, n;";
        cqlList.add(new Cql().setCql(cqlStr).setParams(param));

        Neo4jMultipleUtil.executeCqlTrans(cqlList, driver1, driver2);
    }

    @Override
    public void updatePageDataVersion(String application, String oldVersion, String newVersion) {
        List<Cql> cqlList = new ArrayList<>();
        Map<String, Object> param = new HashMap<>();
        param.put("application", application);
        param.put("oldVersion", oldVersion);
        param.put("newVersion", newVersion);

        String cqlStr = "match (n:Activity) where n.athena_namespace = $application and n.version=$oldVersion set n.version=$newVersion";
        cqlList.add(new Cql().setCql(cqlStr).setParams(param));

        Neo4jMultipleUtil.executeCqlTrans(cqlList, driver1, driver2);
    }

    @Override
    public void createNewPageData(String application, String oldVersion, String newVersion) {
        Neo4jManager neo4jManager1 = new Neo4jManager(driver1);
        this.createNewActivity(application, oldVersion, newVersion, neo4jManager1);
        if (driver2 != null) {
            Neo4jManager neo4jManager2 = new Neo4jManager(driver2);
            this.createNewActivity(application, oldVersion, newVersion, neo4jManager2);
        }
    }

    private void createNewActivity(String application, String oldVersion, String newVersion, Neo4jManager neo4jManager) {
        Map<String, Object> param = new HashMap<>();
        param.put("application", application);
        param.put("oldVersion", oldVersion);

        String cqlStr = "match (n:Activity) where n.athena_namespace = $application and n.version=$oldVersion return n";

        List<Map<String, Object>> activityResults = neo4jManager.ExecuteQuery(cqlStr, param);

        List<Cql> cqlList = new ArrayList<>();
        for (Map<String, Object> activityResult : activityResults) {
            StringBuilder nodeCypher = new StringBuilder("create (n:Activity");
            nodeCypher.append("{");
            Map<String, Object> properties = ((InternalNode) activityResult.get("n")).asMap();
            // 取到属性组装cql
            combineNodeProperties(properties, nodeCypher);
            nodeCypher.append(String.format("version:'%s', publishTime:'%s'})", newVersion, DateUtil.now()));
            cqlList.add(new Cql().setCql(StringEscapeUtils.escapeJava(nodeCypher.toString())));
        }

        neo4jManager.ExecuteTransactionNoQuery(cqlList);
    }

    private void combineNodeProperties(Map<String, Object> properties, StringBuilder nodeCypher) {
        properties.forEach((k, v) -> {
            if (!"version".equals(k)) {
                if (k.contains(".")) {
                    nodeCypher.append(String.format("`%s`:", k));
                } else {
                    nodeCypher.append(String.format("%s:", k));
                }
                if (v instanceof String) {
                    String propertyValue = (String) v;
                    propertyValue = propertyValue.replace("'", "\\\"");
                    nodeCypher.append(String.format("'%s',", propertyValue));
                } else if (v instanceof Collection) {
                    nodeCypher.append("[");
                    List propertyValueList = (List) v;
                    propertyValueList.forEach(propertyValue -> {
                        if (propertyValue instanceof String) {
                            nodeCypher.append(String.format("'%s'", propertyValue)).append(",");
                        } else {
                            nodeCypher.append(propertyValue).append(",");
                        }
                    });
                    if (!propertyValueList.isEmpty()) {
                        nodeCypher.deleteCharAt(nodeCypher.length() - 1);
                    }
                    nodeCypher.append("],");
                } else {
                    nodeCypher.append(v).append(",");
                }
            }
        });
    }
}
