package com.digiwin.athena.km_deployer_service.spi;


import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.povo.DapResponse;
import com.digiwin.athena.km_deployer_service.util.Utils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
@Slf4j
public class AtmcService {


    @Value("${module.atmc.domain}")
    private String atmcUrl;

    /*
    atmc:cache:*
uibot:cache:*
Athena:agileInteraction:audc:cache:*
     */
    public Object cleanCache(){
        Map<String,Object> params = new HashMap<>();
        DapResponse resp = Utils.request(atmcUrl+"/api/atmc/v1/cache/reset","get",params);
        return resp.getResponse();
    }

    public void cacheResetToAtmc(String curTenantToken) {
        String url = atmcUrl + "/api/atmc/v1/cache/reset";
        HttpResponse response = HttpUtil.createGet(url).header("token", curTenantToken)
                .header("Content-Type", "application/json; charset=UTF-8").execute();
        if ((response != null) && (200 == response.getStatus())) {
            log.info("cacheResetToAtmc#调用第三方atmc接口成功!");
        }

    }


}
