package com.digiwin.athena.km_deployer_service.spi;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.config.ModuleConfig;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.service.km.TenantService;
import com.digiwin.athena.km_deployer_service.util.RSAUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.http.*;
import org.springframework.web.client.RestTemplate;

import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName DmcServiceImpl
 * @Description TODO
 * @Author zhuangli
 * @Date 2021/4/27 10:02
 * @Version 1.0
 **/
//@Service
@Slf4j
public class IamService {

    @Autowired
    private ModuleConfig moduleConfig;

    @Value("${appToken}")
    private String appToken;

    @Autowired
    private TenantService tenantService;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private RedisCache redisCache;

    private static final String IV_STRING = "ghUb#er57HBh(u%g";
    private static final String CHARSET = "UTF-8";

    private final static String INTEGRATION_ACCOUNT = "integration";

    @Value("${iamIntegrationToken:integration}")
    private String integrationToken;


    public String integrationLogin(String tenantId) {
        String domain = moduleConfig.getIam().getDomain();
        String uri = domain + "/api/iam/v2/identity/login";
        try {
            //1.客户端生成公私钥
            Map<String, String> keyMap = getKeyPairMap();
            if (keyMap != null) {
                String clientPublicKey = keyMap.get("publicKey");
                String privateKey = keyMap.get("privateKey");
                //2.获取服务端公钥
                String serverPublicKey = getServerPublicky(domain, appToken);
                //3.根据服务端公钥加密客户端公钥
                String encryptPublicKey = RSAUtils.encryptByPublicKey(clientPublicKey, serverPublicKey);
                //4.获取加密后的AES的key值
                String encryptAesKey = getAesPublicky(domain, encryptPublicKey, appToken);
                //5.根据客户端私有解密加密的aes的key值
                String aesKey = new String(RSAUtils.decryptByPrivateKey(Base64.decodeBase64(encryptAesKey), privateKey));
                String passwordHash = aesEncryptByBase64(integrationToken, aesKey);
                //6.登录
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                headers.add("digi-middleware-auth-app", appToken);

                Map<String, String> requestEntity = new HashMap<>(3);
                requestEntity.put("identityType", "token");
                requestEntity.put("tenantId", tenantId);
                requestEntity.put("userId", "integration");
                requestEntity.put("passwordHash", passwordHash);
                requestEntity.put("clientEncryptPublicKey", encryptPublicKey);
                HttpEntity<Map<String, String>> httpEntity = new HttpEntity<>(requestEntity, headers);
                ResponseEntity<Map> response = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, Map.class);
                return String.valueOf(response.getBody().get("token"));
            }
        } catch (Exception ex) {
            log.error("登录失败：{}", ex.getMessage(), ex);
        }
        return null;
    }


    public String getIsvCode(String tenantId) {

        String integrationToken = integrationLogin(tenantId);

        String tbbServiceUrl = moduleConfig.getIam().getDomain() + "/api/iam/v2/tenant/current";
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json");
        headers.put("digi-middleware-auth-user", integrationToken);
        String response = HttpUtil.createPost(tbbServiceUrl).addHeaders(headers).execute().body();
        JSONObject reponseJson = JSON.parseObject(response);
        return reponseJson.getJSONObject("tenant").getString("customerId");
    }

    private static String getServerPublicky(String domain, String appToken) {
        String uri = domain + "/api/iam/v2/identity/publickey";
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", appToken);
            HttpEntity<Map<String, String>> httpEntity = new HttpEntity<>(headers);
            ResponseEntity<Map> response = restTemplate.exchange(uri, HttpMethod.GET, httpEntity, Map.class);
            return String.valueOf(response.getBody().get("publicKey"));
        } catch (Exception e) {
            log.error("登录失败：{}", e.getMessage(), e);
        }
        return "";
    }


    private static String getAesPublicky(String domain, String encryptPublicKey, String appToken) {
        String uri = domain + "/api/iam/v2/identity/aeskey";
        try {
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-app", appToken);
            Map<String, String> requestEntity = new HashMap<>(1);
            requestEntity.put("clientEncryptPublicKey", encryptPublicKey);
            HttpEntity<Map<String, String>> httpEntity = new HttpEntity<>(requestEntity, headers);
            ResponseEntity<Map> response = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, Map.class);
            return String.valueOf(response.getBody().get("encryptAesKey"));
        } catch (Exception e) {
            log.error("登录失败：{}", e.getMessage(), e);
        }
        return "";
    }

    public static HashMap<String, String> getKeyPairMap() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(1024);//NOSONAR
        KeyPair keyPair = generator.generateKeyPair();
        String privateKey = new String(Base64.encodeBase64(keyPair.getPrivate().getEncoded()));
        String publicKey = new String(Base64.encodeBase64(keyPair.getPublic().getEncoded()));
        HashMap<String, String> keyMap = new HashMap<>();
        keyMap.put("privateKey", privateKey);
        keyMap.put("publicKey", publicKey);
        return keyMap;
    }

    public static String aesEncryptByBase64(String src, String aesKey) {
        try {
            //生成和mysql一致的加密数据
            SecretKeySpec key = new SecretKeySpec(aesKey.getBytes(CHARSET), "AES");
            byte[] initParam = IV_STRING.getBytes(CHARSET);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(initParam);//NOSONAR 加密相关需要整体改造
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");//NOSONAR 加密相关需要整体改造
            cipher.init(Cipher.ENCRYPT_MODE, key, ivParameterSpec);

            byte[] cleartext = src.getBytes("UTF-8");
            byte[] ciphertextBytes = cipher.doFinal(cleartext);
            java.util.Base64.Encoder encoder = java.util.Base64.getEncoder();
            return encoder.encodeToString(ciphertextBytes);
        } catch (Exception ex) {
            log.error("AES加密失败[{}]", src);
            return src;
        }

    }

    /**
     * 获取用户的secretKey
     *
     * @param iamToken
     * @return
     */
    public String getVisualToken(String appCode, String iamToken) {
        String urlIam = moduleConfig.getIam().getDomain() + "/api/iam/v2/user/tenant/application";
        String response = HttpUtil.createGet(urlIam)
                .header("Content-Type", "application/json")
                .header("Digi-middleware-auth-user", iamToken)
                .execute().body();
        // 如果是common应用，先使用Athena的
//        if (Constant.COMMON_CODE.equals(appCode)) {
//            appCode = "Athena";
//        }
        String secretKey = "";
        JSONArray objects = JSONArray.parseArray(response);
        for (Object jSONObjectTemp : objects) {
            JSONObject objectApp = (JSONObject) jSONObjectTemp;
            String appCodeResult = objectApp.getString("id");
            if (appCode.equals(appCodeResult)) {
                secretKey = objectApp.getString("secretKey");
                break;
            }
        }

        String url = moduleConfig.getIam().getDomain() + "/api/iam/v2/identity/login";

        HttpHeaders httpHeaders = new HttpHeaders();
        MediaType type = MediaType.parseMediaType("application/json; charset=UTF-8");
        httpHeaders.setContentType(type);
        httpHeaders.add(com.digiwin.athena.km_deployer_service.constant.Constant.APP_TOKEN, appToken);
        JSONObject body = new JSONObject();
        body.put("secretKey", secretKey);
        body.put("identityType", "secretKey");
        HttpEntity<JSONObject> httpEntity = new HttpEntity<>(body, httpHeaders);

        log.info("getTenantToken request:{}", httpEntity);
        JSONObject response1 = restTemplate.postForObject(url, httpEntity, JSONObject.class);
        log.info("getTenantToken response:{}", response1);

        return response1.getString("token");
    }



    public Long getAppSid(String appCode, String tenantId) {
        String token = integrationLogin(tenantId);
        String iamUrl = moduleConfig.getIam().getDomain() + StrUtil.format( "/api/iam/v2/dev/app/id/{}",appCode);
        String response = HttpUtil.createGet(iamUrl)
                .header("digi-middleware-auth-user", token)
                .header("digi-middleware-auth-app", appToken)
                .execute().body();
        JSONObject responseObj = JSON.parseObject(response);
        Boolean success = responseObj.getBoolean("success");
        if (!success) {
            log.error("获取应用sid失败，返回:{}", response);
            throw new BusinessException("获取应用sid失败，创建应用模组失败!");
        }
        String appSid = responseObj.getJSONObject("data").getString("sid");
        return Long.parseLong(appSid);
    }



}
