package com.digiwin.athena.km_deployer_service.spi;

import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.deploy.DeployConstants;
import com.digiwin.athena.deploy.DeployTask;
import com.digiwin.athena.km_deployer_service.config.ModuleConfig;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@Service
public class KgService {


    @Value("${module.km.domain}/restful/service/knowledgegraph/")
    private String knowledgeGraphUrl;
    @Autowired
    private ModuleConfig moduleConfig;

//    @Autowired
//    IamService iamService;

    @Async
    public void cleanCache() {
        JSONObject param = new JSONObject();
        param.put("keyPattern", Arrays.asList("kg:*", "tag*", "presetLibrary*"));
        requestKg("cache/withPattern", param, Method.DELETE);
    }

    public void cacheResetToKm() {
        JSONObject param = new JSONObject();
        param.put("keyPatterns", Arrays.asList("knowledgegraph*","tagsystem*","presetlibrary*"));
        requestKg("cache/withPattern", param, Method.DELETE);
    }

    public String requestKg(String serviceName, JSONObject paramJson, Method method) {
        String url = knowledgeGraphUrl + serviceName;
        try {
            String response = HttpUtil.createRequest(method, url).body(paramJson.toJSONString()).execute().body();
            log.info("请求kg成功:{}", response);
            return response;
        } catch (Exception e) {
            log.error("请求kg失败:{}", e.getMessage());
        }
        return null;
    }


    public void updateApplicationComponentList(DeployTask task) {
      //  String token = iamService.integrationLogin(tenantId);
        String url = moduleConfig.getKm().getDomain() + "/restful/service/knowledgegraph/Component/UpdateApplicationComponentList";
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", task.getToken());
        if(null!=task.getRouterKey()){
            headers.put("routerKey", task.getRouterKey());
        }
        JSONObject body = new JSONObject();
        body.put("appCode", task.getAppId());
        body.put("version", task.getVersion());
        // 个案发版，传租户id
        if (DeployConstants.DeployType.tenantApp.equals(task.getType())) {
            body.put("tenantIds", task.getTenantIds());
        }
        log.info("updateApplicationComponentList url is -->{}", url);
        log.info("updateApplicationComponentList headers is -->{}", headers);
        log.info("updateApplicationComponentList request is -->{}", body);
        String response = HttpUtil.createRequest(Method.POST, url).addHeaders(headers).body(JSON.toJSONString(body)).execute().body();
        log.info("updateApplicationComponentList response is -->{}", response);
        JSONObject responseObj = JSON.parseObject(response);
        if(responseObj.getInteger("status") != 200){
            throw new BusinessException("调用/restful/service/knowledgegraph/Component/UpdateApplicationComponentList接口更新组件清单失败！返回信息：" + response);
        }
    }

    /**
     * 调用机制一次编译接口
     *
     * @param task 发版任务
     * @param mechanismCodes 机制code
     */
    public void executeMechanismCompile(DeployTask task, List<String> mechanismCodes) {
        String url = moduleConfig.getKm().getDomain()
                + "/restful/service/knowledgegraph/mechanismDesign/applyMechanisms";
        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "application/json; charset=UTF-8");
        headers.put("token", task.getToken());
        if(null!=task.getRouterKey()){
            headers.put("routerKey", task.getRouterKey());
        }
        JSONObject body = new JSONObject();
        body.put("mechanismCodes", mechanismCodes);
        body.put("application", task.getAppId());
        body.put("version", task.getVersion());
        // 个案发版，传租户id
        if (DeployConstants.DeployType.tenantApp.equals(task.getType())) {
            body.put("tenantIds", task.getTenantIds());
        }
        String response = HttpUtil.createRequest(Method.POST, url)
                .addHeaders(headers)
                .body(JSON.toJSONString(body))
                .execute()
                .body();
        log.info("applyMechanisms response is -->{}", response);
        JSONObject responseObj = JSON.parseObject(response);
        if(responseObj.getInteger("status") != 200){
            throw new BusinessException("调用/restful/service/knowledgegraph/mechanismDesign/applyMechanisms 接口机制一次编译失败！返回信息：" + response);
        }
    }
}
