package com.digiwin.athena.km_deployer_service.template;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.domain.asa.model.BaseModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.CollectionModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.ActivityModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.AppRelationModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.CustomConfigModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.DataDescriptionModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.DataFeatureSetModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.DataStateModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.FlowGraphModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.PageViewModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.ProjectModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.RulesModelVo;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.TaskModel;
import com.digiwin.athena.km_deployer_service.domain.system.BusinessException;
import com.digiwin.athena.km_deployer_service.util.FileUtils;
import com.github.benmanes.caffeine.cache.Cache;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Slf4j
public class AbstractTemplate<T extends BaseModel> implements ITemplate {
    @Autowired
    private Cache<String, String> templateCaffeineCache;

    protected String collectName;

    @Value("classpath:template/yourFile.json")
    private Resource templateResource;

    /**
     * key 是CustomConfigModel的templateType
     */
    protected final Map<String, List<Function<CustomConfigModel, T>>> TEMPLATE_HOLDER = new HashMap<>(10);

    protected static final Map<String, Object> TEMPLATE_TYPE_PATH = new HashMap<>();

    static {
        TEMPLATE_TYPE_PATH.put(ASSISTANT_SCENE_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "assistant_scene_template");
        TEMPLATE_TYPE_PATH.put(COLLECT_ITEM_STEP_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "collect_item_step_template");
        TEMPLATE_TYPE_PATH.put(CONSULT_ITEM_STEP_TEMPLATE, Stream.of("template" + File.separator + "asaDeployer" + File.separator + "consult_item_step_template" + File.separator + "allConsult",
                "template" + File.separator + "asaDeployer" + File.separator + "consult_item_step_template" + File.separator + "common",
                "template" + File.separator + "asaDeployer" + File.separator + "consult_item_step_template" + File.separator + "partConsult",
                "template" + File.separator + "asaDeployer" + File.separator + "consult_item_step_template" + File.separator + "specifyConsult",
                "template" + File.separator + "asaDeployer" + File.separator + "consult_item_step_template" + File.separator + "stepConsult").collect(Collectors.toList()));
        TEMPLATE_TYPE_PATH.put(NOTIFACATION_ITEM_STEP_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "notification_item_step_template");
        TEMPLATE_TYPE_PATH.put(BILL_ITEM_STEP_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "bill_item_step_template");
        TEMPLATE_TYPE_PATH.put(CARD_ITEM_STEP_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "card_item_step_template");
        TEMPLATE_TYPE_PATH.put(MINUTES_TASK_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "minutes_task_template");
        TEMPLATE_TYPE_PATH.put(API_TASK_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "api_task_template");
        TEMPLATE_TYPE_PATH.put(TRIP_TASK_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "trip_task_template");
        TEMPLATE_TYPE_PATH.put(FORM_TASK_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "form_task_template");
        TEMPLATE_TYPE_PATH.put(SCHEDULE_QUERY_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "schedule_query_task_template");
        TEMPLATE_TYPE_PATH.put(SCHEDULE_UPDATE_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "schedule_update_task_template");
        TEMPLATE_TYPE_PATH.put(SCHEDULE_DELETE_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "schedule_delete_task_template");
        TEMPLATE_TYPE_PATH.put(TEXT_COLLECT_ITEM_STEP_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "text_collect_item_step_template");
        TEMPLATE_TYPE_PATH.put(LLM_CALL_TEMPLATE, "template" + File.separator + "asaDeployer" + File.separator + "llm_task_template");
    }

    protected static final Map<String, Class> TEMPLATE_MODEL_CLAZZ = new HashMap<>();

    static {
        TEMPLATE_MODEL_CLAZZ.put(TEMPLATE_DATA_TYPE_ACTIVITY, ActivityModel.class);
        TEMPLATE_MODEL_CLAZZ.put(TEMPLATE_DATA_TYPE_DATA_DESCRIPTION, DataDescriptionModel.class);
        TEMPLATE_MODEL_CLAZZ.put(TEMPLATE_DATA_TYPE_DATA_STATE, DataStateModel.class);
        TEMPLATE_MODEL_CLAZZ.put(TEMPLATE_DATA_TYPE_DATA_FEATURE_SET, DataFeatureSetModel.class);
        TEMPLATE_MODEL_CLAZZ.put(TEMPLATE_DATA_TYPE_PROJECT, ProjectModel.class);
        TEMPLATE_MODEL_CLAZZ.put(TEMPLATE_DATA_TYPE_FLOW_GRAPH, FlowGraphModel.class);
        TEMPLATE_MODEL_CLAZZ.put(TEMPLATE_DATA_TYPE_PAGE_VIEW, PageViewModel.class);
        TEMPLATE_MODEL_CLAZZ.put(TEMPLATE_DATA_TYPE_TASK, TaskModel.class);
        TEMPLATE_MODEL_CLAZZ.put(TEMPLATE_DATA_TYPE_APP_RELATION, AppRelationModel.class);
        TEMPLATE_MODEL_CLAZZ.put(TEMPLATE_DATA_TYPE_RULES, RulesModelVo.class);
    }

    /**
     * 初始化模板方法
     *
     * @param dataType          模板数据类型
     * @param templateFilePaths 模板文件
     */
    protected void initTemplateFunction(String dataType, List<String> templateFilePaths) {
        for (String templateType : TEMPLATE_TYPE_PATH.keySet()) {
            Object templateTypeBasePath = TEMPLATE_TYPE_PATH.get(templateType);

            List<Function<CustomConfigModel, T>> templateFunctionList = new ArrayList<>();

            if (templateTypeBasePath instanceof String) {
                for (String templateFilePath : templateFilePaths) {
                    int subPathIndex = templateFilePath.indexOf(templateTypeBasePath.toString());
                    if (subPathIndex != -1) {
                        String relativePath = templateFilePath.substring(subPathIndex);
                        Function<CustomConfigModel, T> templateFunction = model -> (T) templateVarProcess(relativePath, model, TEMPLATE_MODEL_CLAZZ.get(dataType));
                        templateFunctionList.add(templateFunction);
                    }
                }
            } else if (templateTypeBasePath instanceof List) {
                List<String> templateTypeBasePaths = (List<String>) templateTypeBasePath;

                for (String basePath : templateTypeBasePaths) {
                    for (String templateFilePath : templateFilePaths) {
                        int subPathIndex = templateFilePath.indexOf(basePath);
                        if (subPathIndex != -1) {
                            String relativePath = templateFilePath.substring(subPathIndex);
                            Function<CustomConfigModel, T> templateFunction = model -> (T) templateVarProcess(relativePath, model, TEMPLATE_MODEL_CLAZZ.get(dataType));
                            templateFunctionList.add(templateFunction);
                        }
                    }
                }
            }


            TEMPLATE_HOLDER.put(templateType, templateFunctionList);
        }

        log.info(String.valueOf(TEMPLATE_HOLDER.get(COLLECT_ITEM_STEP_TEMPLATE).size()));
    }

    @Override
    public String getCollectName() {
        return collectName;
    }

    @Override
    public List generate(CustomConfigModel model) {
        List<T> result = new ArrayList<>();
        if (TEMPLATE_HOLDER.containsKey(model.getTemplateType())) {
            TEMPLATE_HOLDER.get(model.getTemplateType()).forEach(func -> result.add(func.apply(model)));
        }
        return result;
    }

    @Override
    public void fillCustomConfigModel(CustomConfigModel defConfigModel, JSONObject assistantSceneItemStep) {
    }

    protected T basicProjectProcess(String filePath, CustomConfigModel model, Class<T> cls) {
        String content = processProjectTemplate(filePath, model);
        return initModel(content, model, cls);
    }

    protected String processProjectTemplate(String filePath, CustomConfigModel model) {
        String processJson = getProcessJson(filePath);
        return processJson.replace("#{applicationCode}", model.getAssistantCode()).replace("#{sceneCode}", model.getSceneCode())
                .replace("#{sceneName}", model.getSceneName());
    }

    /**
     * 模板基础处理
     *
     * @param filePath
     * @param model
     * @param cls
     * @return
     */
    protected T templateVarProcess(String filePath, CustomConfigModel model, Class<T> cls) {
        String processJson = getProcessJson(filePath);
        String content = processJson.replace("#{applicationCode}", model.getAssistantCode())
                .replace("#{applicationName}", model.getAssistantName())
                .replace("#{sceneCode}", model.getSceneCode())
                .replace("#{sceneName}", model.getSceneName());

        if (null != model.getItemStepCode()) {
            content = content.replace("#{itemStepCode}", model.getItemStepCode())
                    .replace("#{itemStepName}", model.getItemStepName());
        }

        if (null != model.getAbilityCode()) {
            content = content.replace("#{abilityCode}", model.getAbilityCode());
        }

        if (null != model.getAbilityType()) {
            content = content.replace("#{abilityType}", model.getAbilityType());
        }

        if (-1 != model.getItemStepsLength()) {
            content = content.replace("#(itemStepsLength)", String.valueOf(model.getItemStepsLength()));
            content = content.replace("#(itemStepsLength+1)", String.valueOf(model.getItemStepsLength() + 1));
        }

        if (-1 != model.getItemStepNum()) {
            content = content.replace("#(itemStepNum)", String.valueOf(model.getItemStepNum()))
                    .replace("#(itemStepNum+1)", String.valueOf(model.getItemStepNum() + 1));
            ;
        }

        if (null != model.getSceneLang() && null != model.getSceneLang().getJSONObject("name")) {
            content = content.replace("#{sceneName_zhTW}", model.getSceneLang().getJSONObject("name").getString("zh_TW"))
                    .replace("#{sceneName_enUS}", model.getSceneLang().getJSONObject("name").getString("en_US"))
                    .replace("#{sceneName_zhCN}", model.getSceneLang().getJSONObject("name").getString("zh_CN"));
        } else {
            content = content.replace("#{sceneName_zhTW}", model.getSceneName())
                    .replace("#{sceneName_enUS}", model.getSceneName())
                    .replace("#{sceneName_zhCN}", model.getSceneName());
        }

        if (null != model.getItemStepLang() && null != model.getItemStepLang().getJSONObject("name")) {
            content = content.replace("#{itemStepName_zhTW}", model.getItemStepLang().getJSONObject("name").getString("zh_TW"))
                    .replace("#{itemStepName_enUS}", model.getItemStepLang().getJSONObject("name").getString("en_US"))
                    .replace("#{itemStepName_zhCN}", model.getItemStepLang().getJSONObject("name").getString("zh_CN"));
        } else if (null != model.getItemStepName()) {
            content = content.replace("#{itemStepName_zhTW}", model.getItemStepName())
                    .replace("#{itemStepName_enUS}", model.getItemStepName())
                    .replace("#{itemStepName_zhCN}", model.getItemStepName());
        }

        return initModel(content, model, cls);
    }

    /**
     * 模板基础处理
     *
     * @param filePath
     * @param model
     * @param cls
     * @return
     */
    protected T basicProcess(String filePath, CustomConfigModel model, Class<T> cls) {
        String content = processTemplate(filePath, model);
        return initModel(content, model, cls);
    }

    /**
     * 根据路径获取模板文件内容，并替换其中的code 与 name的占位符
     *
     * @param filePath
     * @param model
     * @return
     */
    protected String processTemplate(String filePath, CustomConfigModel model) {
        String processJson = getProcessJson(filePath);
        return processJson.replace("#{applicationCode}", model.getAssistantCode()).replace("#{sceneCode}", model.getSceneCode())
                .replace("#{sceneName}", model.getSceneName()).replace("#{itemStepCode}", model.getItemStepCode())
                .replace("#{itemStepName}", model.getItemStepName());
    }

    /**
     * 初始化模型对象，并塞入DataPackageAsa对象
     *
     * @param fileContent
     * @param model
     * @param cls
     * @return
     */
    protected T initModel(String fileContent, CustomConfigModel model, Class<T> cls) {
        T result;
        try {
            T t = cls.newInstance();
            //json是集合
            if (t instanceof CollectionModel) {
                List<?> rulesModels = JSON.parseObject(fileContent, List.class);
                CollectionModel collectionModel = (CollectionModel) t;
                collectionModel.setCollection(rulesModels);
                result = t;
            } else {
                result = JSON.parseObject(fileContent, cls);
            }
        } catch (Exception e) {
            throw new BusinessException("AbstractTemplate.initModel.newInstance error ");
        }
        return result;
    }

    protected String getProcessJson(String filePath) {
        String processJson = templateCaffeineCache.getIfPresent(filePath);
        if (StringUtils.isNotEmpty(processJson)) {
            return processJson;
        }
        processJson = FileUtils.readObjectFromFilePath(filePath, String.class);
        if (StringUtils.isNotEmpty(processJson)) {
            templateCaffeineCache.put(filePath, processJson);
        }
        return processJson;
    }

    public void addHeader(CustomConfigModel model, Map<String, Object> config) {
        Map<String, Object> headersMap = model.getHeaders();
        if (null != headersMap && !headersMap.isEmpty()) {
            Map headers = (Map) config.get("headers");
            headers.putAll(headersMap);
        }
    }

    protected void initTemplateList(String collectName, String dataType) {
        Stream<Path> paths = null;
        try {
            this.collectName = collectName;
            Path templatePath = null;
            String templatePathEnv = System.getenv("DOCKER_ENVIRONMENT");
            if (StrUtil.isNotBlank(templatePathEnv) && templatePathEnv.equals(Boolean.TRUE.toString())) {
                templatePath = Paths.get("template/asaDeployer");
                paths = Files.walk(templatePath);
            } else {
                ClassLoader classLoader = getClass().getClassLoader();
                URL resourceUrl = classLoader.getResource("template/asaDeployer");
                if(resourceUrl != null){
                    try {
                        templatePath = Paths.get(resourceUrl.toURI());
                        paths = Files.walk(templatePath);
                        // 继续原有逻辑...
                    } catch (Exception e) {
                        templatePath = null;
                       log.warn("获取文件目录错误:{}",e.getMessage());
                    }
                }
                if(templatePath == null){
                    try {
                        templatePath = Paths.get("src/main/resources/template/asaDeployer");
                        paths = Files.walk(templatePath);
                    } catch (Exception e) {
                        templatePath = Paths.get("km-deployer-service/src/main/resources/template/asaDeployer");
                        paths = Files.walk(templatePath);
                    }
                }

            }
            List<String> activityTemplateList = paths.filter(Files::isRegularFile)
                    .filter(path -> path.toString().contains(File.separator + dataType + File.separator))
                    .filter(path -> path.toString().endsWith(".json"))
                    .map(Path::toString)
                    .collect(Collectors.toList());
            initTemplateFunction(dataType, activityTemplateList);
        } catch (Exception e) {
            log.error("AbstractTemplate.initTemplateList error collectName:{}", collectName, e);
           // throw new BusinessException("初始化template模版失败");
        } finally {
            if (null != paths) {
                paths.close();
            }
        }
    }
}
