package com.digiwin.athena.km_deployer_service.template;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.base.AbilityEnum;
import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.ActivityModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.CustomConfigModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * Activity模板处理
 */
@Component("activityTemplate")
@Slf4j
public class ActivityTemplate extends AbstractTemplate<ActivityModel> {

    @PostConstruct
    public void init() {
        initTemplateList(AsaConstant.COLLECTION_NAME_ACTIVITY, TEMPLATE_DATA_TYPE_ACTIVITY);
    }

    protected ActivityModel initModel(String fileContent, CustomConfigModel model, Class<ActivityModel> cls) {
        JSONObject fileContentObject = JSONUtil.toBean(fileContent, JSONObject.class);
        String code = fileContentObject.getString("code");
        //api技能
        boolean addHeader = false;
        if (code.endsWith("_Api_CustomCall")) {
            addHeader = true;
            fileContent = fileContent
                    .replace("#{domain}", model.getDomain())
                    .replace("#{method}", model.getMethod())
                    .replace("#{ApiUrl}", model.getUrl())
                    .replace("#{contentType}", model.getContentType());
        } else if (code.endsWith("_Api_Call")) {
            addHeader = true;
            fileContent = fileContent
                    .replace("#{domain}", model.getDomain())
                    .replace("#{method}", model.getMethod())
                    .replace("#{ApiUrl}", model.getUrl())
                    .replace("#{contentType}", model.getContentType());
            if (StrUtil.isNotBlank(model.getRequestScript())) {
                String requestScript = StringEscapeUtils.escapeJson(model.getRequestScript());
                fileContent = fileContent.replace("#{requestScript}", requestScript);
            }
            if (StrUtil.isNotBlank(model.getResponseScript())) {
                String responseScript = StringEscapeUtils.escapeJson(model.getResponseScript());
                fileContent = fileContent.replace("#{responseScript}", responseScript);
            }
        }
        ActivityModel result = JSON.parseObject(fileContent, cls);
        if (addHeader) {
            addHeader(model, result.getConfig());
        }
        return result;
    }

    public void fillCustomConfigModel(CustomConfigModel defConfigModel, JSONObject assistantSceneItemStep) {
        String abilityCode = assistantSceneItemStep.getString("abilityCode");
        if (abilityCode.equals(AbilityEnum.OPENAPI.getAbilityCode())) {
            JSONObject config = assistantSceneItemStep.getJSONObject("config");
            JSONObject apiConfig = config.getJSONObject("apiconfig");
            JSONObject request = apiConfig.getJSONObject("request");
            JSONObject response = apiConfig.getJSONObject("response");

            defConfigModel.setDomain(request.getString("domain"));
            defConfigModel.setMethod(request.getString("method"));
            defConfigModel.setUrl(request.getString("url"));

            if (StrUtil.isBlank(request.getString("contentType"))) {
                defConfigModel.setContentType("json");
            } else {
                defConfigModel.setContentType(request.getString("contentType"));
            }
            defConfigModel.setHeaders(request.getJSONObject("headers"));

            if (StrUtil.isBlank(request.getString("requestScript"))) {
                defConfigModel.setRequestScript("var request={};return request;");
            } else {
                defConfigModel.setRequestScript(request.getString("requestScript"));
            }
            defConfigModel.setResponseScript(response.getString("responseScript"));
        }
    }
}
