package com.digiwin.athena.km_deployer_service.template;


import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.domain.asa.model.BaseModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.CustomConfigModel;

import java.util.List;

/**
 * @author hujun
 * @date 2023年1月18日 15:16:10
 */
public interface ITemplate<T extends BaseModel> {
    /** 助理场景模板 */
    String ASSISTANT_SCENE_TEMPLATE = "ASSISTANT_SCENE_TEMPLATE";

    /** 收集节点模板 */
    String COLLECT_ITEM_STEP_TEMPLATE = "COLLECT_ITEM_STEP_TEMPLATE";

    /** 协商节点模板 */
    String CONSULT_ITEM_STEP_TEMPLATE = "CONSULT_ITEM_STEP_TEMPLATE";

    /** 通知节点模板 */
    String NOTIFACATION_ITEM_STEP_TEMPLATE = "NOTIFACATION_ITEM_STEP_TEMPLATE";

    /** orc节点模板 */
    String BILL_ITEM_STEP_TEMPLATE = "BILL_ITEM_STEP_TEMPLATE";

    String CARD_ITEM_STEP_TEMPLATE = "CARD_ITEM_STEP_TEMPLATE";

    String MINUTES_TASK_TEMPLATE = "MINUTES_TASK_TEMPLATE";

    /**
     * api技能
     */
    String API_TASK_TEMPLATE="API_TASK_TEMPLATE";


    /**
     * 行程技能
     */
    String TRIP_TASK_TEMPLATE="TRIP_TASK_TEMPLATE";

    String TEMPLATE_DATA_TYPE_ACTIVITY = "activity";

    String TEMPLATE_DATA_TYPE_APP_RELATION = "applicationRelation";

    String TEMPLATE_DATA_TYPE_DATA_DESCRIPTION = "dataDescription";

    String TEMPLATE_DATA_TYPE_DATA_STATE = "dataState";

    String TEMPLATE_DATA_TYPE_PROJECT = "project";

    String TEMPLATE_DATA_TYPE_FLOW_GRAPH = "flowGraph";

    String TEMPLATE_DATA_TYPE_PAGE_VIEW = "pageView";

    String TEMPLATE_DATA_TYPE_RULES = "rules";

    String TEMPLATE_DATA_TYPE_TASK = "task";

    String TEMPLATE_DATA_TYPE_DATA_FEATURE_SET = "dataFeatureSet";

    String FORM_TASK_TEMPLATE = "FORM_TASK_TEMPLATE";

    String SCHEDULE_DELETE_TEMPLATE = "SCHEDULE_DELETE_TASK_TEMPLATE";

    String SCHEDULE_QUERY_TEMPLATE = "SCHEDULE_QUERY_TASK_TEMPLATE";

    String SCHEDULE_UPDATE_TEMPLATE = "SCHEDULE_UPDATE_TASK_TEMPLATE";

    /** 自然语言收集节点模板 */
    String TEXT_COLLECT_ITEM_STEP_TEMPLATE = "TEXT_COLLECT_ITEM_STEP_TEMPLATE";

    String LLM_CALL_TEMPLATE="LLM_TASK_TEMPLATE";

    /**
     * 获取各组件 mongoCollectName
     * @return
     */
    String getCollectName();

    /**
     * 模板接口规格定义，用于统一处理模板的生成流程
     *
     * @param model
     * @return
     */
    List<T> generate(CustomConfigModel model);

    /**
     * 模板增加CustomConfigModel参数
     *
     * @param defConfigModel
     * @param assistantSceneItemStep
     */
    void fillCustomConfigModel(CustomConfigModel defConfigModel, JSONObject assistantSceneItemStep);
}
