package com.digiwin.athena.km_deployer_service.template;

import cn.hutool.core.map.MapUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.km_deployer_service.base.AbilityEnum;
import com.digiwin.athena.km_deployer_service.constant.AsaConstant;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.CustomConfigModel;
import com.digiwin.athena.km_deployer_service.domain.asa.model.mongodb.TaskModel;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Objects;

/**
 * Task模板处理
 */
@Slf4j
@Component("taskTemplate")
public class TaskTemplate extends AbstractTemplate<TaskModel> {

    @PostConstruct
    public void init() {
        initTemplateList(AsaConstant.COLLECTION_NAME_TASK, TEMPLATE_DATA_TYPE_TASK);
    }

    @Override
    protected TaskModel initModel(String fileContent, CustomConfigModel model, Class<TaskModel> cls) {
        JSONObject assistantSceneItemStep = model.getAssistantSceneItemStep();
        if (Objects.nonNull(assistantSceneItemStep)) {
            String abilityCode = assistantSceneItemStep.getString("abilityCode");
            if (AbilityEnum.FORMTASK.getAbilityCode().equals(abilityCode)) {
                JSONObject config = assistantSceneItemStep.getJSONObject("config");
                String generalFormDataSource = config.getString("outputElement");
                JSONObject fileContentObject = JSONUtil.toBean(fileContent, JSONObject.class);
                String code = fileContentObject.getString("code");
                if (StringUtils.isNotBlank(generalFormDataSource) &&
                        (code.endsWith("_GeneralForm_Filling") || code.endsWith("_GeneralForm_UserFilling"))) {
                    fileContent = fileContent
                            .replace("#{generalFormDataSource}", generalFormDataSource);
                }
            }
        }
        return JSON.parseObject(fileContent, cls);
    }

}
